
import numpy as np


def rotate_point(X, angle_degrees):
    """Rotates points around the origin by an angle.

    Args:
        X (np.ndarray): Array of size (n_samples, n_features), each point is a row and each feature
        a column.
        angle_degrees (float): Angle to rotate points. Must be defined in degrees.

    Returns:
        np.ndarray: Array of size (n_samples, n_features) with rotated points from input X.
    """
    # X tiene que venir en la forma (n_samples, 2)
    angle_rads = np.deg2rad(angle_degrees)
    rot_matrix = np.array([[np.cos(angle_rads), -np.sin(angle_rads)], [np.sin(angle_rads), np.cos(angle_rads)]])
    return np.matmul(rot_matrix, X.T).T
