/*
 * Decompiled with CFR 0.152.
 */
package jline.internal;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import jline.internal.Configuration;
import jline.internal.Preconditions;
import jline.internal.TestAccessible;

public final class Log {
    public static final boolean TRACE = Configuration.getBoolean(Log.class.getName() + ".trace");
    public static final boolean DEBUG = TRACE || Configuration.getBoolean(Log.class.getName() + ".debug");
    private static PrintStream output = System.err;
    private static boolean useJul = Configuration.getBoolean("jline.log.jul");

    public static PrintStream getOutput() {
        return output;
    }

    public static void setOutput(PrintStream printStream) {
        output = Preconditions.checkNotNull(printStream);
    }

    @TestAccessible
    static void render(PrintStream printStream, Object object) {
        if (object.getClass().isArray()) {
            Object[] objectArray = (Object[])object;
            printStream.print("[");
            for (int i = 0; i < objectArray.length; ++i) {
                printStream.print(objectArray[i]);
                if (i + 1 >= objectArray.length) continue;
                printStream.print(",");
            }
            printStream.print("]");
        } else {
            printStream.print(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestAccessible
    static void log(Level level, Object ... objectArray) {
        if (useJul) {
            Log.logWithJul(level, objectArray);
            return;
        }
        PrintStream printStream = output;
        synchronized (printStream) {
            output.format("[%s] ", new Object[]{level});
            for (int i = 0; i < objectArray.length; ++i) {
                if (i + 1 == objectArray.length && objectArray[i] instanceof Throwable) {
                    output.println();
                    ((Throwable)objectArray[i]).printStackTrace(output);
                    continue;
                }
                Log.render(output, objectArray[i]);
            }
            output.println();
            output.flush();
        }
    }

    static void logWithJul(Level level, Object ... objectArray) {
        Logger logger = Logger.getLogger("jline");
        Throwable throwable = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        for (int i = 0; i < objectArray.length; ++i) {
            if (i + 1 == objectArray.length && objectArray[i] instanceof Throwable) {
                throwable = (Throwable)objectArray[i];
                continue;
            }
            Log.render(printStream, objectArray[i]);
        }
        printStream.close();
        LogRecord logRecord = new LogRecord(Log.toJulLevel(level), byteArrayOutputStream.toString());
        logRecord.setThrown(throwable);
        logger.log(logRecord);
    }

    private static java.util.logging.Level toJulLevel(Level level) {
        switch (level) {
            case TRACE: {
                return java.util.logging.Level.FINEST;
            }
            case DEBUG: {
                return java.util.logging.Level.FINE;
            }
            case INFO: {
                return java.util.logging.Level.INFO;
            }
            case WARN: {
                return java.util.logging.Level.WARNING;
            }
            case ERROR: {
                return java.util.logging.Level.SEVERE;
            }
        }
        throw new IllegalArgumentException();
    }

    public static void trace(Object ... objectArray) {
        if (TRACE) {
            Log.log(Level.TRACE, objectArray);
        }
    }

    public static void debug(Object ... objectArray) {
        if (TRACE || DEBUG) {
            Log.log(Level.DEBUG, objectArray);
        }
    }

    public static void info(Object ... objectArray) {
        Log.log(Level.INFO, objectArray);
    }

    public static void warn(Object ... objectArray) {
        Log.log(Level.WARN, objectArray);
    }

    public static void error(Object ... objectArray) {
        Log.log(Level.ERROR, objectArray);
    }

    public static enum Level {
        TRACE,
        DEBUG,
        INFO,
        WARN,
        ERROR;

    }
}

