/*
 * Decompiled with CFR 0.152.
 */
package jline.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.MalformedInputException;
import java.nio.charset.UnmappableCharacterException;

public class InputStreamReader
extends Reader {
    private InputStream in;
    private static final int BUFFER_SIZE = 8192;
    private boolean endOfInput = false;
    CharsetDecoder decoder;
    ByteBuffer bytes = ByteBuffer.allocate(8192);

    public InputStreamReader(InputStream inputStream) {
        super(inputStream);
        this.in = inputStream;
        this.decoder = Charset.defaultCharset().newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        ((Buffer)this.bytes).limit(0);
    }

    public InputStreamReader(InputStream inputStream, String string) throws UnsupportedEncodingException {
        super(inputStream);
        if (string == null) {
            throw new NullPointerException();
        }
        this.in = inputStream;
        try {
            this.decoder = Charset.forName(string).newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw (UnsupportedEncodingException)new UnsupportedEncodingException(string).initCause(illegalArgumentException);
        }
        ((Buffer)this.bytes).limit(0);
    }

    public InputStreamReader(InputStream inputStream, CharsetDecoder charsetDecoder) {
        super(inputStream);
        charsetDecoder.averageCharsPerByte();
        this.in = inputStream;
        this.decoder = charsetDecoder;
        ((Buffer)this.bytes).limit(0);
    }

    public InputStreamReader(InputStream inputStream, Charset charset) {
        super(inputStream);
        this.in = inputStream;
        this.decoder = charset.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        ((Buffer)this.bytes).limit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.decoder = null;
            if (this.in != null) {
                this.in.close();
                this.in = null;
            }
        }
    }

    public String getEncoding() {
        if (!this.isOpen()) {
            return null;
        }
        return this.decoder.charset().name();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new IOException("InputStreamReader is closed.");
            }
            char[] cArray = new char[4];
            int n = this.read(cArray, 0, 4) != -1 ? Character.codePointAt(cArray, 0) : -1;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(char[] cArray, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            boolean bl;
            if (!this.isOpen()) {
                throw new IOException("InputStreamReader is closed.");
            }
            if (n < 0 || n > cArray.length - n2 || n2 < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (n2 == 0) {
                return 0;
            }
            CharBuffer charBuffer = CharBuffer.wrap(cArray, n, n2);
            CoderResult coderResult = CoderResult.UNDERFLOW;
            boolean bl2 = bl = !this.bytes.hasRemaining();
            while (charBuffer.hasRemaining()) {
                if (bl) {
                    try {
                        if (this.in.available() == 0 && charBuffer.position() > n) {
                            break;
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    int n3 = this.bytes.capacity() - this.bytes.limit();
                    int n4 = this.bytes.arrayOffset() + this.bytes.limit();
                    int n5 = this.in.read(this.bytes.array(), n4, n3);
                    if (n5 == -1) {
                        this.endOfInput = true;
                        break;
                    }
                    if (n5 == 0) break;
                    ((Buffer)this.bytes).limit(this.bytes.limit() + n5);
                    bl = false;
                }
                if (!(coderResult = this.decoder.decode(this.bytes, charBuffer, false)).isUnderflow()) break;
                if (this.bytes.limit() == this.bytes.capacity()) {
                    this.bytes.compact();
                    ((Buffer)this.bytes).limit(this.bytes.position());
                    ((Buffer)this.bytes).position(0);
                }
                bl = true;
            }
            if (coderResult == CoderResult.UNDERFLOW && this.endOfInput) {
                coderResult = this.decoder.decode(this.bytes, charBuffer, true);
                this.decoder.flush(charBuffer);
                this.decoder.reset();
            }
            if (coderResult.isMalformed()) {
                throw new MalformedInputException(coderResult.length());
            }
            if (coderResult.isUnmappable()) {
                throw new UnmappableCharacterException(coderResult.length());
            }
            return charBuffer.position() - n == 0 ? -1 : charBuffer.position() - n;
        }
    }

    private boolean isOpen() {
        return this.in != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean ready() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.in == null) {
                throw new IOException("InputStreamReader is closed.");
            }
            try {
                return this.bytes.hasRemaining() || this.in.available() > 0;
            }
            catch (IOException iOException) {
                return false;
            }
        }
    }
}

