/*
 * Decompiled with CFR 0.152.
 */
package jline;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jline.Terminal2;
import jline.TerminalSupport;
import jline.internal.Configuration;
import jline.internal.InfoCmp;
import jline.internal.Log;
import jline.internal.Preconditions;
import jline.internal.TerminalLineSettings;

public class UnixTerminal
extends TerminalSupport
implements Terminal2 {
    private final TerminalLineSettings settings;
    private final String type;
    private String intr;
    private String lnext;
    private Set<String> bools = new HashSet<String>();
    private Map<String, Integer> ints = new HashMap<String, Integer>();
    private Map<String, String> strings = new HashMap<String, String>();

    public UnixTerminal() throws Exception {
        this("/dev/tty", null);
    }

    public UnixTerminal(String string) throws Exception {
        this(string, null);
    }

    public UnixTerminal(String string, String string2) throws Exception {
        super(true);
        Preconditions.checkNotNull(string);
        this.settings = TerminalLineSettings.getSettings(string);
        if (string2 == null) {
            string2 = System.getenv("TERM");
        }
        this.type = string2;
        this.parseInfoCmp();
    }

    public TerminalLineSettings getSettings() {
        return this.settings;
    }

    @Override
    public void init() throws Exception {
        super.init();
        this.setAnsiSupported(true);
        if (Configuration.getOsName().contains("freebsd")) {
            this.settings.set("-icanon min 1 -inlcr -ixon");
        } else {
            this.settings.set("-icanon min 1 -icrnl -inlcr -ixon");
        }
        this.settings.undef("dsusp");
        this.setEchoEnabled(false);
        this.parseInfoCmp();
    }

    @Override
    public void restore() throws Exception {
        this.settings.restore();
        super.restore();
    }

    @Override
    public int getWidth() {
        int n = this.settings.getProperty("columns");
        return n < 1 ? 80 : n;
    }

    @Override
    public int getHeight() {
        int n = this.settings.getProperty("rows");
        return n < 1 ? 24 : n;
    }

    @Override
    public boolean hasWeirdWrap() {
        return this.getBooleanCapability("auto_right_margin") && this.getBooleanCapability("eat_newline_glitch");
    }

    @Override
    public synchronized void setEchoEnabled(boolean bl) {
        try {
            if (bl) {
                this.settings.set("echo");
            } else {
                this.settings.set("-echo");
            }
            super.setEchoEnabled(bl);
        }
        catch (Exception exception) {
            if (exception instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            Log.error("Failed to ", bl ? "enable" : "disable", " echo", exception);
        }
    }

    @Override
    public void disableInterruptCharacter() {
        try {
            this.intr = this.getSettings().getPropertyAsString("intr");
            if ("<undef>".equals(this.intr)) {
                this.intr = null;
            }
            this.settings.undef("intr");
        }
        catch (Exception exception) {
            if (exception instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            Log.error("Failed to disable interrupt character", exception);
        }
    }

    @Override
    public void enableInterruptCharacter() {
        try {
            if (this.intr != null) {
                this.settings.set("intr", this.intr);
            }
        }
        catch (Exception exception) {
            if (exception instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            Log.error("Failed to enable interrupt character", exception);
        }
    }

    public void disableLitteralNextCharacter() {
        try {
            this.lnext = this.getSettings().getPropertyAsString("lnext");
            if ("<undef>".equals(this.lnext)) {
                this.lnext = null;
            }
            this.settings.undef("lnext");
        }
        catch (Exception exception) {
            if (exception instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            Log.error("Failed to disable litteral next character", exception);
        }
    }

    public void enableLitteralNextCharacter() {
        try {
            if (this.lnext != null) {
                this.settings.set("lnext", this.lnext);
            }
        }
        catch (Exception exception) {
            if (exception instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            Log.error("Failed to enable litteral next character", exception);
        }
    }

    @Override
    public boolean getBooleanCapability(String string) {
        return this.bools.contains(string);
    }

    @Override
    public Integer getNumericCapability(String string) {
        return this.ints.get(string);
    }

    @Override
    public String getStringCapability(String string) {
        return this.strings.get(string);
    }

    private void parseInfoCmp() {
        String string = null;
        if (this.type != null) {
            try {
                string = InfoCmp.getInfoCmp(this.type);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (string == null) {
            string = InfoCmp.getAnsiCaps();
        }
        InfoCmp.parseInfoCmp(string, this.bools, this.ints, this.strings);
    }
}

