/*
 * Decompiled with CFR 0.152.
 */
package jline;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import jline.Terminal;
import jline.TerminalFactory;
import jline.internal.Log;
import jline.internal.ShutdownHooks;

public abstract class TerminalSupport
implements Terminal {
    public static final int DEFAULT_WIDTH = 80;
    public static final int DEFAULT_HEIGHT = 24;
    private ShutdownHooks.Task shutdownTask;
    private boolean supported;
    private boolean echoEnabled;
    private boolean ansiSupported;

    protected TerminalSupport(boolean bl) {
        this.supported = bl;
    }

    @Override
    public void init() throws Exception {
        if (this.shutdownTask != null) {
            ShutdownHooks.remove(this.shutdownTask);
        }
        this.shutdownTask = ShutdownHooks.add(new ShutdownHooks.Task(){

            @Override
            public void run() throws Exception {
                TerminalSupport.this.restore();
            }
        });
    }

    @Override
    public void restore() throws Exception {
        TerminalFactory.resetIf(this);
        if (this.shutdownTask != null) {
            ShutdownHooks.remove(this.shutdownTask);
            this.shutdownTask = null;
        }
    }

    @Override
    public void reset() throws Exception {
        this.restore();
        this.init();
    }

    @Override
    public final boolean isSupported() {
        return this.supported;
    }

    @Override
    public synchronized boolean isAnsiSupported() {
        return this.ansiSupported;
    }

    protected synchronized void setAnsiSupported(boolean bl) {
        this.ansiSupported = bl;
        Log.debug("Ansi supported: ", bl);
    }

    @Override
    public OutputStream wrapOutIfNeeded(OutputStream outputStream) {
        return outputStream;
    }

    @Override
    public boolean hasWeirdWrap() {
        return true;
    }

    @Override
    public int getWidth() {
        return 80;
    }

    @Override
    public int getHeight() {
        return 24;
    }

    @Override
    public synchronized boolean isEchoEnabled() {
        return this.echoEnabled;
    }

    @Override
    public synchronized void setEchoEnabled(boolean bl) {
        this.echoEnabled = bl;
        Log.debug("Echo enabled: ", bl);
    }

    @Override
    public void disableInterruptCharacter() {
    }

    @Override
    public void enableInterruptCharacter() {
    }

    @Override
    public InputStream wrapInIfNeeded(InputStream inputStream) throws IOException {
        return inputStream;
    }

    @Override
    public String getOutputEncoding() {
        return null;
    }
}

