/*
 * Decompiled with CFR 0.152.
 */
package jline;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jline.Terminal;
import jline.Terminal2;
import jline.internal.InfoCmp;

public class DefaultTerminal2
implements Terminal2 {
    private final Terminal terminal;
    private final Set<String> bools = new HashSet<String>();
    private final Map<String, String> strings = new HashMap<String, String>();

    public DefaultTerminal2(Terminal terminal) {
        this.terminal = terminal;
        this.registerCap("key_backspace", "^H");
        this.registerCap("bell", "^G");
        this.registerCap("carriage_return", "^M");
        if (this.isSupported() && this.isAnsiSupported()) {
            this.registerCap("clr_eol", "\\E[K");
            this.registerCap("clr_bol", "\\E[1K");
            this.registerCap("cursor_up", "\\E[A");
            this.registerCap("cursor_down", "^J");
            this.registerCap("column_address", "\\E[%i%p1%dG");
            this.registerCap("clear_screen", "\\E[H\\E[2J");
            this.registerCap("parm_down_cursor", "\\E[%p1%dB");
            this.registerCap("cursor_left", "^H");
            this.registerCap("cursor_right", "\\E[C");
        }
        if (this.hasWeirdWrap()) {
            this.registerCap("eat_newline_glitch");
            this.registerCap("auto_right_margin");
        }
    }

    @Override
    public void init() throws Exception {
        this.terminal.init();
    }

    @Override
    public void restore() throws Exception {
        this.terminal.restore();
    }

    @Override
    public void reset() throws Exception {
        this.terminal.reset();
    }

    @Override
    public boolean isSupported() {
        return this.terminal.isSupported();
    }

    @Override
    public int getWidth() {
        return this.terminal.getWidth();
    }

    @Override
    public int getHeight() {
        return this.terminal.getHeight();
    }

    @Override
    public boolean isAnsiSupported() {
        return this.terminal.isAnsiSupported();
    }

    @Override
    public OutputStream wrapOutIfNeeded(OutputStream outputStream) {
        return this.terminal.wrapOutIfNeeded(outputStream);
    }

    @Override
    public InputStream wrapInIfNeeded(InputStream inputStream) throws IOException {
        return this.terminal.wrapInIfNeeded(inputStream);
    }

    @Override
    public boolean hasWeirdWrap() {
        return this.terminal.hasWeirdWrap();
    }

    @Override
    public boolean isEchoEnabled() {
        return this.terminal.isEchoEnabled();
    }

    @Override
    public void setEchoEnabled(boolean bl) {
        this.terminal.setEchoEnabled(bl);
    }

    @Override
    public void disableInterruptCharacter() {
        this.terminal.disableInterruptCharacter();
    }

    @Override
    public void enableInterruptCharacter() {
        this.terminal.enableInterruptCharacter();
    }

    @Override
    public String getOutputEncoding() {
        return this.terminal.getOutputEncoding();
    }

    private void registerCap(String string, String string2) {
        for (String string3 : InfoCmp.getNames(string)) {
            this.strings.put(string3, string2);
        }
    }

    private void registerCap(String string) {
        Collections.addAll(this.bools, InfoCmp.getNames(string));
    }

    @Override
    public boolean getBooleanCapability(String string) {
        return this.bools.contains(string);
    }

    @Override
    public Integer getNumericCapability(String string) {
        return null;
    }

    @Override
    public String getStringCapability(String string) {
        return this.strings.get(string);
    }
}

