/*
 * Decompiled with CFR 0.152.
 */
package jline;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import jline.WindowsTerminal;
import jline.internal.Configuration;
import org.fusesource.jansi.AnsiColors;
import org.fusesource.jansi.AnsiMode;
import org.fusesource.jansi.AnsiType;
import org.fusesource.jansi.io.AnsiOutputStream;
import org.fusesource.jansi.io.AnsiProcessor;

public class AnsiWindowsTerminal
extends WindowsTerminal {
    private final boolean ansiSupported = AnsiWindowsTerminal.detectAnsiSupport();

    @Override
    public OutputStream wrapOutIfNeeded(OutputStream outputStream) {
        return AnsiWindowsTerminal.wrapOutputStream(outputStream);
    }

    private static OutputStream wrapOutputStream(OutputStream outputStream) {
        if (Configuration.isWindows()) {
            try {
                return new WindowsAnsiOutputStream(outputStream);
            }
            catch (Throwable throwable) {
                return new AnsiOutputStream(outputStream, AnsiMode.Strip, new AnsiProcessor(outputStream), AnsiType.Emulation, AnsiColors.TrueColor, Charset.defaultCharset(), null, null, false);
            }
        }
        return outputStream;
    }

    private static boolean detectAnsiSupport() {
        try {
            WindowsAnsiOutputStream windowsAnsiOutputStream = new WindowsAnsiOutputStream(new ByteArrayOutputStream());
            try {
                ((OutputStream)((Object)windowsAnsiOutputStream)).close();
                return true;
            }
            catch (Exception exception) {
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @Override
    public boolean isAnsiSupported() {
        return this.ansiSupported;
    }

    @Override
    public boolean hasWeirdWrap() {
        return false;
    }

    private static class WindowsAnsiOutputStream
    extends AnsiOutputStream {
        WindowsAnsiOutputStream(OutputStream outputStream) {
            super(outputStream, AnsiMode.Strip, new AnsiProcessor(outputStream), AnsiType.Emulation, AnsiColors.TrueColor, Charset.defaultCharset(), null, null, false);
        }
    }
}

