/*
 * Decompiled with CFR 0.152.
 */
package monix.eval.internal;

import java.io.Serializable;
import java.util.concurrent.TimeoutException;
import monix.eval.Task;
import monix.eval.Task$Context$;
import monix.eval.internal.StackFrame;
import monix.eval.internal.TaskRestartCallback;
import monix.eval.internal.TaskRestartCallback$;
import monix.eval.internal.TaskRunLoop$;
import monix.eval.internal.TaskRunSyncUnsafe;
import monix.execution.Scheduler;
import monix.execution.internal.collection.ChunkedArrayStack;
import monix.execution.internal.collection.ChunkedArrayStack$;
import scala.Function0;
import scala.Function1;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

public final class TaskRunSyncUnsafe$ {
    public static TaskRunSyncUnsafe$ MODULE$;

    static {
        new TaskRunSyncUnsafe$();
    }

    public <A> A apply(Task<A> source, Duration timeout, Scheduler scheduler, Task.Options opts) {
        Task current = source;
        Task.Map bFirst = null;
        ChunkedArrayStack bRest = null;
        boolean hasUnboxed = false;
        Object unboxed = null;
        while (true) {
            BoxedUnit boxedUnit;
            Task<Object> task;
            if ((task = current) instanceof Task.FlatMap) {
                Task.FlatMap flatMap = (Task.FlatMap)task;
                Task fa = flatMap.source();
                Task.Map bindNext = flatMap.f();
                if (bFirst != null) {
                    if (bRest == null) {
                        bRest = ChunkedArrayStack$.MODULE$.apply(ChunkedArrayStack$.MODULE$.apply$default$1());
                    }
                    bRest.push(bFirst);
                }
                bFirst = bindNext;
                current = fa;
                boxedUnit = BoxedUnit.UNIT;
            } else if (task instanceof Task.Now) {
                Task.Now now = (Task.Now)task;
                Object value = now.value();
                unboxed = value;
                hasUnboxed = true;
                boxedUnit = BoxedUnit.UNIT;
            } else if (task instanceof Task.Eval) {
                BoxedUnit boxedUnit2;
                Task.Eval eval = (Task.Eval)task;
                Function0 thunk = eval.thunk();
                try {
                    unboxed = thunk.apply();
                    hasUnboxed = true;
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (!NonFatal$.MODULE$.apply(throwable2)) {
                        throw throwable;
                    }
                    current = new Task.Error(throwable2);
                    BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                boxedUnit = boxedUnit2;
            } else if (task instanceof Task.Map) {
                Task.Map map = (Task.Map)task;
                Task fa = map.source();
                if (bFirst != null) {
                    if (bRest == null) {
                        bRest = ChunkedArrayStack$.MODULE$.apply(ChunkedArrayStack$.MODULE$.apply$default$1());
                    }
                    bRest.push((Object)bFirst);
                }
                bFirst = map;
                current = fa;
                boxedUnit = BoxedUnit.UNIT;
            } else if (task instanceof Task.Suspend) {
                BoxedUnit boxedUnit4;
                Task.Suspend suspend = (Task.Suspend)task;
                Function0 thunk = suspend.thunk();
                try {
                    current = (Task.Error)thunk.apply();
                    boxedUnit4 = BoxedUnit.UNIT;
                }
                catch (Throwable throwable) {
                    Throwable throwable3 = throwable;
                    if (!NonFatal$.MODULE$.apply(throwable3)) {
                        throw throwable;
                    }
                    current = new Task.Error(throwable3);
                    BoxedUnit boxedUnit5 = BoxedUnit.UNIT;
                    boxedUnit4 = BoxedUnit.UNIT;
                }
                boxedUnit = boxedUnit4;
            } else if (task instanceof Task.Error) {
                Task.Error error = (Task.Error)task;
                Throwable error2 = error.e();
                StackFrame<Object, Task<Object>> stackFrame = TaskRunLoop$.MODULE$.findErrorHandler(bFirst, (ChunkedArrayStack<Function1<Object, Task<Object>>>)bRest);
                if (stackFrame == null) {
                    throw error2;
                }
                try {
                    current = stackFrame.recover(error2);
                }
                catch (Throwable throwable) {
                    Throwable throwable4 = throwable;
                    if (NonFatal$.MODULE$.apply(throwable4)) {
                        current = new Task.Error(throwable4);
                        BoxedUnit boxedUnit6 = BoxedUnit.UNIT;
                    }
                    throw throwable;
                }
                bFirst = null;
                BoxedUnit boxedUnit7 = BoxedUnit.UNIT;
                boxedUnit = BoxedUnit.UNIT;
            } else {
                return this.blockForResult(task, timeout, scheduler, opts, bFirst, (ChunkedArrayStack<Function1<Object, Task<Object>>>)bRest);
            }
            if (!hasUnboxed) continue;
            Function1<Object, Task<Object>> function1 = TaskRunLoop$.MODULE$.popNextBind(bFirst, (ChunkedArrayStack<Function1<Object, Task<Object>>>)bRest);
            if (function1 == null) {
                return (A)unboxed;
            }
            try {
                current = (Task)function1.apply(unboxed);
            }
            catch (Throwable throwable) {
                Throwable throwable5 = throwable;
                if (NonFatal$.MODULE$.apply(throwable5)) {
                    current = new Task.Error(throwable5);
                    BoxedUnit boxedUnit8 = BoxedUnit.UNIT;
                }
                throw throwable;
            }
            hasUnboxed = false;
            unboxed = null;
            bFirst = null;
            BoxedUnit boxedUnit9 = BoxedUnit.UNIT;
        }
    }

    private <A> A blockForResult(Task<Object> source, Duration limit, Scheduler scheduler, Task.Options opts, Function1<Object, Task<Object>> bFirst, ChunkedArrayStack<Function1<Object, Task<Object>>> bRest) {
        boolean bl;
        TaskRunSyncUnsafe.OneShotLatch latch = new TaskRunSyncUnsafe.OneShotLatch();
        TaskRunSyncUnsafe.BlockingCallback<Object> cb = new TaskRunSyncUnsafe.BlockingCallback<Object>(latch);
        Task.Context context = Task$Context$.MODULE$.apply(scheduler, opts);
        TaskRestartCallback rcb = TaskRestartCallback$.MODULE$.apply(context, cb);
        Task<Object> task = source;
        if (task instanceof Task.Async) {
            Task.Async async = (Task.Async)task;
            TaskRunLoop$.MODULE$.executeAsyncTask(async, context, cb, rcb, bFirst, bRest, 1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            TaskRunLoop$.MODULE$.startFull(source, context, cb, rcb, bFirst, bRest, 1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        Duration duration = limit;
        if (duration == Duration$.MODULE$.Undefined()) {
            throw new IllegalArgumentException("Cannot wait for Undefined period");
        }
        Duration.Infinite infinite = Duration$.MODULE$.Inf();
        Duration duration2 = duration;
        if (!(infinite != null ? !infinite.equals(duration2) : duration2 != null)) {
            package$.MODULE$.blocking((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> latch.acquireSharedInterruptibly(1));
            bl = true;
        } else {
            FiniteDuration finiteDuration;
            bl = duration instanceof FiniteDuration && (finiteDuration = (FiniteDuration)duration).$greater((Object)Duration$.MODULE$.Zero()) ? BoxesRunTime.unboxToBoolean((Object)package$.MODULE$.blocking((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> latch.tryAcquireSharedNanos(1, finiteDuration.toNanos()))) : false;
        }
        boolean isFinished = bl;
        if (!isFinished) {
            throw new TimeoutException(new StringBuilder(20).append("Task.runSyncUnsafe(").append(limit).append(")").toString());
        }
        return (A)cb.value();
    }

    private TaskRunSyncUnsafe$() {
        MODULE$ = this;
    }
}

