/*
 * Decompiled with CFR 0.152.
 */
package com.sourcegraph.semanticdb_javac;

import com.sourcegraph.semanticdb_javac.CompilationUnitException;
import com.sourcegraph.semanticdb_javac.GlobalSymbolsCache;
import com.sourcegraph.semanticdb_javac.Result;
import com.sourcegraph.semanticdb_javac.Semanticdb;
import com.sourcegraph.semanticdb_javac.SemanticdbJavacOptions;
import com.sourcegraph.semanticdb_javac.SemanticdbReporter;
import com.sourcegraph.semanticdb_javac.SemanticdbVisitor;
import com.sourcegraph.semanticdb_javac.UriScheme;
import com.sun.source.util.JavacTask;
import com.sun.source.util.TaskEvent;
import com.sun.source.util.TaskListener;
import com.sun.source.util.Trees;
import com.sun.tools.javac.model.JavacTypes;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

public final class SemanticdbTaskListener
implements TaskListener {
    private final SemanticdbJavacOptions options;
    private final JavacTask task;
    private final GlobalSymbolsCache globals;
    private final SemanticdbReporter reporter;
    private final JavacTypes javacTypes;
    private final Trees trees;

    public SemanticdbTaskListener(SemanticdbJavacOptions options, JavacTask task, GlobalSymbolsCache globals, SemanticdbReporter reporter, JavacTypes javacTypes) {
        this.options = options;
        this.task = task;
        this.globals = globals;
        this.reporter = reporter;
        this.javacTypes = javacTypes;
        this.trees = Trees.instance(task);
    }

    @Override
    public void started(TaskEvent e) {
    }

    @Override
    public void finished(TaskEvent e) {
        if (e.getKind() != TaskEvent.Kind.ANALYZE) {
            return;
        }
        if (!this.options.errors.isEmpty()) {
            if (!this.options.alreadyReportedErrors) {
                this.options.alreadyReportedErrors = true;
                for (String error : this.options.errors) {
                    this.trees.printMessage(Diagnostic.Kind.ERROR, "semanticdb-javac: " + error, e.getCompilationUnit(), e.getCompilationUnit());
                }
            }
            return;
        }
        this.inferBazelSourceroot(e.getSourceFile());
        try {
            this.onFinishedAnalyze(e);
        }
        catch (Throwable ex) {
            Throwable throwable = ex;
            if (e.getSourceFile() != null) {
                throwable = new CompilationUnitException(String.valueOf(e.getSourceFile().toUri().toString()), throwable);
            }
            this.reporter.exception(throwable, e.getCompilationUnit(), e.getCompilationUnit());
            throw new RuntimeException("boom", throwable);
        }
    }

    private void onFinishedAnalyze(TaskEvent e) {
        Result<Path, String> path = this.semanticdbOutputPath(this.options, e);
        if (path.isOk()) {
            Semanticdb.TextDocument textDocument = new SemanticdbVisitor(this.task, this.globals, e, this.options, this.javacTypes).buildTextDocument(e.getCompilationUnit());
            this.writeSemanticdb(e, path.getOrThrow(), textDocument);
        } else {
            this.reporter.error(path.getErrorOrThrow(), e.getCompilationUnit(), e.getCompilationUnit());
        }
    }

    private void writeSemanticdb(TaskEvent event, Path output, Semanticdb.TextDocument textDocument) {
        try {
            byte[] bytes = Semanticdb.TextDocuments.newBuilder().addDocuments(textDocument).build().toByteArray();
            Files.createDirectories(output.getParent(), new FileAttribute[0]);
            Files.write(output, bytes, new OpenOption[0]);
        }
        catch (IOException e) {
            this.reporter.exception(e, event.getCompilationUnit(), event.getCompilationUnit());
        }
    }

    public static Path absolutePathFromUri(SemanticdbJavacOptions options, JavaFileObject file) {
        URI uri = file.toUri();
        if ((options.uriScheme == UriScheme.SBT || options.uriScheme == UriScheme.ZINC) && uri.getScheme().equals("vf") && uri.toString().startsWith("vf://tmp/")) {
            String[] parts = uri.toString().split("/", 5);
            if (parts.length == 5) {
                return options.sourceroot.resolve(Paths.get(parts[4], new String[0]));
            }
            throw new IllegalArgumentException("unsupported URI: " + uri);
        }
        if (options.uriScheme == UriScheme.BAZEL) {
            String toString = file.toString();
            if (toString.startsWith("SimpleFileObject[") && toString.endsWith("]")) {
                return Paths.get(toString.substring("SimpleFileObject[".length(), toString.length() - 1), new String[0]);
            }
            throw new IllegalArgumentException("unsupported source file: " + toString);
        }
        return Paths.get(uri);
    }

    private void inferBazelSourceroot(JavaFileObject file) {
        String pathName;
        String uriName;
        int relativePathDepth;
        if (this.options.uriScheme != UriScheme.BAZEL || this.options.sourceroot != null) {
            return;
        }
        Path absolutePath = SemanticdbTaskListener.absolutePathFromUri(this.options, file);
        Path uriPath = Paths.get(file.toUri());
        int uriPathDepth = uriPath.getNameCount();
        int absolutePathDepth = absolutePath.getNameCount();
        for (relativePathDepth = 0; relativePathDepth < uriPathDepth && relativePathDepth < absolutePathDepth && (uriName = uriPath.getName(uriPathDepth - relativePathDepth - 1).toString()).equals(pathName = absolutePath.getName(absolutePathDepth - relativePathDepth - 1).toString()); ++relativePathDepth) {
        }
        this.options.sourceroot = absolutePath.getRoot().resolve(absolutePath.subpath(0, absolutePathDepth - relativePathDepth));
    }

    private Result<Path, String> semanticdbOutputPath(SemanticdbJavacOptions options, TaskEvent e) {
        Path absolutePath = SemanticdbTaskListener.absolutePathFromUri(options, e.getSourceFile());
        if (absolutePath.startsWith(options.sourceroot)) {
            Path relativePath = options.sourceroot.relativize(absolutePath);
            String filename = relativePath.getFileName().toString() + ".semanticdb";
            Path semanticdbOutputPath = options.targetroot.resolve("META-INF").resolve("semanticdb").resolve(relativePath).resolveSibling(filename);
            return Result.ok(semanticdbOutputPath);
        }
        return Result.error(String.format("sourceroot '%s does not contain path '%s'. To fix this problem, update the -sourceroot flag to be a parent directory of this source file.", options.sourceroot, absolutePath));
    }
}

