/*
 * Decompiled with CFR 0.152.
 */
package monix.reactive.internal.builders;

import java.io.Serializable;
import monix.execution.Ack;
import monix.execution.Ack$Continue$;
import monix.execution.Cancelable;
import monix.execution.Cancelable$;
import monix.execution.ExecutionModel;
import monix.execution.Scheduler;
import monix.execution.atomic.AtomicBoolean;
import monix.execution.atomic.AtomicBuilder;
import monix.execution.atomic.PaddingStrategy;
import monix.execution.cancelables.BooleanCancelable;
import monix.execution.cancelables.BooleanCancelable$;
import monix.execution.exceptions.APIContractViolationException$;
import monix.reactive.Observable;
import monix.reactive.observers.Subscriber;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.collection.Iterator;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005ma!\u0002\u0005\n\u00055\t\u0002\u0002\u0003\u0014\u0001\u0005\u0003\u0005\u000b\u0011B\u0014\t\u000bM\u0002A\u0011\u0001\u001b\t\ra\u0002\u0001\u0015!\u0003:\u0011\u0015\t\u0005\u0001\"\u0001C\u0011\u0015y\u0005\u0001\"\u0003Q\u0011\u0015\u0019\u0006\u0001\"\u0003U\u0011\u0015I\b\u0001\"\u0003{\u0005QIE/\u001a:bi>\u0014\u0018i](cg\u0016\u0014h/\u00192mK*\u0011!bC\u0001\tEVLG\u000eZ3sg*\u0011A\"D\u0001\tS:$XM\u001d8bY*\u0011abD\u0001\te\u0016\f7\r^5wK*\t\u0001#A\u0003n_:L\u00070\u0006\u0002\u00133M\u0011\u0001a\u0005\t\u0004)U9R\"A\u0007\n\u0005Yi!AC(cg\u0016\u0014h/\u00192mKB\u0011\u0001$\u0007\u0007\u0001\t\u0015Q\u0002A1\u0001\u001d\u0005\u0005\t5\u0001A\t\u0003;\r\u0002\"AH\u0011\u000e\u0003}Q\u0011\u0001I\u0001\u0006g\u000e\fG.Y\u0005\u0003E}\u0011qAT8uQ&tw\r\u0005\u0002\u001fI%\u0011Qe\b\u0002\u0004\u0003:L\u0018\u0001C5uKJ\fGo\u001c:\u0011\u0007!\u0002tC\u0004\u0002*]9\u0011!&L\u0007\u0002W)\u0011AfG\u0001\u0007yI|w\u000e\u001e \n\u0003\u0001J!aL\u0010\u0002\u000fA\f7m[1hK&\u0011\u0011G\r\u0002\t\u0013R,'/\u0019;pe*\u0011qfH\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005U:\u0004c\u0001\u001c\u0001/5\t\u0011\u0002C\u0003'\u0005\u0001\u0007q%A\u0007xCN\u001cVOY:de&\u0014W\r\u001a\t\u0003u}j\u0011a\u000f\u0006\u0003yu\na!\u0019;p[&\u001c'B\u0001 \u0010\u0003%)\u00070Z2vi&|g.\u0003\u0002Aw\ti\u0011\t^8nS\u000e\u0014un\u001c7fC:\f\u0011#\u001e8tC\u001a,7+\u001e2tGJL'-\u001a$o)\t\u0019u\t\u0005\u0002E\u000b6\tQ(\u0003\u0002G{\tQ1)\u00198dK2\f'\r\\3\t\u000b!#\u0001\u0019A%\u0002\u0007=,H\u000fE\u0002K\u001b^i\u0011a\u0013\u0006\u0003\u00196\t\u0011b\u001c2tKJ4XM]:\n\u00059[%AC*vEN\u001c'/\u001b2fe\u0006I1\u000f^1si2{w\u000e\u001d\u000b\u0003\u0007FCQAU\u0003A\u0002%\u000b!b];cg\u000e\u0014\u0018NY3s\u0003)\u0011Xm]2iK\u0012,H.\u001a\u000b\u0007+zK7\u000e\u001c;\u0015\u0005YK\u0006C\u0001\u0010X\u0013\tAvD\u0001\u0003V]&$\b\"\u0002.\u0007\u0001\bY\u0016!A:\u0011\u0005\u0011c\u0016BA/>\u0005%\u00196\r[3ek2,'\u000fC\u0003`\r\u0001\u0007\u0001-A\u0002bG.\u00042!\u00193g\u001b\u0005\u0011'BA2 \u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0003K\n\u0014aAR;ukJ,\u0007C\u0001#h\u0013\tAWHA\u0002BG.DQA\u001b\u0004A\u0002\u001d\nA!\u001b;fe\")\u0001J\u0002a\u0001\u0013\")QN\u0002a\u0001]\u0006\t1\r\u0005\u0002pe6\t\u0001O\u0003\u0002r{\u0005Y1-\u00198dK2\f'\r\\3t\u0013\t\u0019\bOA\tC_>dW-\u00198DC:\u001cW\r\\1cY\u0016DQ!\u001e\u0004A\u0002Y\f!!Z7\u0011\u0005\u0011;\u0018B\u0001=>\u00059)\u00050Z2vi&|g.T8eK2\f\u0001BZ1ti2{w\u000e\u001d\u000b\twvtx0!\u0001\u0002\u0004Q\u0011a\u000b \u0005\u00065\u001e\u0001\u001da\u0017\u0005\u0006U\u001e\u0001\ra\n\u0005\u0006\u0011\u001e\u0001\r!\u0013\u0005\u0006[\u001e\u0001\rA\u001c\u0005\u0006k\u001e\u0001\rA\u001e\u0005\b\u0003\u000b9\u0001\u0019AA\u0004\u0003%\u0019\u0018P\\2J]\u0012,\u0007\u0010E\u0002\u001f\u0003\u0013I1!a\u0003 \u0005\rIe\u000e\u001e\u0015\u0004\u000f\u0005=\u0001\u0003BA\t\u0003/i!!a\u0005\u000b\u0007\u0005Uq$\u0001\u0006b]:|G/\u0019;j_:LA!!\u0007\u0002\u0014\t9A/Y5me\u0016\u001c\u0007")
public final class IteratorAsObservable<A>
extends Observable<A> {
    private final Iterator<A> iterator;
    private final AtomicBoolean wasSubscribed;

    @Override
    public Cancelable unsafeSubscribeFn(Subscriber<A> out) {
        Cancelable cancelable;
        if (this.wasSubscribed.getAndSet(true)) {
            out.onError((Throwable)APIContractViolationException$.MODULE$.apply("InputStreamObservable"));
            cancelable = Cancelable$.MODULE$.empty();
        } else {
            cancelable = this.startLoop(out);
        }
        return cancelable;
    }

    private Cancelable startLoop(Subscriber<A> subscriber) {
        Cancelable cancelable;
        block7: {
            boolean streamErrors = true;
            try {
                boolean iteratorHasNext = this.iterator.hasNext();
                streamErrors = false;
                if (!iteratorHasNext) {
                    subscriber.onComplete();
                    cancelable = Cancelable$.MODULE$.empty();
                    break block7;
                }
                BooleanCancelable cancelable2 = BooleanCancelable$.MODULE$.apply();
                this.fastLoop(this.iterator, subscriber, cancelable2, subscriber.scheduler().executionModel(), 0, subscriber.scheduler());
                cancelable = cancelable2;
            }
            catch (Throwable throwable) {
                Cancelable cancelable3;
                Throwable throwable2 = throwable;
                if (NonFatal$.MODULE$.apply(throwable2)) {
                    if (streamErrors) {
                        subscriber.onError(throwable2);
                        cancelable3 = Cancelable$.MODULE$.empty();
                    } else {
                        subscriber.scheduler().reportFailure(throwable2);
                        cancelable3 = Cancelable$.MODULE$.empty();
                    }
                } else {
                    throw throwable;
                }
                Cancelable cancelable4 = cancelable3;
                cancelable = cancelable4;
            }
        }
        return cancelable;
    }

    private void reschedule(Future<Ack> ack, Iterator<A> iter, Subscriber<A> out, BooleanCancelable c, ExecutionModel em, Scheduler s) {
        ack.onComplete((Function1 & Serializable & scala.Serializable)x0$1 -> {
            IteratorAsObservable.$anonfun$reschedule$1(this, iter, out, c, em, s, x0$1);
            return BoxedUnit.UNIT;
        }, (ExecutionContext)s);
    }

    private void fastLoop(Iterator<A> iter, Subscriber<A> out, BooleanCancelable c, ExecutionModel em, int syncIndex, Scheduler s) {
        block13: {
            int nextIndex;
            BoxedUnit boxedUnit;
            Future<Ack> ack;
            while (true) {
                int n;
                ack = Ack$Continue$.MODULE$;
                boolean streamErrors = true;
                boolean iteratorHasNext = true;
                Throwable iteratorTriggeredError = null;
                try {
                    Object next = iter.next();
                    iteratorHasNext = iter.hasNext();
                    ack = out.onNext(next);
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (!option.isEmpty()) {
                        Throwable ex = (Throwable)option.get();
                        if (streamErrors) {
                            iteratorTriggeredError = ex;
                            BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                        }
                    }
                    throw throwable;
                }
                if (iteratorTriggeredError != null) {
                    if (!c.isCanceled()) {
                        out.onError(iteratorTriggeredError);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        s.reportFailure(iteratorTriggeredError);
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    break block13;
                }
                if (!iteratorHasNext) {
                    streamErrors = true;
                    out.onComplete();
                    boxedUnit = BoxedUnit.UNIT;
                    break block13;
                }
                Future<Ack> future = ack;
                Ack$Continue$ ack$Continue$ = Ack$Continue$.MODULE$;
                if (!(future != null ? !future.equals((Object)ack$Continue$) : ack$Continue$ != null)) {
                    n = em.nextFrameIndex(syncIndex);
                } else {
                    Future<Ack> future2 = ack;
                    Ack.Stop$ stop$ = Ack.Stop$.MODULE$;
                    n = !(future2 != null ? !future2.equals((Object)stop$) : stop$ != null) ? -1 : (nextIndex = 0);
                }
                if (nextIndex <= 0) break;
                syncIndex = nextIndex;
            }
            if (nextIndex == 0 && !c.isCanceled()) {
                this.reschedule(ack, iter, out, c, em, s);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    public static final /* synthetic */ void $anonfun$reschedule$1(IteratorAsObservable $this, Iterator iter$1, Subscriber out$1, BooleanCancelable c$1, ExecutionModel em$1, Scheduler s$1, Try x0$1) {
        Try try_ = x0$1;
        if (try_ instanceof Success) {
            BoxedUnit boxedUnit;
            Ack next;
            Success success = (Success)try_;
            Ack ack = next = (Ack)success.value();
            Ack$Continue$ ack$Continue$ = Ack$Continue$.MODULE$;
            if (!(ack != null ? !ack.equals(ack$Continue$) : ack$Continue$ != null)) {
                try {
                    $this.fastLoop(iter$1, out$1, c$1, em$1, 0, s$1);
                    boxedUnit = BoxedUnit.UNIT;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (!NonFatal$.MODULE$.apply(throwable2)) {
                        throw throwable;
                    }
                    s$1.reportFailure(throwable2);
                    BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit3 = boxedUnit;
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable ex = failure.exception();
            out$1.onError(ex);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)try_);
        }
    }

    public IteratorAsObservable(Iterator<A> iterator) {
        this.iterator = iterator;
        this.wasSubscribed = AtomicBuilder.AtomicBooleanBuilder$.MODULE$.buildInstance(false, (PaddingStrategy)PaddingStrategy.NoPadding$.MODULE$, true);
    }
}

