/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.scala.debugadapter.internal.evaluator;

import ch.epfl.scala.debugadapter.ClassEntry;
import ch.epfl.scala.debugadapter.Logger;
import ch.epfl.scala.debugadapter.internal.evaluator.CompiledExpression;
import ch.epfl.scala.debugadapter.internal.evaluator.ExpressionCompiler;
import ch.epfl.scala.debugadapter.internal.evaluator.FrameReference;
import ch.epfl.scala.debugadapter.internal.evaluator.JdiArray;
import ch.epfl.scala.debugadapter.internal.evaluator.JdiArray$;
import ch.epfl.scala.debugadapter.internal.evaluator.JdiClassLoader;
import ch.epfl.scala.debugadapter.internal.evaluator.JdiClassLoader$;
import ch.epfl.scala.debugadapter.internal.evaluator.JdiObject;
import ch.epfl.scala.debugadapter.internal.evaluator.JdiPrimitive$;
import ch.epfl.scala.debugadapter.internal.evaluator.MethodInvocationFailed;
import ch.epfl.scala.debugadapter.internal.evaluator.Safe;
import ch.epfl.scala.debugadapter.internal.evaluator.Safe$;
import ch.epfl.scala.debugadapter.internal.evaluator.package$;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.CharValue;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.DoubleValue;
import com.sun.jdi.Field;
import com.sun.jdi.FloatValue;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.LongValue;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveType;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ShortValue;
import com.sun.jdi.StackFrame;
import com.sun.jdi.StringReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dg!B\n\u0015\u0001Y\u0001\u0003\u0002\u0003\u0014\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0015\t\u00111\u0002!\u0011!Q\u0001\n5B\u0001\"\r\u0001\u0003\u0002\u0003\u0006IA\r\u0005\tk\u0001\u0011\t\u0011)A\u0005m!)\u0011\b\u0001C\u0001u!)\u0001\t\u0001C\u0001\u0003\")A\f\u0001C\u0001;\")\u0001\t\u0001C\u0005]\")a\u0010\u0001C\u0005\u007f\"9\u0011\u0011\u0002\u0001\u0005\n\u0005-\u0001bBA\u000f\u0001\u0011%\u0011q\u0004\u0005\b\u0003\u000f\u0002A\u0011BA%\u0011\u001d\t9\u0007\u0001C\u0005\u0003SBq!a \u0001\t\u0013\t\t\tC\u0005\u0002\n\u0002\u0011\r\u0011\"\u0003\u0002\f\"A\u0011q\u0015\u0001!\u0002\u0013\ti\tC\u0004\u0002*\u0002!I!a+\t\u000f\u0005e\u0006\u0001\"\u0003\u0002<\nq1kY1mC\u00163\u0018\r\\;bi>\u0014(BA\u000b\u0017\u0003%)g/\u00197vCR|'O\u0003\u0002\u00181\u0005A\u0011N\u001c;fe:\fGN\u0003\u0002\u001a5\u0005aA-\u001a2vO\u0006$\u0017\r\u001d;fe*\u00111\u0004H\u0001\u0006g\u000e\fG.\u0019\u0006\u0003;y\tA!\u001a9gY*\tq$\u0001\u0002dQN\u0011\u0001!\t\t\u0003E\u0011j\u0011a\t\u0006\u00027%\u0011Qe\t\u0002\u0007\u0003:L(+\u001a4\u0002\u000b\u0015tGO]=\u0004\u0001A\u0011\u0011FK\u0007\u00021%\u00111\u0006\u0007\u0002\u000b\u00072\f7o]#oiJL\u0018\u0001C2p[BLG.\u001a:\u0011\u00059zS\"\u0001\u000b\n\u0005A\"\"AE#yaJ,7o]5p]\u000e{W\u000e]5mKJ\fa\u0001\\8hO\u0016\u0014\bCA\u00154\u0013\t!\u0004D\u0001\u0004M_\u001e<WM]\u0001\ti\u0016\u001cH/T8eKB\u0011!eN\u0005\u0003q\r\u0012qAQ8pY\u0016\fg.\u0001\u0004=S:LGO\u0010\u000b\u0006wqjdh\u0010\t\u0003]\u0001AQAJ\u0003A\u0002!BQ\u0001L\u0003A\u00025BQ!M\u0003A\u0002IBQ!N\u0003A\u0002Y\n\u0001\"\u001a<bYV\fG/\u001a\u000b\u0004\u0005J;\u0006cA\"G\u00116\tAI\u0003\u0002FG\u0005!Q\u000f^5m\u0013\t9EIA\u0002Uef\u0004\"!\u0013)\u000e\u0003)S!a\u0013'\u0002\u0007)$\u0017N\u0003\u0002N\u001d\u0006\u00191/\u001e8\u000b\u0003=\u000b1aY8n\u0013\t\t&JA\u0003WC2,X\rC\u0003T\r\u0001\u0007A+\u0001\u0006fqB\u0014Xm]:j_:\u0004\"AL+\n\u0005Y#\"AE\"p[BLG.\u001a3FqB\u0014Xm]:j_:DQ\u0001\u0017\u0004A\u0002e\u000bQA\u001a:b[\u0016\u0004\"A\f.\n\u0005m#\"A\u0004$sC6,'+\u001a4fe\u0016t7-Z\u0001\bG>l\u0007/\u001b7f)\u0011qv\f\\7\u0011\u0007\r3E\u000bC\u0003a\u000f\u0001\u0007\u0011-A\u0007t_V\u00148-Z\"p]R,g\u000e\u001e\t\u0003E&t!aY4\u0011\u0005\u0011\u001cS\"A3\u000b\u0005\u0019<\u0013A\u0002\u001fs_>$h(\u0003\u0002iG\u00051\u0001K]3eK\u001aL!A[6\u0003\rM#(/\u001b8h\u0015\tA7\u0005C\u0003T\u000f\u0001\u0007\u0011\rC\u0003Y\u000f\u0001\u0007\u0011\f\u0006\u0003C_nl\b\"\u00029\t\u0001\u0004\t\u0018\u0001C2mCN\u001cH)\u001b:\u0011\u0005ILX\"A:\u000b\u0005Q,\u0018\u0001\u00024jY\u0016T!A^<\u0002\u00079LwNC\u0001y\u0003\u0011Q\u0017M^1\n\u0005i\u001c(\u0001\u0002)bi\"DQ\u0001 \u0005A\u0002\u0005\f\u0011b\u00197bgNt\u0015-\\3\t\u000baC\u0001\u0019A-\u0002\u001f\u0019Lg\u000eZ\"mCN\u001cHj\\1eKJ$B!!\u0001\u0002\bA\u0019a&a\u0001\n\u0007\u0005\u0015AC\u0001\bKI&\u001cE.Y:t\u0019>\fG-\u001a:\t\u000baK\u0001\u0019A-\u0002%\u00154\u0018\r\\;bi\u0016,\u0005\u0010\u001d:fgNLwN\u001c\u000b\u0005\u0003\u001b\t\u0019\u0002\u0005\u0003/\u0003\u001fA\u0015bAA\t)\t!1+\u00194f\u0011\u001d\t)B\u0003a\u0001\u0003/\t!#\u001a=qe\u0016\u001c8/[8o\u0013:\u001cH/\u00198dKB\u0019a&!\u0007\n\u0007\u0005mACA\u0005KI&|%M[3di\u0006A2M]3bi\u0016,\u0005\u0010\u001d:fgNLwN\\%ogR\fgnY3\u0015\u0015\u0005\u0005\u00121EA\u0014\u0003S\tY\u0003E\u0003/\u0003\u001f\t9\u0002C\u0004\u0002&-\u0001\r!!\u0001\u0002\u0017\rd\u0017m]:M_\u0006$WM\u001d\u0005\u0006a.\u0001\r!\u001d\u0005\u0006y.\u0001\r!\u0019\u0005\b\u0003[Y\u0001\u0019AA\u0018\u0003\u0011\t'oZ:\u0011\r\u0005E\u00121HA!\u001d\u0011\t\u0019$a\u000e\u000f\u0007\u0011\f)$C\u0001\u001c\u0013\r\tIdI\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ti$a\u0010\u0003\t1K7\u000f\u001e\u0006\u0004\u0003s\u0019\u0003cA%\u0002D%\u0019\u0011Q\t&\u0003\u001f=\u0013'.Z2u%\u00164WM]3oG\u0016\fQ#\u001a=ue\u0006\u001cGOV1mk\u0016\u001c\u0018I\u001c3OC6,7\u000f\u0006\u0004\u0002L\u0005\u0005\u0014Q\r\t\u0006]\u0005=\u0011Q\n\t\bE\u0005=\u00131KA0\u0013\r\t\tf\t\u0002\u0007)V\u0004H.\u001a\u001a\u0011\r\u0005E\u0012QKA-\u0013\u0011\t9&a\u0010\u0003\u0007M+\u0017\u000fE\u0002J\u00037J1!!\u0018K\u0005=\u0019FO]5oOJ+g-\u001a:f]\u000e,\u0007#BA\u0019\u0003+B\u0005BBA2\u0019\u0001\u0007\u0011,\u0001\u0005ge\u0006lWMU3g\u0011\u001d\t)\u0003\u0004a\u0001\u0003\u0003\tq\"\u001e9eCR,g+\u0019:jC\ndWm\u001d\u000b\u0007\u0003W\n\u0019(! \u0011\u000b9\ny!!\u001c\u0011\u0007\t\ny'C\u0002\u0002r\r\u0012A!\u00168ji\"9\u0011QO\u0007A\u0002\u0005]\u0014!\u0004<be&\f'\r\\3BeJ\f\u0017\u0010E\u0002/\u0003sJ1!a\u001f\u0015\u0005!QE-[!se\u0006L\b\"\u0002-\u000e\u0001\u0004I\u0016A\u00042pq&3\u0007K]5nSRLg/\u001a\u000b\u0007\u0003\u001b\t\u0019)a\"\t\r\u0005\u0015e\u00021\u0001I\u0003\u00151\u0018\r\\;f\u0011\u001d\t)C\u0004a\u0001\u0003\u0003\tA\"\u001e8c_blU\r\u001e5pIN,\"!!$\u0011\u0011\u0005=\u0015\u0011TAO\u0003;k!!!%\u000b\t\u0005M\u0015QS\u0001\nS6lW\u000f^1cY\u0016T1!a&$\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u00037\u000b\tJA\u0002NCB\u0004B!a(\u0002&6\u0011\u0011\u0011\u0015\u0006\u0004\u0003G;\u0018\u0001\u00027b]\u001eL1A[AQ\u00035)hNY8y\u001b\u0016$\bn\u001c3tA\u0005\u0001RO\u001c2pq&3\u0007K]5nSRLg/\u001a\u000b\u0007\u0003\u001b\ti+a,\t\r\u0005\u0015\u0015\u00031\u0001I\u0011\u001d\t\t,\u0005a\u0001\u0003g\u000ba\u0001\u001e5sK\u0006$\u0007cA%\u00026&\u0019\u0011q\u0017&\u0003\u001fQC'/Z1e%\u00164WM]3oG\u0016\f1\"[:Qe&l\u0017\u000e^5wKR\u0019a'!0\t\u000f\u0005}&\u00031\u0001\u0002B\u0006Aa/\u0019:jC\ndW\rE\u0002J\u0003\u0007L1!!2K\u00055aunY1m-\u0006\u0014\u0018.\u00192mK\u0002")
public class ScalaEvaluator {
    private final ExpressionCompiler compiler;
    private final Logger logger;
    private final boolean testMode;
    private final Map<String, String> unboxMethods;

    public Try<Value> evaluate(CompiledExpression expression, FrameReference frame) {
        CompiledExpression compiledExpression = expression;
        if (compiledExpression == null) {
            throw new MatchError((Object)compiledExpression);
        }
        Path classDir = compiledExpression.classDir();
        String className = compiledExpression.className();
        Tuple2 tuple2 = new Tuple2((Object)classDir, (Object)className);
        Path classDir2 = (Path)tuple2._1();
        String className2 = (String)tuple2._2();
        return this.evaluate(classDir2, className2, frame);
    }

    public Try<CompiledExpression> compile(String sourceContent, String expression, FrameReference frame) {
        String className;
        this.logger.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("Compiling expression '").append(expression).append("'").toString());
        Location location = frame.current().location();
        int line = location.lineNumber();
        String fqcn = location.declaringType().name();
        String string = className = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(fqcn)).split('.'))).last();
        String string2 = fqcn;
        String packageName = !(string != null ? !string.equals(string2) : string2 != null) ? "" : new StringOps(Predef$.MODULE$.augmentString(fqcn)).stripSuffix(new StringBuilder(1).append(".").append(className).toString());
        String randomId = UUID.randomUUID().toString().replace("-", "");
        Path outDir = Files.createTempDirectory(new StringBuilder(20).append("scala-debug-adapter-").append(randomId).toString(), new FileAttribute[0]);
        String expressionClassName = new StringBuilder(10).append("Expression").append(randomId).toString();
        String fileName = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(location.sourcePath())).split('/'))).flatMap((Function1 & Serializable & scala.Serializable)x$2 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(x$2)).split('\\'))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).last();
        Path sourceFile = Files.createFile(outDir.resolve(fileName), new FileAttribute[0]);
        Files.write(sourceFile, sourceContent.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        String expressionFqcn = packageName.isEmpty() ? expressionClassName : new StringBuilder(1).append(packageName).append(".").append(expressionClassName).toString();
        JdiClassLoader classLoader = this.findClassLoader(frame);
        Safe compiledExpression = this.extractValuesAndNames(frame, classLoader).withFilter((Function1<Tuple2<Seq<StringReference>, Seq<Value>>, Object>)(Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)ScalaEvaluator.$anonfun$compile$3(check$ifrefutable$1))).map((Function1 & Serializable & scala.Serializable)x$5 -> {
            Tuple2 tuple2 = x$5;
            if (tuple2 != null) {
                Seq names = (Seq)tuple2._1();
                Set localNames = ((TraversableOnce)names.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.value(), Seq$.MODULE$.canBuildFrom())).toSet();
                return new Tuple2((Object)tuple2, (Object)localNames);
            }
            throw new MatchError((Object)tuple2);
        }).flatMap((Function1 & Serializable & scala.Serializable)x$6 -> {
            Tuple2 tuple2 = x$6;
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._1();
                Set localNames = (Set)tuple2._2();
                if (tuple22 != null) {
                    return Safe$.MODULE$.apply($this.compiler.compile(outDir, expressionClassName, sourceFile, line, expression, (Set<String>)localNames, packageName, $this.testMode)).map((Function1 & Serializable & scala.Serializable)_ -> new CompiledExpression(outDir, expressionFqcn));
                }
            }
            throw new MatchError((Object)tuple2);
        });
        return compiledExpression.getResult();
    }

    private Try<Value> evaluate(Path classDir, String className, FrameReference frame) {
        JdiClassLoader classLoader = this.findClassLoader(frame);
        Safe evaluatedValue = this.extractValuesAndNames(frame, classLoader).withFilter((Function1<Tuple2<Seq<StringReference>, Seq<Value>>, Object>)(Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)ScalaEvaluator.$anonfun$evaluate$1(check$ifrefutable$2))).flatMap((Function1 & Serializable & scala.Serializable)x$10 -> {
            Tuple2 tuple2 = x$10;
            if (tuple2 != null) {
                Seq names = (Seq)tuple2._1();
                Seq values = (Seq)tuple2._2();
                return JdiArray$.MODULE$.apply("java.lang.String", names.size(), classLoader).flatMap((Function1 & Serializable & scala.Serializable)namesArray -> JdiArray$.MODULE$.apply("java.lang.Object", values.size(), classLoader).map((Function1 & Serializable & scala.Serializable)valuesArray -> {
                    namesArray.setValues((Seq<Value>)names);
                    BoxedUnit x$7 = BoxedUnit.UNIT;
                    valuesArray.setValues((Seq<Value>)values);
                    BoxedUnit x$8 = BoxedUnit.UNIT;
                    .colon.colon args2 = new .colon.colon((Object)namesArray.reference(), (List)new .colon.colon((Object)valuesArray.reference(), (List)Nil$.MODULE$));
                    return new Tuple4(valuesArray, (Object)x$7, (Object)x$8, (Object)args2);
                }).flatMap((Function1 & Serializable & scala.Serializable)x$9 -> {
                    Tuple4 tuple4 = x$9;
                    if (tuple4 != null) {
                        JdiArray valuesArray = (JdiArray)tuple4._1();
                        List args2 = (List)tuple4._4();
                        return this.createExpressionInstance(classLoader, classDir, className, (List<ObjectReference>)args2).flatMap((Function1 & Serializable & scala.Serializable)expressionInstance -> this.evaluateExpression((JdiObject)expressionInstance).flatMap((Function1 & Serializable & scala.Serializable)evaluatedValue -> this.updateVariables(valuesArray, frame).flatMap((Function1 & Serializable & scala.Serializable)_ -> this.unboxIfPrimitive((Value)evaluatedValue, frame.thread()).map((Function1 & Serializable & scala.Serializable)unboxedValue -> unboxedValue))));
                    }
                    throw new MatchError((Object)tuple4);
                }));
            }
            throw new MatchError((Object)tuple2);
        });
        return evaluatedValue.getResult();
    }

    private JdiClassLoader findClassLoader(FrameReference frame) {
        Option scalaLibClassLoader = ((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(frame.thread().virtualMachine().allClasses()).asScala()).find((Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToBoolean((boolean)ScalaEvaluator.$anonfun$findClassLoader$1(c))).flatMap((Function1 & Serializable & scala.Serializable)scalaLibClass -> Option$.MODULE$.apply((Object)scalaLibClass.classLoader()).map((Function1 & Serializable & scala.Serializable)classLoader -> classLoader));
        ClassLoaderReference classLoader = (ClassLoaderReference)Option$.MODULE$.apply((Object)frame.current().location().method().declaringType().classLoader()).orElse((Function0 & Serializable & scala.Serializable)() -> scalaLibClassLoader).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new Exception("Cannot find the classloader of the Scala library");
        });
        return JdiClassLoader$.MODULE$.apply(classLoader, frame.thread());
    }

    private Safe<Value> evaluateExpression(JdiObject expressionInstance) {
        return expressionInstance.invoke("evaluate", (List<Value>)Nil$.MODULE$).recover(new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof MethodInvocationFailed) {
                    MethodInvocationFailed methodInvocationFailed = (MethodInvocationFailed)A1;
                    ObjectReference exception = methodInvocationFailed.remoteException();
                    return (B1)exception;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                return throwable instanceof MethodInvocationFailed;
            }
        });
    }

    private Safe<JdiObject> createExpressionInstance(JdiClassLoader classLoader, Path classDir, String className, List<ObjectReference> args2) {
        String expressionClassPath = classDir.toUri().toString();
        return classLoader.mirrorOf(expressionClassPath).flatMap((Function1 & Serializable & scala.Serializable)classPathValue -> classLoader.loadClass("java.net.URL").flatMap((Function1 & Serializable & scala.Serializable)urlClass -> urlClass.newInstance((List<ObjectReference>)new .colon.colon(classPathValue, (List)Nil$.MODULE$)).flatMap((Function1 & Serializable & scala.Serializable)url -> JdiArray$.MODULE$.apply("java.net.URL", 1, classLoader).map((Function1 & Serializable & scala.Serializable)urls -> {
            urls.setValue(0, url.reference());
            BoxedUnit x$14 = BoxedUnit.UNIT;
            return new Tuple2(urls, (Object)x$14);
        }).flatMap((Function1 & Serializable & scala.Serializable)x$15 -> {
            Tuple2 tuple2 = x$15;
            if (tuple2 != null) {
                JdiArray urls = (JdiArray)tuple2._1();
                return classLoader.loadClass("java.net.URLClassLoader").flatMap((Function1 & Serializable & scala.Serializable)x$11 -> x$11.newInstance((List<ObjectReference>)new .colon.colon((Object)urls.reference(), (List)Nil$.MODULE$))).map((Function1 & Serializable & scala.Serializable)x$12 -> (ClassLoaderReference)x$12.reference()).map((Function1 & Serializable & scala.Serializable)x$13 -> JdiClassLoader$.MODULE$.apply((ClassLoaderReference)x$13, classLoader.thread())).flatMap((Function1 & Serializable & scala.Serializable)urlClassLoader -> urlClassLoader.loadClass(className).flatMap((Function1 & Serializable & scala.Serializable)expressionClass -> expressionClass.newInstance(args2).map((Function1 & Serializable & scala.Serializable)expressionInstance -> expressionInstance)));
            }
            throw new MatchError((Object)tuple2);
        }))));
    }

    private Safe<Tuple2<Seq<StringReference>, Seq<Value>>> extractValuesAndNames(FrameReference frameRef, JdiClassLoader classLoader) {
        StackFrame frame = frameRef.current();
        Option thisObjectOpt = Option$.MODULE$.apply((Object)frame.thisObject());
        return this.extractVariablesFromFrame$1(frame, thisObjectOpt, classLoader).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)ScalaEvaluator.$anonfun$extractValuesAndNames$15(check$ifrefutable$3))).flatMap((Function1 & Serializable & scala.Serializable)x$23 -> {
            Tuple2 tuple2 = x$23;
            if (tuple2 != null) {
                Seq variableNames = (Seq)tuple2._1();
                Seq variableValues = (Seq)tuple2._2();
                return ((Safe)thisObjectOpt.filter((Function1 & Serializable & scala.Serializable)x$21 -> BoxesRunTime.boxToBoolean((boolean)ScalaEvaluator.$anonfun$extractValuesAndNames$17(this, x$21))).map((Function1 & Serializable & scala.Serializable)thisObject -> this.extractFields$1((ObjectReference)thisObject, classLoader)).getOrElse((Function0 & Serializable & scala.Serializable)() -> Safe$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> new Tuple2((Object)Nil$.MODULE$, (Object)Nil$.MODULE$)))).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$4 -> BoxesRunTime.boxToBoolean((boolean)ScalaEvaluator.$anonfun$extractValuesAndNames$21(check$ifrefutable$4))).map((Function1 & Serializable & scala.Serializable)x$22 -> {
                    Tuple2 tuple2 = x$22;
                    if (tuple2 != null) {
                        Seq fieldNames = (Seq)tuple2._1();
                        Seq fieldValues = (Seq)tuple2._2();
                        Seq names = (Seq)variableNames.$plus$plus((GenTraversableOnce)fieldNames, Seq$.MODULE$.canBuildFrom());
                        Seq values = (Seq)variableValues.$plus$plus((GenTraversableOnce)fieldValues, Seq$.MODULE$.canBuildFrom());
                        return new Tuple2((Object)names, (Object)values);
                    }
                    throw new MatchError((Object)tuple2);
                });
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private Safe<BoxedUnit> updateVariables(JdiArray variableArray, FrameReference frame) {
        Safe unboxedValues = package$.MODULE$.SafeSeq((Seq)((List)ScalaEvaluator.localVariables$2(frame).zip(variableArray.getValues(), List$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                LocalVariable variable = (LocalVariable)tuple2._1();
                Value value = (Value)tuple2._2();
                if (this.isPrimitive(variable)) {
                    return this.unboxIfPrimitive(value, frame.thread());
                }
                return Safe$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> value);
            }
            throw new MatchError((Object)tuple2);
        }, List$.MODULE$.canBuildFrom())).traverse();
        return unboxedValues.map((Function1 & Serializable & scala.Serializable)values -> {
            ScalaEvaluator.$anonfun$updateVariables$3(frame, values);
            return BoxedUnit.UNIT;
        });
    }

    private Safe<Value> boxIfPrimitive(Value value, JdiClassLoader classLoader) {
        ThreadReference thread = classLoader.thread();
        Value value2 = value;
        if (value2 instanceof BooleanValue) {
            BooleanValue booleanValue = (BooleanValue)value2;
            return JdiPrimitive$.MODULE$.box(BoxesRunTime.boxToBoolean((boolean)booleanValue.value()), classLoader, thread);
        }
        if (value2 instanceof CharValue) {
            CharValue charValue = (CharValue)value2;
            return JdiPrimitive$.MODULE$.box(BoxesRunTime.boxToCharacter((char)charValue.value()), classLoader, thread);
        }
        if (value2 instanceof DoubleValue) {
            DoubleValue doubleValue = (DoubleValue)value2;
            return JdiPrimitive$.MODULE$.box(BoxesRunTime.boxToDouble((double)doubleValue.value()), classLoader, thread);
        }
        if (value2 instanceof FloatValue) {
            FloatValue floatValue = (FloatValue)value2;
            return JdiPrimitive$.MODULE$.box(BoxesRunTime.boxToFloat((float)floatValue.value()), classLoader, thread);
        }
        if (value2 instanceof IntegerValue) {
            IntegerValue integerValue = (IntegerValue)value2;
            return JdiPrimitive$.MODULE$.box(BoxesRunTime.boxToInteger((int)integerValue.value()), classLoader, thread);
        }
        if (value2 instanceof LongValue) {
            LongValue longValue = (LongValue)value2;
            return JdiPrimitive$.MODULE$.box(BoxesRunTime.boxToLong((long)longValue.value()), classLoader, thread);
        }
        if (value2 instanceof ShortValue) {
            ShortValue shortValue = (ShortValue)value2;
            return JdiPrimitive$.MODULE$.box(BoxesRunTime.boxToShort((short)shortValue.value()), classLoader, thread);
        }
        return Safe$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> value2);
    }

    private Map<String, String> unboxMethods() {
        return this.unboxMethods;
    }

    private Safe<Value> unboxIfPrimitive(Value value, ThreadReference thread) {
        Value value2 = value;
        if (value2 instanceof ObjectReference) {
            ObjectReference objectReference = (ObjectReference)value2;
            String typeName = objectReference.referenceType().name();
            return (Safe)this.unboxMethods().get((Object)typeName).map((Function1 & Serializable & scala.Serializable)methodName -> new JdiObject(objectReference, thread).invoke((String)methodName, (List<Value>)Nil$.MODULE$)).getOrElse((Function0 & Serializable & scala.Serializable)() -> Safe$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> value));
        }
        return Safe$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> value);
    }

    private boolean isPrimitive(LocalVariable variable) {
        return variable.type() instanceof PrimitiveType;
    }

    public static final /* synthetic */ boolean $anonfun$compile$3(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    public static final /* synthetic */ boolean $anonfun$evaluate$1(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        return tuple2 != null;
    }

    public static final /* synthetic */ boolean $anonfun$findClassLoader$1(ReferenceType c) {
        return c.name().startsWith("scala.runtime");
    }

    public static final /* synthetic */ boolean $anonfun$extractValuesAndNames$3(Tuple2 x$17) {
        Object object = x$17._1();
        String string = "$this";
        return !(object != null ? !object.equals(string) : string != null);
    }

    public static final /* synthetic */ boolean $anonfun$extractValuesAndNames$2(Seq localVariables$1, ObjectReference x$16) {
        return !localVariables$1.exists((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)ScalaEvaluator.$anonfun$extractValuesAndNames$3(x$17)));
    }

    private final Safe extractVariablesFromFrame$1(StackFrame frame$2, Option thisObjectOpt$1, JdiClassLoader classLoader$3) {
        Seq localVariables = (Seq)((SeqLike)CollectionConverters$.MODULE$.asScalaBufferConverter(frame$2.visibleVariables()).asScala()).toSeq().map((Function1 & Serializable & scala.Serializable)v -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)v.name()), (Object)frame$2.getValue((LocalVariable)v)), Seq$.MODULE$.canBuildFrom());
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"$this");
        Option thisObject = thisObjectOpt$1.filter((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)ScalaEvaluator.$anonfun$extractValuesAndNames$2(localVariables, x$16))).map((Function1 & Serializable & scala.Serializable)y -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, y));
        return package$.MODULE$.SafeSeq((Seq)((TraversableLike)localVariables.$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(thisObject), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String name2 = (String)tuple2._1();
                Value value = (Value)tuple2._2();
                return classLoader$3.mirrorOf(name2).flatMap((Function1 & Serializable & scala.Serializable)name -> this.boxIfPrimitive(value, classLoader$3).map((Function1 & Serializable & scala.Serializable)value -> new Tuple2(name, value)));
            }
            throw new MatchError((Object)tuple2);
        }, Seq$.MODULE$.canBuildFrom())).traverse().map((Function1 & Serializable & scala.Serializable)xs -> new Tuple2(xs.map((Function1 & Serializable & scala.Serializable)x$18 -> (StringReference)x$18._1(), Seq$.MODULE$.canBuildFrom()), xs.map((Function1 & Serializable & scala.Serializable)x$19 -> (Value)x$19._2(), Seq$.MODULE$.canBuildFrom())));
    }

    private final Safe extractFields$1(ObjectReference thisObject, JdiClassLoader classLoader$3) {
        List fields = ((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(thisObject.referenceType().fields()).asScala()).toList();
        Safe fieldNames = package$.MODULE$.SafeSeq((Seq)((List)fields.map((Function1 & Serializable & scala.Serializable)x$20 -> x$20.name(), List$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)str -> classLoader$3.mirrorOf((String)str), List$.MODULE$.canBuildFrom())).traverse();
        Safe fieldValues = package$.MODULE$.SafeSeq((Seq)((List)fields.map((Function1 & Serializable & scala.Serializable)field -> thisObject.getValue((Field)field), List$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)value -> this.boxIfPrimitive((Value)value, classLoader$3), List$.MODULE$.canBuildFrom())).traverse();
        return Safe$.MODULE$.join(fieldNames, fieldValues);
    }

    public static final /* synthetic */ boolean $anonfun$extractValuesAndNames$15(Tuple2 check$ifrefutable$3) {
        Tuple2 tuple2 = check$ifrefutable$3;
        return tuple2 != null;
    }

    public static final /* synthetic */ boolean $anonfun$extractValuesAndNames$17(ScalaEvaluator $this, ObjectReference x$21) {
        return $this.compiler.scalaVersion().isScala2();
    }

    public static final /* synthetic */ boolean $anonfun$extractValuesAndNames$21(Tuple2 check$ifrefutable$4) {
        Tuple2 tuple2 = check$ifrefutable$4;
        return tuple2 != null;
    }

    private static final List localVariables$2(FrameReference frame$3) {
        return ((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(frame$3.current().visibleVariables()).asScala()).toList();
    }

    public static final /* synthetic */ boolean $anonfun$updateVariables$4(Tuple2 check$ifrefutable$5) {
        Tuple2 tuple2 = check$ifrefutable$5;
        return tuple2 != null;
    }

    public static final /* synthetic */ void $anonfun$updateVariables$5(FrameReference frame$3, Tuple2 x$24) {
        Tuple2 tuple2 = x$24;
        if (tuple2 != null) {
            LocalVariable variable = (LocalVariable)tuple2._1();
            Value value = (Value)tuple2._2();
            frame$3.current().setValue(variable, value);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$updateVariables$3(FrameReference frame$3, Seq values) {
        ((TraversableLike)ScalaEvaluator.localVariables$2(frame$3).zip((GenIterable)values, List$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$5 -> BoxesRunTime.boxToBoolean((boolean)ScalaEvaluator.$anonfun$updateVariables$4(check$ifrefutable$5))).foreach((Function1 & Serializable & scala.Serializable)x$24 -> {
            ScalaEvaluator.$anonfun$updateVariables$5(frame$3, x$24);
            return BoxedUnit.UNIT;
        });
    }

    public ScalaEvaluator(ClassEntry entry, ExpressionCompiler compiler, Logger logger, boolean testMode) {
        this.compiler = compiler;
        this.logger = logger;
        this.testMode = testMode;
        this.unboxMethods = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"java.lang.Boolean"), (Object)"booleanValue"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"java.lang.Byte"), (Object)"byteValue"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"java.lang.Character"), (Object)"charValue"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"java.lang.Double"), (Object)"doubleValue"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"java.lang.Float"), (Object)"floatValue"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"java.lang.Integer"), (Object)"intValue"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"java.lang.Long"), (Object)"longValue"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"java.lang.Short"), (Object)"shortValue")}));
    }
}

