/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter.variables;

import com.sun.jdi.ThreadReference;
import java.util.Objects;

public class VariableProxy {
    private final ThreadReference thread;
    private final String scopeName;
    private Object variable;
    private int hashCode;
    private final String evaluateName;
    private boolean isIndexedVariable;
    private boolean isUnboundedType = false;

    public VariableProxy(ThreadReference threadReference, String string, Object object, VariableProxy variableProxy, String string2) {
        this.thread = threadReference;
        this.scopeName = string;
        this.variable = object;
        this.evaluateName = string2;
        this.hashCode = Objects.hash(string, threadReference, object, string2);
    }

    public String toString() {
        return String.format("%s %s", String.valueOf(this.variable), this.scopeName);
    }

    public ThreadReference getThread() {
        return this.thread;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        VariableProxy variableProxy = (VariableProxy)object;
        return Objects.equals(this.scopeName, variableProxy.scopeName) && Objects.equals(this.getThreadId(), variableProxy.getThreadId()) && Objects.equals(this.variable, variableProxy.variable) && Objects.equals(this.evaluateName, variableProxy.evaluateName);
    }

    public long getThreadId() {
        return this.thread.uniqueID();
    }

    public String getScope() {
        return this.scopeName;
    }

    public Object getProxiedVariable() {
        return this.variable;
    }

    public String getEvaluateName() {
        return this.evaluateName;
    }

    public boolean isIndexedVariable() {
        return this.isIndexedVariable;
    }

    public void setIndexedVariable(boolean bl) {
        this.isIndexedVariable = bl;
    }

    public boolean isUnboundedType() {
        return this.isUnboundedType;
    }

    public void setUnboundedType(boolean bl) {
        this.isUnboundedType = bl;
    }
}

