/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter.variables;

import com.microsoft.java.debug.core.adapter.formatter.IFormatter;
import com.microsoft.java.debug.core.adapter.formatter.ITypeFormatter;
import com.microsoft.java.debug.core.adapter.formatter.IValueFormatter;
import com.microsoft.java.debug.core.adapter.variables.IVariableFormatter;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class VariableFormatter
implements IVariableFormatter {
    private Map<IValueFormatter, Integer> valueFormatterMap = new HashMap<IValueFormatter, Integer>();
    private Map<ITypeFormatter, Integer> typeFormatterMap = new HashMap<ITypeFormatter, Integer>();

    private static IFormatter getFormatter(Map<? extends IFormatter, Integer> map, Type type, Map<String, Object> map2) {
        List list = map.keySet().stream().filter(iFormatter -> iFormatter.acceptType(type, map2)).sorted((iFormatter, iFormatter2) -> -Integer.compare((Integer)map.get(iFormatter), (Integer)map.get(iFormatter2))).collect(Collectors.toList());
        if (list.isEmpty()) {
            throw new UnsupportedOperationException(String.format("There is no related formatter for type %s.", type == null ? "null" : type.name()));
        }
        return (IFormatter)list.get(0);
    }

    @Override
    public String typeToString(Type type, Map<String, Object> map) {
        IFormatter iFormatter = VariableFormatter.getFormatter(this.typeFormatterMap, type, map);
        return iFormatter.toString(type, map);
    }

    @Override
    public Map<String, Object> getDefaultOptions() {
        int n;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        int n2 = this.valueFormatterMap.keySet().stream().mapToInt(iValueFormatter -> this.mergeDefaultOptions((IFormatter)iValueFormatter, (Map<String, Object>)hashMap)).sum();
        if (n2 + (n = this.typeFormatterMap.keySet().stream().mapToInt(iTypeFormatter -> this.mergeDefaultOptions((IFormatter)iTypeFormatter, (Map<String, Object>)hashMap)).sum()) != hashMap.size()) {
            throw new IllegalStateException("There is some configuration conflicts on type and value formatters.");
        }
        return hashMap;
    }

    @Override
    public String valueToString(Value value, Map<String, Object> map) {
        Type type = value == null ? null : value.type();
        IFormatter iFormatter = VariableFormatter.getFormatter(this.valueFormatterMap, type, map);
        return iFormatter.toString(value, map);
    }

    @Override
    public Value stringToValue(String string, Type type, Map<String, Object> map) {
        IValueFormatter iValueFormatter = (IValueFormatter)VariableFormatter.getFormatter(this.valueFormatterMap, type, map);
        return iValueFormatter.valueOf(string, type, map);
    }

    @Override
    public void registerValueFormatter(IValueFormatter iValueFormatter, int n) {
        this.valueFormatterMap.put(iValueFormatter, n);
    }

    @Override
    public void registerTypeFormatter(ITypeFormatter iTypeFormatter, int n) {
        this.typeFormatterMap.put(iTypeFormatter, n);
    }

    private int mergeDefaultOptions(IFormatter iFormatter, Map<String, Object> map) {
        int n = 0;
        for (Map.Entry<String, Object> entry : iFormatter.getDefaultOptions().entrySet()) {
            map.put(entry.getKey(), entry.getValue());
            ++n;
        }
        return n;
    }
}

