/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter.handler;

import com.microsoft.java.debug.core.DebugUtility;
import com.microsoft.java.debug.core.IDebugSession;
import com.microsoft.java.debug.core.adapter.AdapterUtils;
import com.microsoft.java.debug.core.adapter.ErrorCode;
import com.microsoft.java.debug.core.adapter.IDebugAdapterContext;
import com.microsoft.java.debug.core.adapter.IDebugRequestHandler;
import com.microsoft.java.debug.core.adapter.IEvaluationProvider;
import com.microsoft.java.debug.core.adapter.StepRequestManager;
import com.microsoft.java.debug.core.protocol.Events;
import com.microsoft.java.debug.core.protocol.Messages;
import com.microsoft.java.debug.core.protocol.Requests;
import com.microsoft.java.debug.core.protocol.Responses;
import com.microsoft.java.debug.core.protocol.Types;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.request.EventRequestManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class ThreadsRequestHandler
implements IDebugRequestHandler {
    @Override
    public List<Requests.Command> getTargetCommands() {
        return Arrays.asList(Requests.Command.THREADS, Requests.Command.PAUSE, Requests.Command.CONTINUE, Requests.Command.CONTINUEALL, Requests.Command.CONTINUEOTHERS, Requests.Command.PAUSEALL, Requests.Command.PAUSEOTHERS);
    }

    @Override
    public CompletableFuture<Messages.Response> handle(Requests.Command command, Requests.Arguments arguments, Messages.Response response, IDebugAdapterContext iDebugAdapterContext) {
        if (iDebugAdapterContext.getDebugSession() == null) {
            return AdapterUtils.createAsyncErrorResponse(response, ErrorCode.EMPTY_DEBUG_SESSION, "Debug Session doesn't exist.");
        }
        switch (command) {
            case THREADS: {
                return this.threads((Requests.ThreadsArguments)arguments, response, iDebugAdapterContext);
            }
            case PAUSE: {
                return this.pause((Requests.PauseArguments)arguments, response, iDebugAdapterContext);
            }
            case CONTINUE: {
                return this.resume((Requests.ContinueArguments)arguments, response, iDebugAdapterContext);
            }
            case CONTINUEALL: {
                return this.resumeAll((Requests.ThreadOperationArguments)arguments, response, iDebugAdapterContext);
            }
            case CONTINUEOTHERS: {
                return this.resumeOthers((Requests.ThreadOperationArguments)arguments, response, iDebugAdapterContext);
            }
            case PAUSEALL: {
                return this.pauseAll((Requests.ThreadOperationArguments)arguments, response, iDebugAdapterContext);
            }
            case PAUSEOTHERS: {
                return this.pauseOthers((Requests.ThreadOperationArguments)arguments, response, iDebugAdapterContext);
            }
        }
        return AdapterUtils.createAsyncErrorResponse(response, ErrorCode.UNRECOGNIZED_REQUEST_FAILURE, String.format("Unrecognized request: { _request: %s }", command.toString()));
    }

    private CompletableFuture<Messages.Response> threads(Requests.ThreadsArguments threadsArguments, Messages.Response response, IDebugAdapterContext iDebugAdapterContext) {
        ArrayList<Types.Thread> arrayList = new ArrayList<Types.Thread>();
        try {
            for (ThreadReference threadReference : iDebugAdapterContext.getDebugSession().getAllThreads()) {
                if (threadReference.isCollected()) continue;
                Types.Thread thread = new Types.Thread(threadReference.uniqueID(), "Thread [" + threadReference.name() + "]");
                arrayList.add(thread);
            }
        }
        catch (ObjectCollectedException objectCollectedException) {
            // empty catch block
        }
        response.body = new Responses.ThreadsResponseBody(arrayList);
        return CompletableFuture.completedFuture(response);
    }

    private CompletableFuture<Messages.Response> pause(Requests.PauseArguments pauseArguments, Messages.Response response, IDebugAdapterContext iDebugAdapterContext) {
        StepRequestManager stepRequestManager = iDebugAdapterContext.getStepRequestManager();
        IDebugSession iDebugSession = iDebugAdapterContext.getDebugSession();
        EventRequestManager eventRequestManager = iDebugSession.getVM().eventRequestManager();
        ThreadReference threadReference = DebugUtility.getThread(iDebugSession, pauseArguments.threadId);
        if (threadReference != null) {
            stepRequestManager.removeMethodResult(pauseArguments.threadId);
            stepRequestManager.deletePendingStep(pauseArguments.threadId, eventRequestManager);
            threadReference.suspend();
            iDebugAdapterContext.getProtocolServer().sendEvent(new Events.StoppedEvent("pause", pauseArguments.threadId));
        } else {
            stepRequestManager.removeAllMethodResults();
            stepRequestManager.deleteAllPendingSteps(eventRequestManager);
            iDebugSession.suspend();
            iDebugAdapterContext.getProtocolServer().sendEvent(new Events.StoppedEvent("pause", pauseArguments.threadId, true));
        }
        return CompletableFuture.completedFuture(response);
    }

    private CompletableFuture<Messages.Response> resume(Requests.ContinueArguments continueArguments, Messages.Response response, IDebugAdapterContext iDebugAdapterContext) {
        boolean bl = true;
        ThreadReference threadReference = DebugUtility.getThread(iDebugAdapterContext.getDebugSession(), continueArguments.threadId);
        if (threadReference != null) {
            iDebugAdapterContext.getStepRequestManager().removeMethodResult(continueArguments.threadId);
            iDebugAdapterContext.getExceptionManager().removeException(continueArguments.threadId);
            bl = false;
            DebugUtility.resumeThread(threadReference);
            ThreadsRequestHandler.checkThreadRunningAndRecycleIds(threadReference, iDebugAdapterContext);
        } else {
            iDebugAdapterContext.getStepRequestManager().removeAllMethodResults();
            iDebugAdapterContext.getExceptionManager().removeAllExceptions();
            iDebugAdapterContext.getDebugSession().resume();
            iDebugAdapterContext.getRecyclableIdPool().removeAllObjects();
        }
        response.body = new Responses.ContinueResponseBody(bl);
        return CompletableFuture.completedFuture(response);
    }

    private CompletableFuture<Messages.Response> resumeAll(Requests.ThreadOperationArguments threadOperationArguments, Messages.Response response, IDebugAdapterContext iDebugAdapterContext) {
        iDebugAdapterContext.getExceptionManager().removeAllExceptions();
        iDebugAdapterContext.getDebugSession().resume();
        iDebugAdapterContext.getProtocolServer().sendEvent(new Events.ContinuedEvent(threadOperationArguments.threadId, true));
        iDebugAdapterContext.getRecyclableIdPool().removeAllObjects();
        return CompletableFuture.completedFuture(response);
    }

    private CompletableFuture<Messages.Response> resumeOthers(Requests.ThreadOperationArguments threadOperationArguments, Messages.Response response, IDebugAdapterContext iDebugAdapterContext) {
        List<ThreadReference> list = DebugUtility.getAllThreadsSafely(iDebugAdapterContext.getDebugSession());
        for (ThreadReference threadReference : list) {
            long l = threadReference.uniqueID();
            if (l == threadOperationArguments.threadId || !threadReference.isSuspended()) continue;
            iDebugAdapterContext.getExceptionManager().removeException(l);
            DebugUtility.resumeThread(threadReference);
            iDebugAdapterContext.getProtocolServer().sendEvent(new Events.ContinuedEvent(l));
            ThreadsRequestHandler.checkThreadRunningAndRecycleIds(threadReference, iDebugAdapterContext);
        }
        return CompletableFuture.completedFuture(response);
    }

    private CompletableFuture<Messages.Response> pauseAll(Requests.ThreadOperationArguments threadOperationArguments, Messages.Response response, IDebugAdapterContext iDebugAdapterContext) {
        StepRequestManager stepRequestManager = iDebugAdapterContext.getStepRequestManager();
        IDebugSession iDebugSession = iDebugAdapterContext.getDebugSession();
        EventRequestManager eventRequestManager = iDebugSession.getVM().eventRequestManager();
        stepRequestManager.removeAllMethodResults();
        stepRequestManager.deleteAllPendingSteps(eventRequestManager);
        iDebugSession.suspend();
        iDebugAdapterContext.getProtocolServer().sendEvent(new Events.StoppedEvent("pause", threadOperationArguments.threadId, true));
        return CompletableFuture.completedFuture(response);
    }

    private CompletableFuture<Messages.Response> pauseOthers(Requests.ThreadOperationArguments threadOperationArguments, Messages.Response response, IDebugAdapterContext iDebugAdapterContext) {
        List<ThreadReference> list = DebugUtility.getAllThreadsSafely(iDebugAdapterContext.getDebugSession());
        for (ThreadReference threadReference : list) {
            long l = threadReference.uniqueID();
            if (l == threadOperationArguments.threadId || threadReference.isCollected() || threadReference.isSuspended()) continue;
            threadReference.suspend();
            iDebugAdapterContext.getProtocolServer().sendEvent(new Events.StoppedEvent("pause", l));
        }
        return CompletableFuture.completedFuture(response);
    }

    public static void checkThreadRunningAndRecycleIds(ThreadReference threadReference, IDebugAdapterContext iDebugAdapterContext) {
        try {
            boolean bl;
            IEvaluationProvider iEvaluationProvider = iDebugAdapterContext.getProvider(IEvaluationProvider.class);
            iEvaluationProvider.clearState(threadReference);
            boolean bl2 = bl = !DebugUtility.getAllThreadsSafely(iDebugAdapterContext.getDebugSession()).stream().anyMatch(ThreadReference::isSuspended);
            if (bl) {
                iDebugAdapterContext.getRecyclableIdPool().removeAllObjects();
            } else {
                iDebugAdapterContext.getRecyclableIdPool().removeObjectsByOwner(threadReference.uniqueID());
            }
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            iDebugAdapterContext.getRecyclableIdPool().removeAllObjects();
        }
        catch (ObjectCollectedException objectCollectedException) {
            iDebugAdapterContext.getRecyclableIdPool().removeObjectsByOwner(threadReference.uniqueID());
        }
    }
}

