/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter.handler;

import com.microsoft.java.debug.core.DebugException;
import com.microsoft.java.debug.core.DebugUtility;
import com.microsoft.java.debug.core.StackFrameUtility;
import com.microsoft.java.debug.core.adapter.AdapterUtils;
import com.microsoft.java.debug.core.adapter.ErrorCode;
import com.microsoft.java.debug.core.adapter.IDebugAdapterContext;
import com.microsoft.java.debug.core.adapter.IDebugRequestHandler;
import com.microsoft.java.debug.core.adapter.variables.StackFrameReference;
import com.microsoft.java.debug.core.protocol.Events;
import com.microsoft.java.debug.core.protocol.Messages;
import com.microsoft.java.debug.core.protocol.Requests;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.StepRequest;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class RestartFrameHandler
implements IDebugRequestHandler {
    @Override
    public List<Requests.Command> getTargetCommands() {
        return Arrays.asList(Requests.Command.RESTARTFRAME);
    }

    @Override
    public CompletableFuture<Messages.Response> handle(Requests.Command command, Requests.Arguments arguments, Messages.Response response, IDebugAdapterContext iDebugAdapterContext) {
        Requests.RestartFrameArguments restartFrameArguments = (Requests.RestartFrameArguments)arguments;
        StackFrameReference stackFrameReference = (StackFrameReference)iDebugAdapterContext.getRecyclableIdPool().getObjectById(restartFrameArguments.frameId);
        if (stackFrameReference == null) {
            throw AdapterUtils.createCompletionException(String.format("RestartFrame: cannot find the stack frame with frameID %s", restartFrameArguments.frameId), ErrorCode.RESTARTFRAME_FAILURE);
        }
        if (this.canRestartFrame(iDebugAdapterContext, stackFrameReference)) {
            try {
                ThreadReference threadReference = stackFrameReference.getThread();
                this.popStackFrames(iDebugAdapterContext, threadReference, stackFrameReference.getDepth());
                this.stepInto(iDebugAdapterContext, threadReference);
            }
            catch (DebugException debugException) {
                iDebugAdapterContext.getProtocolServer().sendEvent(new Events.UserNotificationEvent(Events.UserNotificationEvent.NotificationType.ERROR, debugException.getMessage()));
                throw AdapterUtils.createCompletionException(String.format("Failed to restart stack frame. Reason: %s", debugException.getMessage()), ErrorCode.RESTARTFRAME_FAILURE, debugException);
            }
            return CompletableFuture.completedFuture(response);
        }
        iDebugAdapterContext.getProtocolServer().sendEvent(new Events.UserNotificationEvent(Events.UserNotificationEvent.NotificationType.ERROR, "Current stack frame doesn't support restart."));
        throw AdapterUtils.createCompletionException("Current stack frame doesn't support restart.", ErrorCode.RESTARTFRAME_FAILURE);
    }

    private boolean canRestartFrame(IDebugAdapterContext iDebugAdapterContext, StackFrameReference stackFrameReference) {
        if (!iDebugAdapterContext.getDebugSession().getVM().canPopFrames()) {
            return false;
        }
        ThreadReference threadReference = stackFrameReference.getThread();
        StackFrame[] stackFrameArray = iDebugAdapterContext.getStackFrameManager().reloadStackFrames(threadReference);
        if (stackFrameArray.length <= stackFrameReference.getDepth() + 1) {
            return false;
        }
        for (int i = 0; i <= stackFrameReference.getDepth() + 1; ++i) {
            if (!StackFrameUtility.isNative(stackFrameArray[i])) continue;
            return false;
        }
        return true;
    }

    private void popStackFrames(IDebugAdapterContext iDebugAdapterContext, ThreadReference threadReference, int n) throws DebugException {
        StackFrame[] stackFrameArray = iDebugAdapterContext.getStackFrameManager().reloadStackFrames(threadReference);
        StackFrameUtility.pop(stackFrameArray[n]);
    }

    private void stepInto(IDebugAdapterContext iDebugAdapterContext, ThreadReference threadReference) {
        EventRequestManager eventRequestManager = iDebugAdapterContext.getDebugSession().getVM().eventRequestManager();
        StepRequest stepRequest = DebugUtility.createStepIntoRequest(threadReference, iDebugAdapterContext.getStepFilters().allowClasses, iDebugAdapterContext.getStepFilters().skipClasses);
        iDebugAdapterContext.getDebugSession().getEventHub().stepEvents().filter(debugEvent -> stepRequest.equals(debugEvent.event.request())).take(1L).subscribe(debugEvent -> {
            DebugUtility.deleteEventRequestSafely(eventRequestManager, stepRequest);
            debugEvent.shouldResume = false;
            iDebugAdapterContext.getProtocolServer().sendEvent(new Events.ContinuedEvent(threadReference.uniqueID()));
            iDebugAdapterContext.getProtocolServer().sendEvent(new Events.StoppedEvent("restartframe", threadReference.uniqueID()));
        });
        stepRequest.enable();
        threadReference.resume();
    }
}

