/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter.handler;

import com.microsoft.java.debug.core.DebugException;
import com.microsoft.java.debug.core.DebugSettings;
import com.microsoft.java.debug.core.adapter.AdapterUtils;
import com.microsoft.java.debug.core.adapter.ErrorCode;
import com.microsoft.java.debug.core.adapter.IDebugAdapterContext;
import com.microsoft.java.debug.core.adapter.IDebugRequestHandler;
import com.microsoft.java.debug.core.adapter.IEvaluationProvider;
import com.microsoft.java.debug.core.adapter.variables.IVariableFormatter;
import com.microsoft.java.debug.core.adapter.variables.JavaLogicalStructure;
import com.microsoft.java.debug.core.adapter.variables.JavaLogicalStructureManager;
import com.microsoft.java.debug.core.adapter.variables.StackFrameReference;
import com.microsoft.java.debug.core.adapter.variables.VariableDetailUtils;
import com.microsoft.java.debug.core.adapter.variables.VariableProxy;
import com.microsoft.java.debug.core.adapter.variables.VariableUtils;
import com.microsoft.java.debug.core.protocol.Messages;
import com.microsoft.java.debug.core.protocol.Requests;
import com.microsoft.java.debug.core.protocol.Responses;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import com.sun.jdi.VoidValue;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class EvaluateRequestHandler
implements IDebugRequestHandler {
    protected final Logger logger;

    public EvaluateRequestHandler(Logger logger) {
        this.logger = logger;
    }

    @Override
    public List<Requests.Command> getTargetCommands() {
        return Arrays.asList(Requests.Command.EVALUATE);
    }

    @Override
    public CompletableFuture<Messages.Response> handle(Requests.Command command, Requests.Arguments arguments, Messages.Response response, IDebugAdapterContext iDebugAdapterContext) {
        Requests.EvaluateArguments evaluateArguments = (Requests.EvaluateArguments)arguments;
        boolean bl = DebugSettings.getCurrent().showStaticVariables;
        Map<String, Object> map = iDebugAdapterContext.getVariableFormatter().getDefaultOptions();
        VariableUtils.applyFormatterOptions(map, evaluateArguments.format != null && evaluateArguments.format.hex);
        String string = evaluateArguments.expression;
        if (StringUtils.isBlank((CharSequence)string)) {
            throw new CompletionException(AdapterUtils.createUserErrorDebugException("Failed to evaluate. Reason: Empty expression cannot be evaluated.", ErrorCode.EVALUATION_COMPILE_ERROR));
        }
        StackFrameReference stackFrameReference = (StackFrameReference)iDebugAdapterContext.getRecyclableIdPool().getObjectById(evaluateArguments.frameId);
        if (stackFrameReference == null) {
            throw new CompletionException(AdapterUtils.createUserErrorDebugException("Evaluation failed because the thread is not suspended.", ErrorCode.EVALUATE_NOT_SUSPENDED_THREAD));
        }
        return CompletableFuture.supplyAsync(() -> {
            IEvaluationProvider iEvaluationProvider = iDebugAdapterContext.getProvider(IEvaluationProvider.class);
            try {
                Value value = iEvaluationProvider.evaluate(string, stackFrameReference.getThread(), stackFrameReference.getDepth()).get();
                IVariableFormatter iVariableFormatter = iDebugAdapterContext.getVariableFormatter();
                if (value instanceof VoidValue) {
                    response.body = new Responses.EvaluateResponseBody(value.toString(), 0, "<void>", 0);
                    return response;
                }
                long l = stackFrameReference.getThread().uniqueID();
                if (value instanceof ObjectReference) {
                    VariableProxy variableProxy = new VariableProxy(stackFrameReference.getThread(), "eval", value, null, string);
                    int n = -1;
                    Value value2 = null;
                    if (value instanceof ArrayReference) {
                        n = ((ArrayReference)value).length();
                    } else if (value instanceof ObjectReference && DebugSettings.getCurrent().showLogicalStructure && iEvaluationProvider != null) {
                        try {
                            JavaLogicalStructure javaLogicalStructure = JavaLogicalStructureManager.getLogicalStructure((ObjectReference)value);
                            if (javaLogicalStructure != null && javaLogicalStructure.getSizeExpression() != null && (value2 = javaLogicalStructure.getSize((ObjectReference)value, stackFrameReference.getThread(), iEvaluationProvider)) != null && value2 instanceof IntegerValue) {
                                n = ((IntegerValue)value2).value();
                            }
                        }
                        catch (Exception exception) {
                            this.logger.log(Level.INFO, "Failed to get the logical size of the variable", exception);
                        }
                    }
                    int n2 = 0;
                    if (n > 0 || n < 0 && value instanceof ObjectReference) {
                        n2 = iDebugAdapterContext.getRecyclableIdPool().addObject(l, variableProxy);
                    }
                    boolean bl = false;
                    String string2 = null;
                    try {
                        string2 = iVariableFormatter.valueToString(value, map);
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        bl = true;
                        this.logger.log(Level.SEVERE, "Failed to convert the value of a large object to a string", outOfMemoryError);
                        string2 = "<Unable to display the value of a large object>";
                    }
                    catch (Exception exception) {
                        bl = true;
                        this.logger.log(Level.SEVERE, "Failed to resolve the variable value", exception);
                        string2 = "<Failed to resolve the variable value due to \"" + exception.getMessage() + "\">";
                    }
                    String string3 = null;
                    if (!bl) {
                        if (value2 != null) {
                            string3 = "size=" + iVariableFormatter.valueToString(value2, map);
                        } else if (DebugSettings.getCurrent().showToString) {
                            try {
                                string3 = VariableDetailUtils.formatDetailsValue(value, stackFrameReference.getThread(), iVariableFormatter, map, iEvaluationProvider);
                            }
                            catch (OutOfMemoryError outOfMemoryError) {
                                this.logger.log(Level.SEVERE, "Failed to compute the toString() value of a large object", outOfMemoryError);
                                string3 = "<Unable to display the details of a large object>";
                            }
                            catch (Exception exception) {
                                this.logger.log(Level.SEVERE, "Failed to compute the toString() value", exception);
                                string3 = "<Failed to resolve the variable details due to \"" + exception.getMessage() + "\">";
                            }
                        }
                    }
                    if ("clipboard".equals(evaluateArguments.context) && string3 != null) {
                        response.body = new Responses.EvaluateResponseBody(string3, -1, "String", 0);
                    } else {
                        String string4 = "";
                        try {
                            string4 = iVariableFormatter.typeToString(value == null ? null : value.type(), map);
                        }
                        catch (Exception exception) {
                            this.logger.log(Level.SEVERE, "Failed to resolve the variable type", exception);
                            string4 = "";
                        }
                        response.body = new Responses.EvaluateResponseBody(string3 == null ? string2 : string2 + " " + string3, n2, string4, Math.max(n, 0));
                    }
                    return response;
                }
                response.body = new Responses.EvaluateResponseBody(iVariableFormatter.valueToString(value, map), 0, iVariableFormatter.typeToString(value == null ? null : value.type(), map), 0);
                return response;
            }
            catch (InterruptedException | ExecutionException exception) {
                Throwable throwable = exception;
                if (exception instanceof ExecutionException && exception.getCause() != null) {
                    throwable = exception.getCause();
                }
                if (throwable instanceof DebugException) {
                    throw new CompletionException(throwable);
                }
                throw AdapterUtils.createCompletionException(String.format("Cannot evaluate because of %s.", throwable.toString()), ErrorCode.EVALUATE_FAILURE, throwable);
            }
        });
    }
}

