/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter.handler;

import com.microsoft.java.debug.core.DebugEvent;
import com.microsoft.java.debug.core.DebugUtility;
import com.microsoft.java.debug.core.IDebugSession;
import com.microsoft.java.debug.core.JdiExceptionReference;
import com.microsoft.java.debug.core.UsageDataSession;
import com.microsoft.java.debug.core.adapter.AdapterUtils;
import com.microsoft.java.debug.core.adapter.ErrorCode;
import com.microsoft.java.debug.core.adapter.IDebugAdapterContext;
import com.microsoft.java.debug.core.adapter.IDebugRequestHandler;
import com.microsoft.java.debug.core.adapter.IEvaluationProvider;
import com.microsoft.java.debug.core.adapter.IVirtualMachineManagerProvider;
import com.microsoft.java.debug.core.adapter.handler.VMHandler;
import com.microsoft.java.debug.core.protocol.Events;
import com.microsoft.java.debug.core.protocol.Messages;
import com.microsoft.java.debug.core.protocol.Requests;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.event.BreakpointEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.ExceptionEvent;
import com.sun.jdi.event.ThreadDeathEvent;
import com.sun.jdi.event.ThreadStartEvent;
import com.sun.jdi.event.VMDeathEvent;
import com.sun.jdi.event.VMDisconnectEvent;
import com.sun.jdi.event.VMStartEvent;
import com.sun.jdi.request.EventRequestManager;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Logger;

public class ConfigurationDoneRequestHandler
implements IDebugRequestHandler {
    protected final Logger logger;
    private VMHandler vmHandler = new VMHandler();

    public ConfigurationDoneRequestHandler(Logger logger) {
        this.logger = logger;
    }

    @Override
    public List<Requests.Command> getTargetCommands() {
        return Arrays.asList(Requests.Command.CONFIGURATIONDONE);
    }

    @Override
    public CompletableFuture<Messages.Response> handle(Requests.Command command, Requests.Arguments arguments, Messages.Response response, IDebugAdapterContext iDebugAdapterContext) {
        IDebugSession iDebugSession = iDebugAdapterContext.getDebugSession();
        this.vmHandler.setVmProvider(iDebugAdapterContext.getProvider(IVirtualMachineManagerProvider.class));
        if (iDebugSession != null) {
            iDebugSession.getEventHub().events().subscribe(debugEvent -> this.handleDebugEvent((DebugEvent)debugEvent, iDebugSession, iDebugAdapterContext));
            iDebugSession.start();
            return CompletableFuture.completedFuture(response);
        }
        iDebugAdapterContext.getProtocolServer().sendEvent(new Events.TerminatedEvent());
        return AdapterUtils.createAsyncErrorResponse(response, ErrorCode.EMPTY_DEBUG_SESSION, "Failed to launch debug session, the debugger will exit.");
    }

    private void handleDebugEvent(DebugEvent debugEvent, IDebugSession iDebugSession, IDebugAdapterContext iDebugAdapterContext) {
        Object object;
        Event event = debugEvent.event;
        boolean bl = true;
        if (event instanceof VMStartEvent) {
            if (iDebugAdapterContext.isVmStopOnEntry()) {
                DebugUtility.stopOnEntry(iDebugSession, iDebugAdapterContext.getMainClass()).thenAccept(l -> this.notifyStopEvent("entry", (long)l, iDebugAdapterContext));
            }
        } else if (event instanceof VMDeathEvent) {
            this.vmHandler.disconnectVirtualMachine(event.virtualMachine());
            iDebugAdapterContext.setVmTerminated();
            iDebugAdapterContext.getProtocolServer().sendEvent(new Events.ExitedEvent(0));
        } else if (event instanceof VMDisconnectEvent) {
            this.vmHandler.disconnectVirtualMachine(event.virtualMachine());
            if (iDebugAdapterContext.isAttached()) {
                iDebugAdapterContext.setVmTerminated();
                iDebugAdapterContext.getProtocolServer().sendEvent(new Events.TerminatedEvent());
                try {
                    iDebugSession.getEventHub().close();
                }
                catch (Exception exception) {}
            }
        } else if (event instanceof ThreadStartEvent) {
            object = ((ThreadStartEvent)event).thread();
            Events.ThreadEvent threadEvent = new Events.ThreadEvent("started", object.uniqueID());
            iDebugAdapterContext.getProtocolServer().sendEvent(threadEvent);
        } else if (event instanceof ThreadDeathEvent) {
            object = ((ThreadDeathEvent)event).thread();
            Events.ThreadEvent threadEvent = new Events.ThreadEvent("exited", object.uniqueID());
            iDebugAdapterContext.getProtocolServer().sendEvent(threadEvent);
        } else if (!(event instanceof BreakpointEvent)) {
            if (event instanceof ExceptionEvent) {
                object = ((ExceptionEvent)event).thread();
                ThreadReference threadReference = ((ExceptionEvent)event).thread();
                IEvaluationProvider iEvaluationProvider = iDebugAdapterContext.getProvider(IEvaluationProvider.class);
                if (iEvaluationProvider.isInEvaluation(threadReference)) {
                    return;
                }
                JdiExceptionReference jdiExceptionReference = new JdiExceptionReference(((ExceptionEvent)event).exception(), ((ExceptionEvent)event).catchLocation() == null);
                iDebugAdapterContext.getExceptionManager().setException(object.uniqueID(), jdiExceptionReference);
                this.notifyStopEvent("exception", object.uniqueID(), iDebugAdapterContext);
                debugEvent.shouldResume = false;
            } else {
                bl = false;
            }
        }
        if (bl && (object = UsageDataSession.currentSession()) != null) {
            ((UsageDataSession)object).recordEvent(event);
        }
    }

    private void notifyStopEvent(String string, long l, IDebugAdapterContext iDebugAdapterContext) {
        EventRequestManager eventRequestManager = iDebugAdapterContext.getDebugSession().getVM().eventRequestManager();
        iDebugAdapterContext.getStepRequestManager().deletePendingStep(l, eventRequestManager);
        iDebugAdapterContext.getProtocolServer().sendEvent(new Events.StoppedEvent(string, l));
    }
}

