/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter.handler;

import com.microsoft.java.debug.core.adapter.handler.ILaunchDelegate;
import com.microsoft.java.debug.core.protocol.Requests;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

abstract class AbstractLaunchDelegate
implements ILaunchDelegate {
    protected final Logger logger;

    protected AbstractLaunchDelegate(Logger logger) {
        this.logger = logger;
    }

    protected String[] constructEnvironmentVariables(Requests.LaunchArguments launchArguments) {
        String[] stringArray = null;
        if (launchArguments.env != null && !launchArguments.env.isEmpty()) {
            HashMap<String, String> hashMap = new HashMap<String, String>(System.getenv());
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Map.Entry<String, String> entry : launchArguments.env.entrySet()) {
                if (hashMap.containsKey(entry.getKey())) {
                    arrayList.add(entry.getKey());
                }
                hashMap.put(entry.getKey(), entry.getValue());
            }
            if (!arrayList.isEmpty()) {
                this.logger.warning(String.format("There are duplicated environment variables. The values specified in launch.json will be used. Here are the duplicated entries: %s.", String.join((CharSequence)",", arrayList)));
            }
            stringArray = new String[hashMap.size()];
            int n = 0;
            for (Map.Entry entry : hashMap.entrySet()) {
                stringArray[n++] = (String)entry.getKey() + "=" + (String)entry.getValue();
            }
        }
        return stringArray;
    }
}

