/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter.handler;

import com.microsoft.java.debug.core.adapter.IDebugAdapterContext;
import com.microsoft.java.debug.core.adapter.IDebugRequestHandler;
import com.microsoft.java.debug.core.adapter.IHotCodeReplaceProvider;
import com.microsoft.java.debug.core.adapter.LaunchMode;
import com.microsoft.java.debug.core.protocol.Messages;
import com.microsoft.java.debug.core.protocol.Requests;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractDisconnectRequestHandler
implements IDebugRequestHandler {
    private final Logger logger;

    public AbstractDisconnectRequestHandler(Logger logger) {
        this.logger = logger;
    }

    @Override
    public List<Requests.Command> getTargetCommands() {
        return Arrays.asList(Requests.Command.DISCONNECT);
    }

    @Override
    public CompletableFuture<Messages.Response> handle(Requests.Command command, Requests.Arguments arguments, Messages.Response response, IDebugAdapterContext iDebugAdapterContext) {
        iDebugAdapterContext.setVmTerminated();
        this.destroyDebugSession(command, arguments, response, iDebugAdapterContext);
        this.destroyResource(iDebugAdapterContext);
        return CompletableFuture.completedFuture(response);
    }

    private void destroyResource(IDebugAdapterContext iDebugAdapterContext) {
        this.destroyProviders(iDebugAdapterContext);
        if (this.shouldDestroyLaunchFiles(iDebugAdapterContext)) {
            this.destroyLaunchFiles(iDebugAdapterContext);
        }
    }

    private boolean shouldDestroyLaunchFiles(IDebugAdapterContext iDebugAdapterContext) {
        return iDebugAdapterContext.getLaunchMode() == LaunchMode.DEBUG || iDebugAdapterContext.getDebuggeeProcess() != null;
    }

    private void destroyLaunchFiles(IDebugAdapterContext iDebugAdapterContext) {
        int n = 5;
        while (n-- > 0) {
            try {
                if (iDebugAdapterContext.getClasspathJar() != null) {
                    Files.deleteIfExists(iDebugAdapterContext.getClasspathJar());
                    iDebugAdapterContext.setClasspathJar(null);
                }
                if (iDebugAdapterContext.getArgsfile() == null) break;
                Files.deleteIfExists(iDebugAdapterContext.getArgsfile());
                iDebugAdapterContext.setArgsfile(null);
                break;
            }
            catch (IOException iOException) {
                this.logger.log(Level.WARNING, "Failed to destory launch files, will retry again.");
                try {
                    TimeUnit.MILLISECONDS.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    protected abstract void destroyDebugSession(Requests.Command var1, Requests.Arguments var2, Messages.Response var3, IDebugAdapterContext var4);

    protected void destroyProviders(IDebugAdapterContext iDebugAdapterContext) {
        IHotCodeReplaceProvider iHotCodeReplaceProvider = iDebugAdapterContext.getProvider(IHotCodeReplaceProvider.class);
        if (iHotCodeReplaceProvider != null) {
            iHotCodeReplaceProvider.close();
        }
    }
}

