/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter.formatter;

import com.microsoft.java.debug.core.adapter.formatter.IValueFormatter;
import com.microsoft.java.debug.core.adapter.formatter.NumericFormatEnum;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import java.util.HashMap;
import java.util.Map;

public class NumericFormatter
implements IValueFormatter {
    public static final String NUMERIC_FORMAT_OPTION = "numeric_format";
    public static final String NUMERIC_PRECISION_OPTION = "numeric_precision";
    private static final NumericFormatEnum DEFAULT_NUMERIC_FORMAT = NumericFormatEnum.DEC;
    private static final int DEFAULT_NUMERIC_PRECISION = 0;
    private static final Map<NumericFormatEnum, String> enumFormatMap = new HashMap<NumericFormatEnum, String>();

    @Override
    public String toString(Object object, Map<String, Object> map) {
        Value value = (Value)object;
        char c = value.type().signature().charAt(0);
        if (c == 'J' || c == 'I' || c == 'S' || c == 'B') {
            return NumericFormatter.formatNumber(Long.parseLong(value.toString()), map);
        }
        if (NumericFormatter.hasFraction(c)) {
            return NumericFormatter.formatFloatDouble(Double.parseDouble(value.toString()), map);
        }
        throw new UnsupportedOperationException(String.format("%s is not a numeric type.", value.type().name()));
    }

    @Override
    public Value valueOf(String string, Type type, Map<String, Object> map) {
        VirtualMachine virtualMachine = type.virtualMachine();
        char c = type.signature().charAt(0);
        if (c == 'J' || c == 'I' || c == 'S' || c == 'B') {
            long l = NumericFormatter.parseNumber(string);
            if (c == 'J') {
                return virtualMachine.mirrorOf(l);
            }
            if (c == 'I') {
                return virtualMachine.mirrorOf((int)l);
            }
            if (c == 'S') {
                return virtualMachine.mirrorOf((short)l);
            }
            if (c == 'B') {
                return virtualMachine.mirrorOf((byte)l);
            }
        } else if (NumericFormatter.hasFraction(c)) {
            double d = NumericFormatter.parseFloatDouble(string);
            if (c == 'D') {
                return virtualMachine.mirrorOf(d);
            }
            return virtualMachine.mirrorOf((float)d);
        }
        throw new UnsupportedOperationException(String.format("%s is not a numeric type.", type.name()));
    }

    @Override
    public boolean acceptType(Type type, Map<String, Object> map) {
        if (type == null) {
            return false;
        }
        char c = type.signature().charAt(0);
        return c == 'J' || c == 'I' || c == 'S' || c == 'B' || c == 'F' || c == 'D';
    }

    @Override
    public Map<String, Object> getDefaultOptions() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(NUMERIC_FORMAT_OPTION, (Object)DEFAULT_NUMERIC_FORMAT);
        hashMap.put(NUMERIC_PRECISION_OPTION, 0);
        return hashMap;
    }

    static String formatNumber(long l, Map<String, Object> map) {
        NumericFormatEnum numericFormatEnum = NumericFormatter.getNumericFormatOption(map);
        return String.format(enumFormatMap.get((Object)numericFormatEnum), l);
    }

    private static long parseNumber(String string) {
        return Long.decode(string);
    }

    private static double parseFloatDouble(String string) {
        return Double.parseDouble(string);
    }

    private static String formatFloatDouble(double d, Map<String, Object> map) {
        int n = NumericFormatter.getFractionPrecision(map);
        return String.format(n > 0 ? String.format("%%.%df", n) : "%f", d);
    }

    private static NumericFormatEnum getNumericFormatOption(Map<String, Object> map) {
        return map.containsKey(NUMERIC_FORMAT_OPTION) ? (NumericFormatEnum)((Object)map.get(NUMERIC_FORMAT_OPTION)) : DEFAULT_NUMERIC_FORMAT;
    }

    private static boolean hasFraction(char c) {
        return c == 'F' || c == 'D';
    }

    private static int getFractionPrecision(Map<String, Object> map) {
        return map.containsKey(NUMERIC_PRECISION_OPTION) ? (Integer)map.get(NUMERIC_PRECISION_OPTION) : 0;
    }

    static {
        enumFormatMap.put(NumericFormatEnum.DEC, "%d");
        enumFormatMap.put(NumericFormatEnum.HEX, "%#x");
        enumFormatMap.put(NumericFormatEnum.OCT, "%#o");
    }
}

