/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter;

import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class IdCollection<T> {
    private int startId;
    private AtomicInteger nextId;
    private HashMap<Integer, T> idMap;
    private HashMap<T, Integer> reverseMap;

    public IdCollection() {
        this(1);
    }

    public IdCollection(int n) {
        this.startId = n;
        this.nextId = new AtomicInteger(n);
        this.idMap = new HashMap();
        this.reverseMap = new HashMap();
    }

    public void reset() {
        this.nextId.set(this.startId);
        this.idMap.clear();
        this.reverseMap.clear();
    }

    public int create(T t) {
        if (this.reverseMap.containsKey(t)) {
            return this.reverseMap.get(t);
        }
        int n = this.nextId.getAndIncrement();
        this.idMap.put(n, t);
        this.reverseMap.put(t, n);
        return n;
    }

    public T get(int n) {
        return this.idMap.get(n);
    }

    public T remove(int n) {
        T t = this.idMap.remove(n);
        if (t != null) {
            this.reverseMap.remove(t);
        }
        return t;
    }
}

