/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core;

import com.microsoft.java.debug.core.DebugSession;
import com.microsoft.java.debug.core.DebugSettings;
import com.microsoft.java.debug.core.IDebugSession;
import com.microsoft.java.debug.core.adapter.AdapterUtils;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.VirtualMachineManager;
import com.sun.jdi.connect.AttachingConnector;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.connect.LaunchingConnector;
import com.sun.jdi.connect.VMStartException;
import com.sun.jdi.event.MethodEntryEvent;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.MethodEntryRequest;
import com.sun.jdi.request.StepRequest;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class DebugUtility {
    public static final String HOME = "home";
    public static final String OPTIONS = "options";
    public static final String MAIN = "main";
    public static final String SUSPEND = "suspend";
    public static final String QUOTE = "quote";
    public static final String EXEC = "vmexec";
    public static final String CWD = "cwd";
    public static final String ENV = "env";
    public static final String HOSTNAME = "hostname";
    public static final String PORT = "port";
    public static final String TIMEOUT = "timeout";

    public static IDebugSession launch(VirtualMachineManager virtualMachineManager, String string, String string2, String string3, List<String> list, List<String> list2, String string4, String[] stringArray, Logger logger) throws IOException, IllegalConnectorArgumentsException, VMStartException {
        return DebugUtility.launch(virtualMachineManager, string, string2, string3, String.join((CharSequence)File.pathSeparator, list), String.join((CharSequence)File.pathSeparator, list2), string4, stringArray, logger);
    }

    public static IDebugSession launch(VirtualMachineManager virtualMachineManager, String string, String string2, String string3, List<String> list, List<String> list2, String string4, String[] stringArray, String string5, Logger logger) throws IOException, IllegalConnectorArgumentsException, VMStartException {
        return DebugUtility.launch(virtualMachineManager, string, string2, string3, String.join((CharSequence)File.pathSeparator, list), String.join((CharSequence)File.pathSeparator, list2), string4, stringArray, string5, logger);
    }

    public static IDebugSession launch(VirtualMachineManager virtualMachineManager, String string, String string2, String string3, String string4, String string5, String string6, String[] stringArray, Logger logger) throws IOException, IllegalConnectorArgumentsException, VMStartException {
        return DebugUtility.launch(virtualMachineManager, string, string2, string3, string4, string5, string6, stringArray, null, logger);
    }

    /*
     * WARNING - void declaration
     */
    public static IDebugSession launch(VirtualMachineManager virtualMachineManager, String string, String string2, String string3, String string4, String string5, String string6, String[] stringArray, String string7, Logger logger) throws IOException, IllegalConnectorArgumentsException, VMStartException {
        Object object;
        void var14_20;
        List<LaunchingConnector> list = virtualMachineManager.launchingConnectors();
        LaunchingConnector launchingConnector = list.get(0);
        for (LaunchingConnector object22 : list) {
            if (!object22.getClass().getName().equals("com.sun.tools.jdi.SunCommandLineLauncher")) continue;
            launchingConnector = object22;
            break;
        }
        Map<String, Connector.Argument> map = launchingConnector.defaultArguments();
        ((Connector.Argument)map.get(SUSPEND)).setValue("true");
        String string8 = "";
        if (StringUtils.isNotBlank((CharSequence)string3)) {
            String string9 = string3;
        }
        if (StringUtils.isNotBlank((CharSequence)string4)) {
            void var14_16;
            String string10 = (String)var14_16 + " --module-path \"" + string4 + "\"";
        }
        if (StringUtils.isNotBlank((CharSequence)string5)) {
            void var14_18;
            String string11 = (String)var14_18 + " -cp \"" + string5 + "\"";
        }
        ((Connector.Argument)map.get(OPTIONS)).setValue((String)var14_20);
        String[] stringArray2 = string.split("/");
        if (stringArray2.length == 2) {
            string = "-m " + string;
        }
        if (StringUtils.isNotBlank((CharSequence)string2)) {
            string = string + " " + string2;
        }
        ((Connector.Argument)map.get(MAIN)).setValue(string);
        if (map.get(CWD) != null) {
            ((Connector.Argument)map.get(CWD)).setValue(string6);
        }
        if (map.get(ENV) != null) {
            ((Connector.Argument)map.get(ENV)).setValue(DebugUtility.encodeArrayArgument(stringArray));
        }
        if (DebugUtility.isValidJavaExec(string7)) {
            object = new File(string7).getName();
            String string12 = new File(string7).getParentFile().getParentFile().getAbsolutePath();
            ((Connector.Argument)map.get(HOME)).setValue(string12);
            ((Connector.Argument)map.get(EXEC)).setValue((String)object);
        } else if (StringUtils.isNotEmpty((CharSequence)DebugSettings.getCurrent().javaHome)) {
            ((Connector.Argument)map.get(HOME)).setValue(DebugSettings.getCurrent().javaHome);
        }
        object = launchingConnector.launch((Map<String, ? extends Connector.Argument>)map);
        object.version();
        return new DebugSession((VirtualMachine)object, logger);
    }

    private static boolean isValidJavaExec(String string) {
        if (StringUtils.isBlank((CharSequence)string)) {
            return false;
        }
        File file = new File(string);
        if (!file.exists() || !file.isFile()) {
            return false;
        }
        return Files.isExecutable(file.toPath()) && Objects.equals(file.getParentFile().getName(), "bin");
    }

    public static IDebugSession attach(VirtualMachineManager virtualMachineManager, String string, int n, int n2, Logger logger) throws IOException, IllegalConnectorArgumentsException {
        List<AttachingConnector> list = virtualMachineManager.attachingConnectors();
        AttachingConnector attachingConnector = list.get(0);
        for (AttachingConnector attachingConnector2 : list) {
            if (!attachingConnector2.getClass().getName().equals("com.sun.tools.jdi.SocketAttachingConnector")) continue;
            attachingConnector = attachingConnector2;
            break;
        }
        Map<String, Connector.Argument> map = attachingConnector.defaultArguments();
        ((Connector.Argument)map.get(HOSTNAME)).setValue(string);
        ((Connector.Argument)map.get(PORT)).setValue(String.valueOf(n));
        ((Connector.Argument)map.get(TIMEOUT)).setValue(String.valueOf(n2));
        return new DebugSession(attachingConnector.attach((Map<String, ? extends Connector.Argument>)map), logger);
    }

    public static StepRequest createStepOverRequest(ThreadReference threadReference, String[] stringArray) {
        return DebugUtility.createStepOverRequest(threadReference, null, stringArray);
    }

    public static StepRequest createStepOverRequest(ThreadReference threadReference, String[] stringArray, String[] stringArray2) {
        return DebugUtility.createStepRequest(threadReference, -2, 2, stringArray, stringArray2);
    }

    public static StepRequest createStepIntoRequest(ThreadReference threadReference, String[] stringArray) {
        return DebugUtility.createStepIntoRequest(threadReference, null, stringArray);
    }

    public static StepRequest createStepIntoRequest(ThreadReference threadReference, String[] stringArray, String[] stringArray2) {
        return DebugUtility.createStepRequest(threadReference, -2, 1, stringArray, stringArray2);
    }

    public static StepRequest createStepOutRequest(ThreadReference threadReference, String[] stringArray) {
        return DebugUtility.createStepOutRequest(threadReference, null, stringArray);
    }

    public static StepRequest createStepOutRequest(ThreadReference threadReference, String[] stringArray, String[] stringArray2) {
        return DebugUtility.createStepRequest(threadReference, -2, 3, stringArray, stringArray2);
    }

    private static StepRequest createStepRequest(ThreadReference threadReference, int n, int n2, String[] stringArray, String[] stringArray2) {
        StepRequest stepRequest = threadReference.virtualMachine().eventRequestManager().createStepRequest(threadReference, n, n2);
        if (stringArray != null) {
            for (String string : stringArray) {
                stepRequest.addClassFilter(string);
            }
        }
        if (stringArray2 != null) {
            for (String string : stringArray2) {
                stepRequest.addClassExclusionFilter(string);
            }
        }
        stepRequest.setSuspendPolicy(1);
        stepRequest.addCountFilter(1);
        return stepRequest;
    }

    public static CompletableFuture<Long> stopOnEntry(IDebugSession iDebugSession, String string) {
        CompletableFuture<Long> completableFuture = new CompletableFuture<Long>();
        EventRequestManager eventRequestManager = iDebugSession.getVM().eventRequestManager();
        MethodEntryRequest methodEntryRequest = eventRequestManager.createMethodEntryRequest();
        methodEntryRequest.addClassFilter(string);
        methodEntryRequest.setSuspendPolicy(1);
        iDebugSession.getEventHub().events().filter(debugEvent -> debugEvent.event instanceof MethodEntryEvent && methodEntryRequest.equals(debugEvent.event.request())).subscribe(debugEvent -> {
            Method method = ((MethodEntryEvent)debugEvent.event).method();
            if (method.isPublic() && method.isStatic() && method.name().equals(MAIN) && method.signature().equals("([Ljava/lang/String;)V")) {
                DebugUtility.deleteEventRequestSafely(iDebugSession.getVM().eventRequestManager(), methodEntryRequest);
                debugEvent.shouldResume = false;
                ThreadReference threadReference = ((MethodEntryEvent)debugEvent.event).thread();
                completableFuture.complete(threadReference.uniqueID());
            }
        });
        methodEntryRequest.enable();
        return completableFuture;
    }

    public static ThreadReference getThread(IDebugSession iDebugSession, long l) {
        for (ThreadReference threadReference : DebugUtility.getAllThreadsSafely(iDebugSession)) {
            if (threadReference.uniqueID() != l || threadReference.isCollected()) continue;
            return threadReference;
        }
        return null;
    }

    public static List<ThreadReference> getAllThreadsSafely(IDebugSession iDebugSession) {
        if (iDebugSession != null) {
            try {
                return iDebugSession.getAllThreads();
            }
            catch (VMDisconnectedException vMDisconnectedException) {
                // empty catch block
            }
        }
        return new ArrayList<ThreadReference>();
    }

    public static void resumeThread(ThreadReference threadReference) {
        if (threadReference == null || threadReference.isCollected()) {
            return;
        }
        try {
            int n = threadReference.suspendCount();
            for (int i = 0; i < n; ++i) {
                threadReference.resume();
            }
        }
        catch (ObjectCollectedException objectCollectedException) {
            // empty catch block
        }
    }

    public static void deleteEventRequestSafely(EventRequestManager eventRequestManager, EventRequest eventRequest) {
        try {
            eventRequestManager.deleteEventRequest(eventRequest);
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            // empty catch block
        }
    }

    public static void deleteEventRequestSafely(EventRequestManager eventRequestManager, List<EventRequest> list) {
        try {
            eventRequestManager.deleteEventRequests(list);
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            // empty catch block
        }
    }

    public static String encodeArrayArgument(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : stringArray) {
            try {
                arrayList.add(URLEncoder.encode(string, StandardCharsets.UTF_8.name()));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return String.join((CharSequence)"\n", arrayList);
    }

    public static String[] decodeArrayArgument(String string) {
        String[] stringArray;
        if (string == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : stringArray = string.split("\n")) {
            try {
                arrayList.add(URLDecoder.decode(string2, StandardCharsets.UTF_8.name()));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return arrayList.toArray(new String[0]);
    }

    public static List<String> parseArguments(String string) {
        if (string == null) {
            return new ArrayList<String>();
        }
        return AdapterUtils.isWindows() ? DebugUtility.parseArgumentsWindows(string) : DebugUtility.parseArgumentsNonWindows(string);
    }

    private static List<String> parseArgumentsNonWindows(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = string.length();
        block5: for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            if (Character.isWhitespace(c)) {
                if (n == 0) continue;
                if (n == 1) {
                    n = 0;
                    arrayList.add(stringBuilder.toString());
                    stringBuilder.setLength(0);
                    continue;
                }
            }
            switch (n) {
                case 0: 
                case 1: {
                    if (c == '\"') {
                        n = 2;
                        continue block5;
                    }
                    if (c == '\'') {
                        n = 3;
                        continue block5;
                    }
                    if (c == '\\' && i + 1 < n2) {
                        n = 1;
                        c = string.charAt(++i);
                        stringBuilder.append(c);
                        continue block5;
                    }
                    n = 1;
                    stringBuilder.append(c);
                    continue block5;
                }
                case 2: {
                    if (c == '\"') {
                        n = 1;
                        continue block5;
                    }
                    if (c == '\\' && i + 1 < n2 && (string.charAt(i + 1) == '\\' || string.charAt(i + 1) == '\"')) {
                        c = string.charAt(++i);
                        stringBuilder.append(c);
                        continue block5;
                    }
                    stringBuilder.append(c);
                    continue block5;
                }
                case 3: {
                    if (c == '\'') {
                        n = 1;
                        continue block5;
                    }
                    stringBuilder.append(c);
                    continue block5;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        if (stringBuilder.length() > 0 || n != 0) {
            arrayList.add(stringBuilder.toString());
        }
        return arrayList;
    }

    private static List<String> parseArgumentsWindows(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        int n2 = 0;
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = string.length();
        block4: for (int i = 0; i < n3; ++i) {
            char c = string.charAt(i);
            if (c == '\\') {
                ++n2;
                continue;
            }
            if (n2 != 0) {
                if (c == '\"') {
                    while (n2 >= 2) {
                        stringBuilder.append('\\');
                        n2 -= 2;
                    }
                    if (n2 == 1) {
                        if (n == 0) {
                            n = 1;
                        }
                        stringBuilder.append('\"');
                        n2 = 0;
                        continue;
                    }
                } else {
                    if (n == 0) {
                        n = 1;
                    }
                    while (n2 > 0) {
                        stringBuilder.append('\\');
                        --n2;
                    }
                }
            }
            if (Character.isWhitespace(c)) {
                if (n == 0) continue;
                if (n == 1) {
                    n = 0;
                    arrayList.add(stringBuilder.toString());
                    stringBuilder.setLength(0);
                    continue;
                }
            }
            switch (n) {
                case 0: 
                case 1: {
                    if (c == '\"') {
                        n = 2;
                        continue block4;
                    }
                    n = 1;
                    stringBuilder.append(c);
                    continue block4;
                }
                case 2: {
                    if (c == '\"') {
                        if (i + 1 < n3 && string.charAt(i + 1) == '\"') {
                            stringBuilder.append('\"');
                            ++i;
                            continue block4;
                        }
                        if (stringBuilder.length() == 0) {
                            arrayList.add("\"\"");
                            n = 0;
                            continue block4;
                        }
                        n = 1;
                        continue block4;
                    }
                    stringBuilder.append(c);
                    continue block4;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        if (stringBuilder.length() > 0 || n != 0) {
            arrayList.add(stringBuilder.toString());
        }
        return arrayList;
    }
}

