/*
 * Decompiled with CFR 0.152.
 */
package jline.internal;

import java.util.ArrayList;
import java.util.List;
import jline.internal.Configuration;
import jline.internal.Log;
import jline.internal.Preconditions;

public class ShutdownHooks {
    public static final String JLINE_SHUTDOWNHOOK = "jline.shutdownhook";
    private static final boolean enabled = Configuration.getBoolean("jline.shutdownhook", true);
    private static final List<Task> tasks = new ArrayList<Task>();
    private static Thread hook;

    public static synchronized <T extends Task> T add(T t) {
        Preconditions.checkNotNull(t);
        if (!enabled) {
            Log.debug("Shutdown-hook is disabled; not installing: ", t);
            return t;
        }
        if (hook == null) {
            hook = ShutdownHooks.addHook(new Thread("JLine Shutdown Hook"){

                @Override
                public void run() {
                    ShutdownHooks.runTasks();
                }
            });
        }
        Log.debug("Adding shutdown-hook task: ", t);
        tasks.add(t);
        return t;
    }

    private static synchronized void runTasks() {
        Log.debug("Running all shutdown-hook tasks");
        for (Task task : tasks.toArray(new Task[tasks.size()])) {
            Log.debug("Running task: ", task);
            try {
                task.run();
            }
            catch (Throwable throwable) {
                Log.warn("Task failed", throwable);
            }
        }
        tasks.clear();
    }

    private static Thread addHook(Thread thread) {
        Log.debug("Registering shutdown-hook: ", thread);
        try {
            Runtime.getRuntime().addShutdownHook(thread);
        }
        catch (AbstractMethodError abstractMethodError) {
            Log.debug("Failed to register shutdown-hook", abstractMethodError);
        }
        return thread;
    }

    public static synchronized void remove(Task task) {
        Preconditions.checkNotNull(task);
        if (!enabled || hook == null) {
            return;
        }
        tasks.remove(task);
        if (tasks.isEmpty()) {
            ShutdownHooks.removeHook(hook);
            hook = null;
        }
    }

    private static void removeHook(Thread thread) {
        Log.debug("Removing shutdown-hook: ", thread);
        try {
            Runtime.getRuntime().removeShutdownHook(thread);
        }
        catch (AbstractMethodError abstractMethodError) {
            Log.debug("Failed to remove shutdown-hook", abstractMethodError);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public static interface Task {
        public void run() throws Exception;
    }
}

