/*
 * Decompiled with CFR 0.152.
 */
package jline.console.completer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import jline.console.completer.Completer;
import jline.internal.Preconditions;

public class AggregateCompleter
implements Completer {
    private final List<Completer> completers = new ArrayList<Completer>();

    public AggregateCompleter() {
    }

    public AggregateCompleter(Collection<Completer> collection) {
        Preconditions.checkNotNull(collection);
        this.completers.addAll(collection);
    }

    public AggregateCompleter(Completer ... completerArray) {
        this(Arrays.asList(completerArray));
    }

    public Collection<Completer> getCompleters() {
        return this.completers;
    }

    @Override
    public int complete(String string, int n, List<CharSequence> list) {
        Preconditions.checkNotNull(list);
        ArrayList<Completion> arrayList = new ArrayList<Completion>(this.completers.size());
        int n2 = -1;
        for (Completer object : this.completers) {
            Completion completion = new Completion(list);
            completion.complete(object, string, n);
            n2 = Math.max(n2, completion.cursor);
            arrayList.add(completion);
        }
        for (Completion completion : arrayList) {
            if (completion.cursor != n2) continue;
            list.addAll(completion.candidates);
        }
        return n2;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{completers=" + this.completers + '}';
    }

    private class Completion {
        public final List<CharSequence> candidates;
        public int cursor;

        public Completion(List<CharSequence> list) {
            Preconditions.checkNotNull(list);
            this.candidates = new LinkedList<CharSequence>(list);
        }

        public void complete(Completer completer, String string, int n) {
            Preconditions.checkNotNull(completer);
            this.cursor = completer.complete(string, n, this.candidates);
        }
    }
}

