/*
 * Decompiled with CFR 0.152.
 */
package jline.console;

import java.util.HashMap;
import java.util.Map;
import jline.console.Operation;

public class KeyMap {
    public static final String VI_MOVE = "vi-move";
    public static final String VI_INSERT = "vi-insert";
    public static final String EMACS = "emacs";
    public static final String EMACS_STANDARD = "emacs-standard";
    public static final String EMACS_CTLX = "emacs-ctlx";
    public static final String EMACS_META = "emacs-meta";
    private static final int KEYMAP_LENGTH = 256;
    private static final Object NULL_FUNCTION = new Object();
    private Object[] mapping = new Object[256];
    private Object anotherKey = null;
    private String name;
    public static final char CTRL_D = '\u0004';
    public static final char CTRL_G = '\u0007';
    public static final char CTRL_H = '\b';
    public static final char CTRL_I = '\t';
    public static final char CTRL_J = '\n';
    public static final char CTRL_M = '\r';
    public static final char CTRL_R = '\u0012';
    public static final char CTRL_S = '\u0013';
    public static final char CTRL_U = '\u0015';
    public static final char CTRL_X = '\u0018';
    public static final char CTRL_Y = '\u0019';
    public static final char ESCAPE = '\u001b';
    public static final char CTRL_OB = '\u001b';
    public static final char CTRL_CB = '\u001d';
    public static final int DELETE = 127;

    public KeyMap(String string) {
        this(string, new Object[256]);
    }

    @Deprecated
    public KeyMap(String string, boolean bl) {
        this(string);
    }

    protected KeyMap(String string, Object[] objectArray) {
        this.mapping = objectArray;
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public Object getAnotherKey() {
        return this.anotherKey;
    }

    public void from(KeyMap keyMap) {
        this.mapping = keyMap.mapping;
        this.anotherKey = keyMap.anotherKey;
    }

    public Object getBound(CharSequence charSequence) {
        if (charSequence != null && charSequence.length() > 0) {
            KeyMap keyMap = this;
            for (int i = 0; i < charSequence.length(); ++i) {
                char c = charSequence.charAt(i);
                if (c > '\u00ff') {
                    return Operation.SELF_INSERT;
                }
                if (keyMap.mapping[c] instanceof KeyMap) {
                    if (i == charSequence.length() - 1) {
                        return keyMap.mapping[c];
                    }
                } else {
                    return keyMap.mapping[c];
                }
                keyMap = (KeyMap)keyMap.mapping[c];
            }
        }
        return null;
    }

    public void bindIfNotBound(CharSequence charSequence, Object object) {
        KeyMap.bind(this, charSequence, object, true);
    }

    public void bind(CharSequence charSequence, Object object) {
        KeyMap.bind(this, charSequence, object, false);
    }

    private static void bind(KeyMap keyMap, CharSequence charSequence, Object object) {
        KeyMap.bind(keyMap, charSequence, object, false);
    }

    private static void bind(KeyMap keyMap, CharSequence charSequence, Object object, boolean bl) {
        if (charSequence != null && charSequence.length() > 0) {
            for (int i = 0; i < charSequence.length(); ++i) {
                Object object2;
                char c = charSequence.charAt(i);
                if (c >= keyMap.mapping.length) {
                    return;
                }
                if (i < charSequence.length() - 1) {
                    if (!(keyMap.mapping[c] instanceof KeyMap)) {
                        object2 = new KeyMap("anonymous");
                        if (keyMap.mapping[c] != Operation.DO_LOWERCASE_VERSION) {
                            ((KeyMap)object2).anotherKey = keyMap.mapping[c];
                        }
                        keyMap.mapping[c] = object2;
                    }
                    keyMap = (KeyMap)keyMap.mapping[c];
                    continue;
                }
                if (object == null) {
                    object = NULL_FUNCTION;
                }
                if (keyMap.mapping[c] instanceof KeyMap) {
                    keyMap.anotherKey = object;
                    continue;
                }
                object2 = keyMap.mapping[c];
                if (!bl || object2 == null || object2 == Operation.DO_LOWERCASE_VERSION || object2 == Operation.VI_MOVEMENT_MODE) {
                    // empty if block
                }
                keyMap.mapping[c] = object;
            }
        }
    }

    public void setBlinkMatchingParen(boolean bl) {
        if (bl) {
            this.bind("}", (Object)Operation.INSERT_CLOSE_CURLY);
            this.bind(")", (Object)Operation.INSERT_CLOSE_PAREN);
            this.bind("]", (Object)Operation.INSERT_CLOSE_SQUARE);
        }
    }

    private static void bindArrowKeys(KeyMap keyMap) {
        KeyMap.bind(keyMap, "\u001b[0A", (Object)Operation.PREVIOUS_HISTORY);
        KeyMap.bind(keyMap, "\u001b[0B", (Object)Operation.BACKWARD_CHAR);
        KeyMap.bind(keyMap, "\u001b[0C", (Object)Operation.FORWARD_CHAR);
        KeyMap.bind(keyMap, "\u001b[0D", (Object)Operation.NEXT_HISTORY);
        KeyMap.bind(keyMap, "\u00e0\u0000", (Object)Operation.KILL_WHOLE_LINE);
        KeyMap.bind(keyMap, "\u00e0G", (Object)Operation.BEGINNING_OF_LINE);
        KeyMap.bind(keyMap, "\u00e0H", (Object)Operation.PREVIOUS_HISTORY);
        KeyMap.bind(keyMap, "\u00e0I", (Object)Operation.BEGINNING_OF_HISTORY);
        KeyMap.bind(keyMap, "\u00e0K", (Object)Operation.BACKWARD_CHAR);
        KeyMap.bind(keyMap, "\u00e0M", (Object)Operation.FORWARD_CHAR);
        KeyMap.bind(keyMap, "\u00e0O", (Object)Operation.END_OF_LINE);
        KeyMap.bind(keyMap, "\u00e0P", (Object)Operation.NEXT_HISTORY);
        KeyMap.bind(keyMap, "\u00e0Q", (Object)Operation.END_OF_HISTORY);
        KeyMap.bind(keyMap, "\u00e0R", (Object)Operation.OVERWRITE_MODE);
        KeyMap.bind(keyMap, "\u00e0S", (Object)Operation.DELETE_CHAR);
        KeyMap.bind(keyMap, "\u0000G", (Object)Operation.BEGINNING_OF_LINE);
        KeyMap.bind(keyMap, "\u0000H", (Object)Operation.PREVIOUS_HISTORY);
        KeyMap.bind(keyMap, "\u0000I", (Object)Operation.BEGINNING_OF_HISTORY);
        KeyMap.bind(keyMap, "\u0000H", (Object)Operation.PREVIOUS_HISTORY);
        KeyMap.bind(keyMap, "\u0000K", (Object)Operation.BACKWARD_CHAR);
        KeyMap.bind(keyMap, "\u0000M", (Object)Operation.FORWARD_CHAR);
        KeyMap.bind(keyMap, "\u0000O", (Object)Operation.END_OF_LINE);
        KeyMap.bind(keyMap, "\u0000P", (Object)Operation.NEXT_HISTORY);
        KeyMap.bind(keyMap, "\u0000Q", (Object)Operation.END_OF_HISTORY);
        KeyMap.bind(keyMap, "\u0000R", (Object)Operation.OVERWRITE_MODE);
        KeyMap.bind(keyMap, "\u0000S", (Object)Operation.DELETE_CHAR);
        KeyMap.bind(keyMap, "\u001b[A", (Object)Operation.PREVIOUS_HISTORY);
        KeyMap.bind(keyMap, "\u001b[B", (Object)Operation.NEXT_HISTORY);
        KeyMap.bind(keyMap, "\u001b[C", (Object)Operation.FORWARD_CHAR);
        KeyMap.bind(keyMap, "\u001b[D", (Object)Operation.BACKWARD_CHAR);
        KeyMap.bind(keyMap, "\u001b[H", (Object)Operation.BEGINNING_OF_LINE);
        KeyMap.bind(keyMap, "\u001b[F", (Object)Operation.END_OF_LINE);
        KeyMap.bind(keyMap, "\u001bOA", (Object)Operation.PREVIOUS_HISTORY);
        KeyMap.bind(keyMap, "\u001bOB", (Object)Operation.NEXT_HISTORY);
        KeyMap.bind(keyMap, "\u001bOC", (Object)Operation.FORWARD_CHAR);
        KeyMap.bind(keyMap, "\u001bOD", (Object)Operation.BACKWARD_CHAR);
        KeyMap.bind(keyMap, "\u001bOH", (Object)Operation.BEGINNING_OF_LINE);
        KeyMap.bind(keyMap, "\u001bOF", (Object)Operation.END_OF_LINE);
        KeyMap.bind(keyMap, "\u001b[1~", (Object)Operation.BEGINNING_OF_LINE);
        KeyMap.bind(keyMap, "\u001b[4~", (Object)Operation.END_OF_LINE);
        KeyMap.bind(keyMap, "\u001b[3~", (Object)Operation.DELETE_CHAR);
        KeyMap.bind(keyMap, "\u001c0H", (Object)Operation.PREVIOUS_HISTORY);
        KeyMap.bind(keyMap, "\u001c0P", (Object)Operation.NEXT_HISTORY);
        KeyMap.bind(keyMap, "\u001c0M", (Object)Operation.FORWARD_CHAR);
        KeyMap.bind(keyMap, "\u001c0K", (Object)Operation.BACKWARD_CHAR);
    }

    public static boolean isMeta(char c) {
        return c > '\u007f' && c <= '\u00ff';
    }

    public static char unMeta(char c) {
        return (char)(c & 0x7F);
    }

    public static char meta(char c) {
        return (char)(c | 0x80);
    }

    public static Map<String, KeyMap> keyMaps() {
        HashMap<String, KeyMap> hashMap = new HashMap<String, KeyMap>();
        KeyMap keyMap = KeyMap.emacs();
        KeyMap.bindArrowKeys(keyMap);
        hashMap.put(EMACS, keyMap);
        hashMap.put(EMACS_STANDARD, keyMap);
        hashMap.put(EMACS_CTLX, (KeyMap)keyMap.getBound("\u0018"));
        hashMap.put(EMACS_META, (KeyMap)keyMap.getBound("\u001b"));
        KeyMap keyMap2 = KeyMap.viMovement();
        KeyMap.bindArrowKeys(keyMap2);
        hashMap.put(VI_MOVE, keyMap2);
        hashMap.put("vi-command", keyMap2);
        hashMap.put("vi", keyMap2);
        KeyMap keyMap3 = KeyMap.viInsertion();
        KeyMap.bindArrowKeys(keyMap3);
        hashMap.put(VI_INSERT, keyMap3);
        return hashMap;
    }

    public static KeyMap emacs() {
        Object[] objectArray = new Object[256];
        Object[] objectArray2 = new Object[]{Operation.SET_MARK, Operation.BEGINNING_OF_LINE, Operation.BACKWARD_CHAR, Operation.INTERRUPT, Operation.EXIT_OR_DELETE_CHAR, Operation.END_OF_LINE, Operation.FORWARD_CHAR, Operation.ABORT, Operation.BACKWARD_DELETE_CHAR, Operation.COMPLETE, Operation.ACCEPT_LINE, Operation.KILL_LINE, Operation.CLEAR_SCREEN, Operation.ACCEPT_LINE, Operation.NEXT_HISTORY, null, Operation.PREVIOUS_HISTORY, Operation.QUOTED_INSERT, Operation.REVERSE_SEARCH_HISTORY, Operation.FORWARD_SEARCH_HISTORY, Operation.TRANSPOSE_CHARS, Operation.UNIX_LINE_DISCARD, Operation.QUOTED_INSERT, Operation.UNIX_WORD_RUBOUT, KeyMap.emacsCtrlX(), Operation.YANK, null, KeyMap.emacsMeta(), null, Operation.CHARACTER_SEARCH, null, Operation.UNDO};
        System.arraycopy(objectArray2, 0, objectArray, 0, objectArray2.length);
        for (int i = 32; i < 256; ++i) {
            objectArray[i] = Operation.SELF_INSERT;
        }
        objectArray[127] = Operation.BACKWARD_DELETE_CHAR;
        return new KeyMap(EMACS, objectArray);
    }

    public static KeyMap emacsCtrlX() {
        Object[] objectArray = new Object[256];
        objectArray[7] = Operation.ABORT;
        objectArray[18] = Operation.RE_READ_INIT_FILE;
        objectArray[21] = Operation.UNDO;
        objectArray[24] = Operation.EXCHANGE_POINT_AND_MARK;
        objectArray[40] = Operation.START_KBD_MACRO;
        objectArray[41] = Operation.END_KBD_MACRO;
        for (int i = 65; i <= 90; ++i) {
            objectArray[i] = Operation.DO_LOWERCASE_VERSION;
        }
        objectArray[101] = Operation.CALL_LAST_KBD_MACRO;
        objectArray[127] = Operation.KILL_LINE;
        return new KeyMap(EMACS_CTLX, objectArray);
    }

    public static KeyMap emacsMeta() {
        Object[] objectArray = new Object[256];
        objectArray[7] = Operation.ABORT;
        objectArray[8] = Operation.BACKWARD_KILL_WORD;
        objectArray[9] = Operation.TAB_INSERT;
        objectArray[10] = Operation.VI_EDITING_MODE;
        objectArray[13] = Operation.VI_EDITING_MODE;
        objectArray[18] = Operation.REVERT_LINE;
        objectArray[25] = Operation.YANK_NTH_ARG;
        objectArray[27] = Operation.COMPLETE;
        objectArray[29] = Operation.CHARACTER_SEARCH_BACKWARD;
        objectArray[32] = Operation.SET_MARK;
        objectArray[35] = Operation.INSERT_COMMENT;
        objectArray[38] = Operation.TILDE_EXPAND;
        objectArray[42] = Operation.INSERT_COMPLETIONS;
        objectArray[45] = Operation.DIGIT_ARGUMENT;
        objectArray[46] = Operation.YANK_LAST_ARG;
        objectArray[60] = Operation.BEGINNING_OF_HISTORY;
        objectArray[61] = Operation.POSSIBLE_COMPLETIONS;
        objectArray[62] = Operation.END_OF_HISTORY;
        objectArray[63] = Operation.POSSIBLE_COMPLETIONS;
        for (int i = 65; i <= 90; ++i) {
            objectArray[i] = Operation.DO_LOWERCASE_VERSION;
        }
        objectArray[92] = Operation.DELETE_HORIZONTAL_SPACE;
        objectArray[95] = Operation.YANK_LAST_ARG;
        objectArray[98] = Operation.BACKWARD_WORD;
        objectArray[99] = Operation.CAPITALIZE_WORD;
        objectArray[100] = Operation.KILL_WORD;
        objectArray[102] = Operation.FORWARD_WORD;
        objectArray[108] = Operation.DOWNCASE_WORD;
        objectArray[112] = Operation.NON_INCREMENTAL_REVERSE_SEARCH_HISTORY;
        objectArray[114] = Operation.REVERT_LINE;
        objectArray[116] = Operation.TRANSPOSE_WORDS;
        objectArray[117] = Operation.UPCASE_WORD;
        objectArray[121] = Operation.YANK_POP;
        objectArray[126] = Operation.TILDE_EXPAND;
        objectArray[127] = Operation.BACKWARD_KILL_WORD;
        return new KeyMap(EMACS_META, objectArray);
    }

    public static KeyMap viInsertion() {
        Object[] objectArray = new Object[256];
        Object[] objectArray2 = new Object[]{null, Operation.SELF_INSERT, Operation.SELF_INSERT, Operation.SELF_INSERT, Operation.VI_EOF_MAYBE, Operation.SELF_INSERT, Operation.SELF_INSERT, Operation.SELF_INSERT, Operation.BACKWARD_DELETE_CHAR, Operation.COMPLETE, Operation.ACCEPT_LINE, Operation.SELF_INSERT, Operation.SELF_INSERT, Operation.ACCEPT_LINE, Operation.MENU_COMPLETE, Operation.SELF_INSERT, Operation.MENU_COMPLETE_BACKWARD, Operation.SELF_INSERT, Operation.REVERSE_SEARCH_HISTORY, Operation.FORWARD_SEARCH_HISTORY, Operation.TRANSPOSE_CHARS, Operation.UNIX_LINE_DISCARD, Operation.QUOTED_INSERT, Operation.UNIX_WORD_RUBOUT, Operation.SELF_INSERT, Operation.YANK, Operation.SELF_INSERT, Operation.VI_MOVEMENT_MODE, Operation.SELF_INSERT, Operation.SELF_INSERT, Operation.SELF_INSERT, Operation.UNDO};
        System.arraycopy(objectArray2, 0, objectArray, 0, objectArray2.length);
        for (int i = 32; i < 256; ++i) {
            objectArray[i] = Operation.SELF_INSERT;
        }
        objectArray[127] = Operation.BACKWARD_DELETE_CHAR;
        return new KeyMap(VI_INSERT, objectArray);
    }

    public static KeyMap viMovement() {
        Object[] objectArray = new Object[256];
        Object[] objectArray2 = new Object[]{null, null, null, Operation.INTERRUPT, Operation.VI_EOF_MAYBE, Operation.EMACS_EDITING_MODE, null, Operation.ABORT, Operation.BACKWARD_CHAR, null, Operation.VI_MOVE_ACCEPT_LINE, Operation.KILL_LINE, Operation.CLEAR_SCREEN, Operation.VI_MOVE_ACCEPT_LINE, Operation.VI_NEXT_HISTORY, null, Operation.VI_PREVIOUS_HISTORY, Operation.QUOTED_INSERT, Operation.REVERSE_SEARCH_HISTORY, Operation.FORWARD_SEARCH_HISTORY, Operation.TRANSPOSE_CHARS, Operation.UNIX_LINE_DISCARD, Operation.QUOTED_INSERT, Operation.UNIX_WORD_RUBOUT, null, Operation.YANK, null, KeyMap.emacsMeta(), null, Operation.CHARACTER_SEARCH, null, Operation.UNDO, Operation.FORWARD_CHAR, null, null, Operation.VI_INSERT_COMMENT, Operation.END_OF_LINE, Operation.VI_MATCH, Operation.VI_TILDE_EXPAND, null, null, null, Operation.VI_COMPLETE, Operation.VI_NEXT_HISTORY, Operation.VI_CHAR_SEARCH, Operation.VI_PREVIOUS_HISTORY, Operation.VI_REDO, Operation.VI_SEARCH, Operation.VI_BEGINNING_OF_LINE_OR_ARG_DIGIT, Operation.VI_ARG_DIGIT, Operation.VI_ARG_DIGIT, Operation.VI_ARG_DIGIT, Operation.VI_ARG_DIGIT, Operation.VI_ARG_DIGIT, Operation.VI_ARG_DIGIT, Operation.VI_ARG_DIGIT, Operation.VI_ARG_DIGIT, Operation.VI_ARG_DIGIT, null, Operation.VI_CHAR_SEARCH, null, Operation.VI_COMPLETE, null, Operation.VI_SEARCH, null, Operation.VI_APPEND_EOL, Operation.VI_PREV_WORD, Operation.VI_CHANGE_TO_EOL, Operation.VI_DELETE_TO_EOL, Operation.VI_END_WORD, Operation.VI_CHAR_SEARCH, Operation.VI_FETCH_HISTORY, null, Operation.VI_INSERT_BEG, null, null, null, null, Operation.VI_SEARCH_AGAIN, null, Operation.VI_PUT, null, Operation.VI_REPLACE, Operation.VI_KILL_WHOLE_LINE, Operation.VI_CHAR_SEARCH, Operation.REVERT_LINE, null, Operation.VI_NEXT_WORD, Operation.VI_RUBOUT, Operation.VI_YANK_TO, null, null, Operation.VI_COMPLETE, null, Operation.VI_FIRST_PRINT, Operation.VI_YANK_ARG, Operation.VI_GOTO_MARK, Operation.VI_APPEND_MODE, Operation.VI_PREV_WORD, Operation.VI_CHANGE_TO, Operation.VI_DELETE_TO, Operation.VI_END_WORD, Operation.VI_CHAR_SEARCH, null, Operation.BACKWARD_CHAR, Operation.VI_INSERTION_MODE, Operation.NEXT_HISTORY, Operation.PREVIOUS_HISTORY, Operation.FORWARD_CHAR, Operation.VI_SET_MARK, Operation.VI_SEARCH_AGAIN, null, Operation.VI_PUT, null, Operation.VI_CHANGE_CHAR, Operation.VI_SUBST, Operation.VI_CHAR_SEARCH, Operation.UNDO, null, Operation.VI_NEXT_WORD, Operation.VI_DELETE, Operation.VI_YANK_TO, null, null, Operation.VI_COLUMN, null, Operation.VI_CHANGE_CASE, Operation.VI_DELETE};
        System.arraycopy(objectArray2, 0, objectArray, 0, objectArray2.length);
        for (int i = 128; i < 256; ++i) {
            objectArray[i] = null;
        }
        return new KeyMap(VI_MOVE, objectArray);
    }
}

