/*
 * Decompiled with CFR 0.152.
 */
package jline.console;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import jline.console.KeyMap;
import jline.console.Operation;
import jline.internal.Log;

public class ConsoleKeys {
    private KeyMap keys;
    private Map<String, KeyMap> keyMaps;
    private Map<String, String> variables = new HashMap<String, String>();

    public ConsoleKeys(String string, URL uRL) {
        this.keyMaps = KeyMap.keyMaps();
        this.setVar("editing-mode", "emacs");
        this.loadKeys(string, uRL);
        String string2 = this.variables.get("editing-mode");
        if ("vi".equalsIgnoreCase(string2)) {
            this.keys = this.keyMaps.get("vi-insert");
        } else if ("emacs".equalsIgnoreCase(string2)) {
            this.keys = this.keyMaps.get("emacs");
        }
    }

    protected boolean setKeyMap(String string) {
        KeyMap keyMap = this.keyMaps.get(string);
        if (keyMap == null) {
            return false;
        }
        this.keys = keyMap;
        return true;
    }

    protected Map<String, KeyMap> getKeyMaps() {
        return this.keyMaps;
    }

    protected KeyMap getKeys() {
        return this.keys;
    }

    protected void setKeys(KeyMap keyMap) {
        this.keys = keyMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadKeys(String string, URL uRL) {
        this.keys = this.keyMaps.get("emacs");
        try {
            InputStream inputStream = uRL.openStream();
            try {
                this.loadKeys(inputStream, string);
                Log.debug("Loaded user configuration: ", uRL);
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        catch (IOException iOException) {
            if (uRL.getProtocol().equals("file")) {
                File file = new File(uRL.getPath());
                if (file.exists()) {
                    Log.warn("Unable to read user configuration: ", uRL, iOException);
                }
            }
            Log.warn("Unable to read user configuration: ", uRL, iOException);
        }
    }

    private void loadKeys(InputStream inputStream, String string) throws IOException {
        String string2;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        boolean bl = true;
        ArrayList<Boolean> arrayList = new ArrayList<Boolean>();
        while ((string2 = bufferedReader.readLine()) != null) {
            try {
                char c;
                String string3;
                String string4;
                if ((string2 = string2.trim()).length() == 0 || string2.charAt(0) == '#') continue;
                int n = 0;
                if (string2.charAt(n) == '$') {
                    ++n;
                    while (n < string2.length() && (string2.charAt(n) == ' ' || string2.charAt(n) == '\t')) {
                        ++n;
                    }
                    int n2 = n;
                    while (n < string2.length() && string2.charAt(n) != ' ' && string2.charAt(n) != '\t') {
                        ++n;
                    }
                    String string5 = string2.substring(n2, n);
                    while (n < string2.length() && (string2.charAt(n) == ' ' || string2.charAt(n) == '\t')) {
                        ++n;
                    }
                    n2 = n;
                    while (n < string2.length() && string2.charAt(n) != ' ' && string2.charAt(n) != '\t') {
                        ++n;
                    }
                    string4 = string2.substring(n2, n);
                    if ("if".equalsIgnoreCase(string5)) {
                        arrayList.add(bl);
                        if (!bl || string4.startsWith("term=")) continue;
                        if (string4.startsWith("mode=")) {
                            string3 = this.variables.get("editing-mode");
                            bl = string4.substring("mode=".length()).equalsIgnoreCase(string3);
                            continue;
                        }
                        bl = string4.equalsIgnoreCase(string);
                        continue;
                    }
                    if ("else".equalsIgnoreCase(string5)) {
                        if (arrayList.isEmpty()) {
                            throw new IllegalArgumentException("$else found without matching $if");
                        }
                        boolean bl2 = true;
                        Iterator iterator = arrayList.iterator();
                        while (iterator.hasNext()) {
                            c = ((Boolean)iterator.next()).booleanValue();
                            if (c != '\u0000') continue;
                            bl2 = false;
                            break;
                        }
                        if (!bl2) continue;
                        bl = !bl;
                        continue;
                    }
                    if ("endif".equalsIgnoreCase(string5)) {
                        if (arrayList.isEmpty()) {
                            throw new IllegalArgumentException("endif found without matching $if");
                        }
                        bl = (Boolean)arrayList.remove(arrayList.size() - 1);
                        continue;
                    }
                    if (!"include".equalsIgnoreCase(string5)) continue;
                }
                if (!bl) continue;
                string4 = "";
                if (string2.charAt(n++) == '\"') {
                    boolean bl3 = false;
                    while (true) {
                        if (n >= string2.length()) {
                            throw new IllegalArgumentException("Missing closing quote on line '" + string2 + "'");
                        }
                        if (bl3) {
                            bl3 = false;
                        } else if (string2.charAt(n) == '\\') {
                            bl3 = true;
                        } else if (string2.charAt(n) == '\"') break;
                        ++n;
                    }
                }
                while (n < string2.length() && string2.charAt(n) != ':' && string2.charAt(n) != ' ' && string2.charAt(n) != '\t') {
                    ++n;
                }
                string4 = string2.substring(0, n);
                boolean bl4 = n + 1 < string2.length() && string2.charAt(n) == ':' && string2.charAt(n + 1) == '=';
                ++n;
                if (bl4) {
                    ++n;
                }
                if (string4.equalsIgnoreCase("set")) {
                    while (n < string2.length() && (string2.charAt(n) == ' ' || string2.charAt(n) == '\t')) {
                        ++n;
                    }
                    int n3 = n;
                    while (n < string2.length() && string2.charAt(n) != ' ' && string2.charAt(n) != '\t') {
                        ++n;
                    }
                    String string6 = string2.substring(n3, n);
                    while (n < string2.length() && (string2.charAt(n) == ' ' || string2.charAt(n) == '\t')) {
                        ++n;
                    }
                    n3 = n;
                    while (n < string2.length() && string2.charAt(n) != ' ' && string2.charAt(n) != '\t') {
                        ++n;
                    }
                    string3 = string2.substring(n3, n);
                    this.setVar(string6, string3);
                    continue;
                }
                while (n < string2.length() && (string2.charAt(n) == ' ' || string2.charAt(n) == '\t')) {
                    ++n;
                }
                int n4 = n;
                if (n < string2.length() && (string2.charAt(n) == '\'' || string2.charAt(n) == '\"')) {
                    char c2 = string2.charAt(n++);
                    boolean bl5 = false;
                    while (n < string2.length()) {
                        if (bl5) {
                            bl5 = false;
                        } else if (string2.charAt(n) == '\\') {
                            bl5 = true;
                        } else if (string2.charAt(n) == c2) break;
                        ++n;
                    }
                }
                while (n < string2.length() && string2.charAt(n) != ' ' && string2.charAt(n) != '\t') {
                    ++n;
                }
                string3 = string2.substring(Math.min(n4, string2.length()), Math.min(n, string2.length()));
                if (string4.charAt(0) == '\"') {
                    string4 = ConsoleKeys.translateQuoted(string4);
                } else {
                    String string7 = string4.lastIndexOf(45) > 0 ? string4.substring(string4.lastIndexOf(45) + 1) : string4;
                    c = ConsoleKeys.getKeyFromName(string7);
                    string7 = string4.toLowerCase();
                    string4 = "";
                    if (string7.contains("meta-") || string7.contains("m-")) {
                        string4 = string4 + "\u001b";
                    }
                    if (string7.contains("control-") || string7.contains("c-") || string7.contains("ctrl-")) {
                        c = (char)(Character.toUpperCase(c) & 0x1F);
                    }
                    string4 = string4 + c;
                }
                if (string3.length() > 0 && (string3.charAt(0) == '\'' || string3.charAt(0) == '\"')) {
                    this.keys.bind(string4, ConsoleKeys.translateQuoted(string3));
                    continue;
                }
                String string8 = string3.replace('-', '_').toUpperCase();
                try {
                    this.keys.bind(string4, (Object)Operation.valueOf(string8));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Log.info("Unable to bind key for unsupported operation: ", string3);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Log.warn("Unable to parse user configuration: ", illegalArgumentException);
            }
        }
    }

    private static String translateQuoted(String string) {
        String string2 = string.substring(1, string.length() - 1);
        string = "";
        for (int i = 0; i < string2.length(); ++i) {
            char c = string2.charAt(i);
            if (c == '\\') {
                boolean bl;
                boolean bl2 = string2.regionMatches(i, "\\C-", 0, 3) || string2.regionMatches(i, "\\M-\\C-", 0, 6);
                if ((i += ((bl = string2.regionMatches(i, "\\M-", 0, 3) || string2.regionMatches(i, "\\C-\\M-", 0, 6)) ? 3 : 0) + (bl2 ? 3 : 0) + (!bl && !bl2 ? 1 : 0)) >= string2.length()) break;
                c = string2.charAt(i);
                if (bl) {
                    string = string + "\u001b";
                }
                if (bl2) {
                    char c2 = c = c == '?' ? (char)'\u007f' : (char)(Character.toUpperCase(c) & 0x1F);
                }
                if (!bl && !bl2) {
                    switch (c) {
                        case 'a': {
                            c = '\u0007';
                            break;
                        }
                        case 'b': {
                            c = '\b';
                            break;
                        }
                        case 'd': {
                            c = '\u007f';
                            break;
                        }
                        case 'e': {
                            c = '\u001b';
                            break;
                        }
                        case 'f': {
                            c = '\f';
                            break;
                        }
                        case 'n': {
                            c = '\n';
                            break;
                        }
                        case 'r': {
                            c = '\r';
                            break;
                        }
                        case 't': {
                            c = '\t';
                            break;
                        }
                        case 'v': {
                            c = '\u000b';
                            break;
                        }
                        case '\\': {
                            c = '\\';
                            break;
                        }
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': {
                            int n;
                            int n2;
                            c = '\u0000';
                            for (n2 = 0; n2 < 3 && i < string2.length() && (n = Character.digit(string2.charAt(i), 8)) >= 0; ++n2, ++i) {
                                c = (char)(c * 8 + n);
                            }
                            c = (char)(c & 0xFF);
                            break;
                        }
                        case 'x': {
                            int n;
                            int n2;
                            ++i;
                            c = '\u0000';
                            for (n2 = 0; n2 < 2 && i < string2.length() && (n = Character.digit(string2.charAt(i), 16)) >= 0; ++n2, ++i) {
                                c = (char)(c * 16 + n);
                            }
                            c = (char)(c & 0xFF);
                            break;
                        }
                        case 'u': {
                            int n;
                            int n2;
                            ++i;
                            c = '\u0000';
                            for (n2 = 0; n2 < 4 && i < string2.length() && (n = Character.digit(string2.charAt(i), 16)) >= 0; ++n2, ++i) {
                                c = (char)(c * 16 + n);
                            }
                            break;
                        }
                    }
                }
                string = string + c;
                continue;
            }
            string = string + c;
        }
        return string;
    }

    private static char getKeyFromName(String string) {
        if ("DEL".equalsIgnoreCase(string) || "Rubout".equalsIgnoreCase(string)) {
            return '\u007f';
        }
        if ("ESC".equalsIgnoreCase(string) || "Escape".equalsIgnoreCase(string)) {
            return '\u001b';
        }
        if ("LFD".equalsIgnoreCase(string) || "NewLine".equalsIgnoreCase(string)) {
            return '\n';
        }
        if ("RET".equalsIgnoreCase(string) || "Return".equalsIgnoreCase(string)) {
            return '\r';
        }
        if ("SPC".equalsIgnoreCase(string) || "Space".equalsIgnoreCase(string)) {
            return ' ';
        }
        if ("Tab".equalsIgnoreCase(string)) {
            return '\t';
        }
        return string.charAt(0);
    }

    private void setVar(String string, String string2) {
        if ("keymap".equalsIgnoreCase(string)) {
            if (this.keyMaps.containsKey(string2)) {
                this.keys = this.keyMaps.get(string2);
            }
        } else if ("blink-matching-paren".equals(string)) {
            if ("on".equalsIgnoreCase(string2)) {
                this.keys.setBlinkMatchingParen(true);
            } else if ("off".equalsIgnoreCase(string2)) {
                this.keys.setBlinkMatchingParen(false);
            }
        }
        this.variables.put(string, string2);
    }

    public String getVariable(String string) {
        return this.variables.get(string);
    }
}

