/*
 * Decompiled with CFR 0.152.
 */
package bloop;

import bloop.DependencyResolution;
import bloop.io.AbsolutePath;
import bloop.io.AbsolutePath$;
import bloop.logging.DebugFilter;
import bloop.logging.Logger;
import coursierapi.Dependency;
import coursierapi.Fetch;
import coursierapi.Repository;
import coursierapi.error.CoursierError;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class DependencyResolution$ {
    public static DependencyResolution$ MODULE$;

    static {
        new DependencyResolution$();
    }

    public Path[] resolve(List<DependencyResolution.Artifact> artifacts, Logger logger, boolean resolveSources, Seq<Repository> additionalRepos) {
        AbsolutePath[] paths;
        Either<CoursierError, Path[]> either = this.resolveWithErrors(artifacts, logger, resolveSources, additionalRepos);
        if (!(either instanceof Right)) {
            if (either instanceof Left) {
                Left left = (Left)either;
                CoursierError error = (CoursierError)left.value();
                throw error;
            }
            throw new MatchError(either);
        }
        Right right = (Right)either;
        AbsolutePath[] absolutePathArray = paths = (AbsolutePath[])right.value();
        return absolutePathArray;
    }

    public boolean resolve$default$3() {
        return false;
    }

    public Seq<Repository> resolve$default$4() {
        return Nil$.MODULE$;
    }

    public Either<CoursierError, Path[]> resolveWithErrors(List<DependencyResolution.Artifact> artifacts, Logger logger, boolean resolveSources, Seq<Repository> additionalRepositories) {
        List dependencies = (List)artifacts.map((Function1 & Serializable & scala.Serializable)artifact -> {
            void var3_3;
            logger.debug(new StringBuilder(12).append("Resolving ").append(artifact.organization()).append(":").append(artifact.module()).append(":").append(artifact.version()).toString(), (DebugFilter)DebugFilter.All$.MODULE$);
            Dependency baseDep = Dependency.of((String)artifact.organization(), (String)artifact.module(), (String)artifact.version());
            return resolveSources ? baseDep.withClassifier("sources") : var3_3;
        }, List$.MODULE$.canBuildFrom());
        return this.resolveDependenciesWithErrors((Seq<Dependency>)dependencies, resolveSources, additionalRepositories);
    }

    public boolean resolveWithErrors$default$3() {
        return false;
    }

    public Seq<Repository> resolveWithErrors$default$4() {
        return Nil$.MODULE$;
    }

    public Either<CoursierError, Path[]> resolveDependenciesWithErrors(Seq<Dependency> dependencies, boolean resolveSources, Seq<Repository> additionalRepositories) {
        Left left;
        Fetch fetch = Fetch.create().withDependencies((Dependency[])dependencies.toArray(ClassTag$.MODULE$.apply(Dependency.class)));
        Object object = resolveSources ? fetch.addArtifactTypes(new String[]{"src", "jar"}) : BoxedUnit.UNIT;
        fetch.addRepositories((Repository[])additionalRepositories.toArray(ClassTag$.MODULE$.apply(Repository.class)));
        try {
            left = package$.MODULE$.Right().apply(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(fetch.fetch()).asScala()).toArray(ClassTag$.MODULE$.apply(File.class)))).map((Function1 & Serializable & scala.Serializable)f -> new AbsolutePath(AbsolutePath$.MODULE$.apply(f.toPath(), AbsolutePath$.MODULE$.workingDirectory())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(AbsolutePath.class))));
        }
        catch (CoursierError error) {
            left = package$.MODULE$.Left().apply((Object)error);
        }
        return left;
    }

    public boolean resolveDependenciesWithErrors$default$2() {
        return false;
    }

    public Seq<Repository> resolveDependenciesWithErrors$default$3() {
        return Nil$.MODULE$;
    }

    public String majorMinorVersion(String version) {
        return (String)new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString(version)).reverse())).dropWhile((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DependencyResolution$.$anonfun$majorMinorVersion$1(BoxesRunTime.unboxToChar((Object)x$1)))))).tail())).reverse();
    }

    public static final /* synthetic */ boolean $anonfun$majorMinorVersion$1(char x$1) {
        return x$1 != '.';
    }

    private DependencyResolution$() {
        MODULE$ = this;
    }
}

