/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.scala.debugadapter.internal.evaluator;

import ch.epfl.scala.debugadapter.internal.evaluator.NameTransformer;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.StringOps$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class NameTransformer$ {
    public static NameTransformer$ MODULE$;
    private final int nops;
    private final int ncodes;
    private final String[] op2code;
    private final NameTransformer.OpCodes[] code2op;

    static {
        new NameTransformer$();
    }

    private int nops() {
        return this.nops;
    }

    private int ncodes() {
        return this.ncodes;
    }

    private String[] op2code() {
        return this.op2code;
    }

    private NameTransformer.OpCodes[] code2op() {
        return this.code2op;
    }

    private void enterOp(char op, String code) {
        this.op2code()[op] = code;
        int c = (code.charAt(1) - 97) * 26 + code.charAt(2) - 97;
        this.code2op()[c] = new NameTransformer.OpCodes(op, code, this.code2op()[c]);
    }

    public String encode(String name) {
        StringBuilder buf = null;
        int len = name.length();
        for (int i = 0; i < len; ++i) {
            Object object;
            char c = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(name), i);
            if (c < this.nops() && this.op2code()[c] != null) {
                BoxedUnit boxedUnit;
                if (buf == null) {
                    buf = new StringBuilder();
                    boxedUnit = buf.append(StringOps$.MODULE$.slice$extension(Predef$.MODULE$.augmentString(name), 0, i));
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                object = buf.append(this.op2code()[c]);
                continue;
            }
            if (!Character.isJavaIdentifierPart(c)) {
                BoxedUnit boxedUnit;
                if (buf == null) {
                    buf = new StringBuilder();
                    boxedUnit = buf.append(StringOps$.MODULE$.slice$extension(Predef$.MODULE$.augmentString(name), 0, i));
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                object = buf.append(new StringOps(Predef$.MODULE$.augmentString("$u%04X")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)c)})));
                continue;
            }
            object = buf != null ? buf.append(c) : BoxedUnit.UNIT;
        }
        if (buf == null) {
            return name;
        }
        return buf.toString();
    }

    public String decode(String name) {
        StringBuilder buf = null;
        int len = name.length();
        int i = 0;
        while (i < len) {
            char ch1;
            NameTransformer.OpCodes ops = null;
            boolean unicode = false;
            char c = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(name), i);
            if (c == '$' && i + 2 < len && 'a' <= (ch1 = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(name), i + 1)) && ch1 <= 'z') {
                char ch2 = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(name), i + 2);
                if ('a' <= ch2 && ch2 <= 'z') {
                    for (ops = this.code2op()[(ch1 - 97) * 26 + ch2 - 97]; ops != null && !name.startsWith(ops.code(), i); ops = ops.next()) {
                    }
                    if (ops != null) {
                        BoxedUnit boxedUnit;
                        if (buf == null) {
                            buf = new StringBuilder();
                            boxedUnit = buf.append(StringOps$.MODULE$.slice$extension(Predef$.MODULE$.augmentString(name), 0, i));
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        buf.append(ops.op());
                        i += ops.code().length();
                    }
                } else if (len - i >= 6 && ch1 == 'u' && (Character.isDigit(ch2) || 'A' <= ch2 && ch2 <= 'F')) {
                    String hex = StringOps$.MODULE$.slice$extension(Predef$.MODULE$.augmentString(name), i + 2, i + 6);
                    try {
                        BoxedUnit boxedUnit;
                        char str = (char)Integer.parseInt(hex, 16);
                        if (buf == null) {
                            buf = new StringBuilder();
                            boxedUnit = buf.append(StringOps$.MODULE$.slice$extension(Predef$.MODULE$.augmentString(name), 0, i));
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        buf.append(str);
                        i += 6;
                        unicode = true;
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            }
            if (ops != null || unicode) continue;
            Object object = buf != null ? buf.append(c) : BoxedUnit.UNIT;
            ++i;
        }
        if (buf == null) {
            return name;
        }
        return buf.toString();
    }

    private NameTransformer$() {
        MODULE$ = this;
        this.nops = 128;
        this.ncodes = 676;
        this.op2code = new String[this.nops()];
        this.code2op = new NameTransformer.OpCodes[this.ncodes()];
        this.enterOp('~', "$tilde");
        this.enterOp('=', "$eq");
        this.enterOp('<', "$less");
        this.enterOp('>', "$greater");
        this.enterOp('!', "$bang");
        this.enterOp('#', "$hash");
        this.enterOp('%', "$percent");
        this.enterOp('^', "$up");
        this.enterOp('&', "$amp");
        this.enterOp('|', "$bar");
        this.enterOp('*', "$times");
        this.enterOp('/', "$div");
        this.enterOp('+', "$plus");
        this.enterOp('-', "$minus");
        this.enterOp(':', "$colon");
        this.enterOp('\\', "$bslash");
        this.enterOp('?', "$qmark");
        this.enterOp('@', "$at");
    }
}

