/*
 * Decompiled with CFR 0.152.
 */
package jsonrpc4s;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import jsonrpc4s.LowLevelMessage;
import jsonrpc4s.LowLevelMessageReader$;
import monix.execution.Ack;
import monix.reactive.observers.Subscriber;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.SeqLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.Future;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scribe.Loggable;
import scribe.LoggerSupport;
import sourcecode.FileName;
import sourcecode.Line;
import sourcecode.Name;
import sourcecode.Pkg;

@ScalaSignature(bytes="\u0006\u0001\tMa\u0001B\u0014)\u0005-B\u0001B\r\u0001\u0003\u0002\u0003\u0006Ia\r\u0005\u0006s\u0001!\tA\u000f\u0005\u0007}\u0001\u0001\u000b\u0011B \t\r)\u0003\u0001\u0015)\u0003L\u0011\u0015q\u0005\u0001\"\u0001P\u0011\u0019\u0001\u0006\u0001)Q\u0005#\"11\r\u0001Q\u0005\n\u0011DQ!\u001e\u0001\u0005\u0002YDqA!\u0004\u0001\t\u0003\u0011yaB\u0003zQ!\u0005!PB\u0003(Q!\u00051\u0010C\u0003:\u0017\u0011\u0005A\u0010C\u0003~\u0017\u0011\u0005a\u0010C\u0004\u0002\u001e-!\t!a\b\u0007\u000f\u0005\u00053\u0002Q\u0006\u0002D!Q\u0011\u0011K\b\u0003\u0016\u0004%\t!a\u0015\t\u0013\u0005UsB!E!\u0002\u0013y\bBCA,\u001f\tU\r\u0011\"\u0001\u0002Z!Q\u00111O\b\u0003\u0012\u0003\u0006I!a\u0017\t\rezA\u0011AA;\u0011%\tyhDA\u0001\n\u0003\t\t\tC\u0005\u0002\b>\t\n\u0011\"\u0001\u0002\n\"I\u0011qT\b\u0012\u0002\u0013\u0005\u0011\u0011\u0015\u0005\n\u0003K{\u0011\u0011!C!\u0003OC\u0001\"!+\u0010\u0003\u0003%\ta\u0014\u0005\n\u0003W{\u0011\u0011!C\u0001\u0003[C\u0011\"!/\u0010\u0003\u0003%\t%a/\t\u0013\u0005\u0015w\"!A\u0005\u0002\u0005\u001d\u0007\"CAf\u001f\u0005\u0005I\u0011IAg\u0011%\tymDA\u0001\n\u0003\n\t\u000eC\u0005\u0002T>\t\t\u0011\"\u0011\u0002V\u001eQ\u0011\u0011\\\u0006\u0002\u0002#\u00051\"a7\u0007\u0015\u0005\u00053\"!A\t\u0002-\ti\u000e\u0003\u0004:C\u0011\u0005\u00111\u001e\u0005\n\u0003\u001f\f\u0013\u0011!C#\u0003#D\u0011\"!<\"\u0003\u0003%\t)a<\t\u0013\u0005U\u0018%!A\u0005\u0002\u0006]\b\"\u0003B\u0001C\u0005\u0005I\u0011\u0002B\u0002\u0005Uaun\u001e'fm\u0016dW*Z:tC\u001e,'+Z1eKJT\u0011!K\u0001\nUN|gN\u001d9diM\u001c\u0001a\u0005\u0002\u0001YA\u0011Q\u0006M\u0007\u0002])\tq&A\u0003tG\u0006d\u0017-\u0003\u00022]\t1\u0011I\\=SK\u001a\fa\u0001\\8hO\u0016\u0014\bC\u0001\u001b8\u001b\u0005)$\"\u0001\u001c\u0002\rM\u001c'/\u001b2f\u0013\tATGA\u0007M_\u001e<WM]*vaB|'\u000f^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005mj\u0004C\u0001\u001f\u0001\u001b\u0005A\u0003\"\u0002\u001a\u0003\u0001\u0004\u0019\u0014!C#naRL\b+Y5s!\u0011i\u0003I\u0011\"\n\u0005\u0005s#A\u0002+va2,'\u0007\u0005\u0002D\u00116\tAI\u0003\u0002F\r\u0006!A.\u00198h\u0015\u00059\u0015\u0001\u00026bm\u0006L!!\u0013#\u0003\rM#(/\u001b8h\u00035\u0019wN\u001c;f]RdUM\\4uQB\u0011Q\u0006T\u0005\u0003\u001b:\u00121!\u00138u\u0003Q\u0019WO\u001d:f]R\u001cuN\u001c;f]RdUM\\4uQV\t1*\u0001\u0004iK\u0006$WM\u001d\t\u0005%^K\u0016,D\u0001T\u0015\t!V+A\u0005j[6,H/\u00192mK*\u0011aKL\u0001\u000bG>dG.Z2uS>t\u0017B\u0001-T\u0005\ri\u0015\r\u001d\t\u00035\u0006t!aW0\u0011\u0005qsS\"A/\u000b\u0005yS\u0013A\u0002\u001fs_>$h(\u0003\u0002a]\u00051\u0001K]3eK\u001aL!!\u00132\u000b\u0005\u0001t\u0013aC1u\t\u0016d\u0017.\\5uKJ$2!\u001a5k!\tic-\u0003\u0002h]\t9!i\\8mK\u0006t\u0007\"B5\b\u0001\u0004Y\u0015aA5eq\")1n\u0002a\u0001Y\u0006!A-\u0019;b!\ri\u0007O]\u0007\u0002]*\u0011q.V\u0001\b[V$\u0018M\u00197f\u0013\t\thNA\u0006BeJ\f\u0017PQ;gM\u0016\u0014\bCA\u0017t\u0013\t!hF\u0001\u0003CsR,\u0017a\u0003:fC\u0012DU-\u00193feN$2a\u001eB\u0006!\tAxB\u0004\u0002=\u0015\u0005)Bj\\<MKZ,G.T3tg\u0006<WMU3bI\u0016\u0014\bC\u0001\u001f\f'\tYA\u0006F\u0001{\u0003\u0011\u0011X-\u00193\u0015\u000b}\fY!a\u0007\u0011\u000b5\n\t!!\u0002\n\u0007\u0005\raF\u0001\u0004PaRLwN\u001c\t\u0004y\u0005\u001d\u0011bAA\u0005Q\tyAj\\<MKZ,G.T3tg\u0006<W\rC\u0004\u0002\u000e5\u0001\r!a\u0004\u0002\u0007\t,h\r\u0005\u0003\u0002\u0012\u0005]QBAA\n\u0015\r\t)BR\u0001\u0004]&|\u0017\u0002BA\r\u0003'\u0011!BQ=uK\n+hMZ3s\u0011\u0015\u0011T\u00021\u00014\u00031\u0019HO]3b[J+\u0017\rZ3s)\u0011\t\t#a\u0010\u0011\u0011\u0005\r\u0012\u0011HA\b\u0003\u000bqA!!\n\u000249!\u0011qEA\u0017\u001d\ra\u0016\u0011F\u0005\u0003\u0003W\tQ!\\8oSbLA!a\f\u00022\u0005A!/Z1di&4XM\u0003\u0002\u0002,%!\u0011QGA\u001c\u0003)y%m]3sm\u0006\u0014G.\u001a\u0006\u0005\u0003_\t\t$\u0003\u0003\u0002<\u0005u\"\u0001C(qKJ\fGo\u001c:\u000b\t\u0005U\u0012q\u0007\u0005\u0006e9\u0001\ra\r\u0002\u000b%\u0016\fGMU3tk2$8CB\b-\u0003\u000b\nY\u0005E\u0002.\u0003\u000fJ1!!\u0013/\u0005\u001d\u0001&o\u001c3vGR\u00042!LA'\u0013\r\tyE\f\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0004[N<W#A@\u0002\t5\u001cx\rI\u0001\u0004C\u000e\\WCAA.!\u0019\ti&a\u0019\u0002h5\u0011\u0011q\f\u0006\u0004\u0003Cr\u0013AC2p]\u000e,(O]3oi&!\u0011QMA0\u0005\u00191U\u000f^;sKB!\u0011\u0011NA8\u001b\t\tYG\u0003\u0003\u0002n\u0005E\u0012!C3yK\u000e,H/[8o\u0013\u0011\t\t(a\u001b\u0003\u0007\u0005\u001b7.\u0001\u0003bG.\u0004CCBA<\u0003w\ni\bE\u0002\u0002z=i\u0011a\u0003\u0005\u0007\u0003#\"\u0002\u0019A@\t\u000f\u0005]C\u00031\u0001\u0002\\\u0005!1m\u001c9z)\u0019\t9(a!\u0002\u0006\"A\u0011\u0011K\u000b\u0011\u0002\u0003\u0007q\u0010C\u0005\u0002XU\u0001\n\u00111\u0001\u0002\\\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAAFU\ry\u0018QR\u0016\u0003\u0003\u001f\u0003B!!%\u0002\u001c6\u0011\u00111\u0013\u0006\u0005\u0003+\u000b9*A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011\u0014\u0018\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u001e\u0006M%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TCAARU\u0011\tY&!$\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\u0005\u0011\u0015\u0001\u00049s_\u0012,8\r^!sSRL\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003_\u000b)\fE\u0002.\u0003cK1!a-/\u0005\r\te.\u001f\u0005\t\u0003oS\u0012\u0011!a\u0001\u0017\u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!0\u0011\r\u0005}\u0016\u0011YAX\u001b\u0005)\u0016bAAb+\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\r)\u0017\u0011\u001a\u0005\n\u0003oc\u0012\u0011!a\u0001\u0003_\u000b\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0002\u0017\u0006AAo\\*ue&tw\rF\u0001C\u0003\u0019)\u0017/^1mgR\u0019Q-a6\t\u0013\u0005]v$!AA\u0002\u0005=\u0016A\u0003*fC\u0012\u0014Vm];miB\u0019\u0011\u0011P\u0011\u0014\u000b\u0005\ny.a\u0013\u0011\u0013\u0005\u0005\u0018q]@\u0002\\\u0005]TBAAr\u0015\r\t)OL\u0001\beVtG/[7f\u0013\u0011\tI/a9\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t'\u0007\u0006\u0002\u0002\\\u0006)\u0011\r\u001d9msR1\u0011qOAy\u0003gDa!!\u0015%\u0001\u0004y\bbBA,I\u0001\u0007\u00111L\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\tI0!@\u0011\u000b5\n\t!a?\u0011\u000b5\u0002u0a\u0017\t\u0013\u0005}X%!AA\u0002\u0005]\u0014a\u0001=%a\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u0011)\u0001E\u0002D\u0005\u000fI1A!\u0003E\u0005\u0019y%M[3di\")1\u000e\u0003a\u0001Y\u0006Y!/Z1e\u0007>tG/\u001a8u)\r9(\u0011\u0003\u0005\u0006W&\u0001\r\u0001\u001c")
public final class LowLevelMessageReader {
    private final LoggerSupport logger;
    private final Tuple2<String, String> EmptyPair;
    private int contentLength;
    private Map<String, String> header;

    public static Function1<Subscriber<LowLevelMessage>, Subscriber<ByteBuffer>> streamReader(LoggerSupport loggerSupport) {
        return LowLevelMessageReader$.MODULE$.streamReader(loggerSupport);
    }

    public static Option<LowLevelMessage> read(ByteBuffer byteBuffer, LoggerSupport loggerSupport) {
        return LowLevelMessageReader$.MODULE$.read(byteBuffer, loggerSupport);
    }

    public int currentContentLength() {
        return this.contentLength;
    }

    private boolean atDelimiter(int idx, ArrayBuffer<Object> data) {
        return data.size() >= idx + 4 && BoxesRunTime.unboxToByte((Object)data.apply(idx)) == 13 && BoxesRunTime.unboxToByte((Object)data.apply(idx + 1)) == 10 && BoxesRunTime.unboxToByte((Object)data.apply(idx + 2)) == 13 && BoxesRunTime.unboxToByte((Object)data.apply(idx + 3)) == 10;
    }

    public ReadResult readHeaders(ArrayBuffer<Object> data) {
        ReadResult readResult;
        if (data.size() < 4) {
            readResult = new ReadResult((Option<LowLevelMessage>)None$.MODULE$, (Future<Ack>)Ack.Continue$.MODULE$);
        } else {
            int i = 0;
            while (i + 4 < data.size() && !this.atDelimiter(i, data)) {
                ++i;
            }
            if (!this.atDelimiter(i, data)) {
                readResult = new ReadResult((Option<LowLevelMessage>)None$.MODULE$, (Future<Ack>)Ack.Continue$.MODULE$);
            } else {
                ReadResult readResult2;
                byte[] bytes = new byte[i];
                data.copyToArray((Object)bytes);
                data.remove(0, i + 4);
                String headers = new String(bytes, StandardCharsets.US_ASCII);
                Map pairs = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])headers.split("\r\n"))).iterator().filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)LowLevelMessageReader.$anonfun$readHeaders$1(x$1))).map((Function1 & Serializable & scala.Serializable)line -> {
                    Tuple2 tuple2;
                    String[] stringArray = line.split(":");
                    Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
                    if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(2) == 0) {
                        String key = (String)((SeqLike)option.get()).apply(0);
                        String value = (String)((SeqLike)option.get()).apply(1);
                        tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key.trim()), (Object)value.trim());
                    } else {
                        $this.logger.error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("Malformed input: ").append((String)line).toString(), (Loggable)Loggable.StringLoggable$.MODULE$, new Pkg("jsonrpc4s"), new FileName("LowLevelMessageReader.scala"), new Name("pairs"), new Line(53));
                        tuple2 = $this.EmptyPair;
                    }
                    return tuple2;
                }).toMap(Predef$.MODULE$.$conforms());
                Option option = pairs.get((Object)"Content-Length");
                if (option instanceof Some) {
                    ReadResult readResult3;
                    Some some = (Some)option;
                    String n = (String)some.value();
                    try {
                        this.contentLength = new StringOps(Predef$.MODULE$.augmentString(n)).toInt();
                        this.header = pairs;
                        readResult3 = this.readContent(data);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.logger.error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("Expected Content-Length to be a number, obtained ").append(n).toString(), (Loggable)Loggable.StringLoggable$.MODULE$, new Pkg("jsonrpc4s"), new FileName("LowLevelMessageReader.scala"), new Name("readHeaders"), new Line(67));
                        readResult3 = new ReadResult((Option<LowLevelMessage>)None$.MODULE$, (Future<Ack>)Ack.Continue$.MODULE$);
                    }
                    readResult2 = readResult3;
                } else {
                    this.logger.error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Missing Content-Length key in headers ").append(pairs).toString(), (Loggable)Loggable.StringLoggable$.MODULE$, new Pkg("jsonrpc4s"), new FileName("LowLevelMessageReader.scala"), new Name("readHeaders"), new Line(73));
                    readResult2 = new ReadResult((Option<LowLevelMessage>)None$.MODULE$, (Future<Ack>)Ack.Continue$.MODULE$);
                }
                readResult = readResult2;
            }
        }
        return readResult;
    }

    public ReadResult readContent(ArrayBuffer<Object> data) {
        ReadResult readResult;
        if (this.contentLength > data.size()) {
            readResult = new ReadResult((Option<LowLevelMessage>)None$.MODULE$, (Future<Ack>)Ack.Continue$.MODULE$);
        } else {
            byte[] contentBytes = new byte[this.contentLength];
            data.copyToArray((Object)contentBytes);
            data.remove(0, this.contentLength);
            this.contentLength = -1;
            LowLevelMessage msg = new LowLevelMessage(this.header, contentBytes);
            readResult = new ReadResult((Option<LowLevelMessage>)new Some((Object)msg), (Future<Ack>)Ack.Stop$.MODULE$);
        }
        return readResult;
    }

    public static final /* synthetic */ boolean $anonfun$readHeaders$1(String x$1) {
        return x$1.trim().isEmpty();
    }

    public LowLevelMessageReader(LoggerSupport logger) {
        this.logger = logger;
        this.EmptyPair = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)""), (Object)"");
        this.contentLength = -1;
        this.header = Predef$.MODULE$.Map().empty();
    }

    public static class ReadResult
    implements Product,
    scala.Serializable {
        private final Option<LowLevelMessage> msg;
        private final Future<Ack> ack;

        public Option<LowLevelMessage> msg() {
            return this.msg;
        }

        public Future<Ack> ack() {
            return this.ack;
        }

        public ReadResult copy(Option<LowLevelMessage> msg, Future<Ack> ack) {
            return new ReadResult(msg, ack);
        }

        public Option<LowLevelMessage> copy$default$1() {
            return this.msg();
        }

        public Future<Ack> copy$default$2() {
            return this.ack();
        }

        public String productPrefix() {
            return "ReadResult";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Option<LowLevelMessage> option;
            int n = x$1;
            switch (n) {
                case 0: {
                    option = this.msg();
                    break;
                }
                case 1: {
                    option = this.ack();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(Integer.toString(x$1));
                }
            }
            return option;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ReadResult;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ReadResult)) return false;
            boolean bl = true;
            if (!bl) return false;
            ReadResult readResult = (ReadResult)x$1;
            Option<LowLevelMessage> option = this.msg();
            Option<LowLevelMessage> option2 = readResult.msg();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Future<Ack> future = this.ack();
            Future<Ack> future2 = readResult.ack();
            if (future == null) {
                if (future2 != null) {
                    return false;
                }
            } else if (!future.equals(future2)) return false;
            if (!readResult.canEqual(this)) return false;
            return true;
        }

        public ReadResult(Option<LowLevelMessage> msg, Future<Ack> ack) {
            this.msg = msg;
            this.ack = ack;
            Product.$init$((Product)this);
        }
    }
}

