/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.util;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.Level;
import sbt.internal.util.Appender;
import sbt.internal.util.ConsoleAppender;
import sbt.internal.util.ConsoleAppender$Properties$;
import sbt.internal.util.ConsoleOut;
import sbt.internal.util.ConsoleOut$;
import sbt.internal.util.LogOption;
import sbt.internal.util.LogOption$Always$;
import sbt.internal.util.LogOption$Auto$;
import sbt.internal.util.LogOption$Never$;
import sbt.internal.util.SuppressedTraceContext;
import sbt.internal.util.Terminal;
import sbt.internal.util.Terminal$;
import sbt.util.Level$;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.runtime.BoxesRunTime;

public final class ConsoleAppender$ {
    public static ConsoleAppender$ MODULE$;
    private boolean formatEnabledInEnv;
    private final String ClearScreenAfterCursor;
    private final String CursorLeft1000;
    private final String CursorDown1;
    private final String ClearPromptLine;
    private final AtomicBoolean showProgressHolder;
    private final Function1<SuppressedTraceContext, None$> noSuppressedMessage;
    private final AtomicInteger generateId;
    private volatile boolean bitmap$0;

    static {
        new ConsoleAppender$();
    }

    public String cursorLeft(int n) {
        return new StringBuilder(3).append("\u001b[").append(n).append("D").toString();
    }

    public String cursorUp(int n) {
        return new StringBuilder(3).append("\u001b[").append(n).append("A").toString();
    }

    public String cursorDown(int n) {
        return new StringBuilder(3).append("\u001b[").append(n).append("B").toString();
    }

    public String scrollUp(int n) {
        return new StringBuilder(3).append("\u001b[").append(n).append("S").toString();
    }

    public String clearScreen(int n) {
        return new StringBuilder(3).append("\u001b[").append(n).append("J").toString();
    }

    public String clearLine(int n) {
        return new StringBuilder(3).append("\u001b[").append(n).append("K").toString();
    }

    public final String DeleteLine() {
        return "\u001b[2K";
    }

    public final String ClearScreenAfterCursor() {
        return this.ClearScreenAfterCursor;
    }

    public final String CursorLeft1000() {
        return this.CursorLeft1000;
    }

    public final String CursorDown1() {
        return this.CursorDown1;
    }

    public final String ClearPromptLine() {
        return this.ClearPromptLine;
    }

    public void setShowProgress(boolean b) {
        this.showProgressHolder.set(b);
    }

    public boolean showProgress() {
        return this.showProgressHolder.get();
    }

    public Function1<SuppressedTraceContext, None$> noSuppressedMessage() {
        return this.noSuppressedMessage;
    }

    private boolean formatEnabledInEnv$lzycompute() {
        ConsoleAppender$ consoleAppender$ = this;
        synchronized (consoleAppender$) {
            if (!this.bitmap$0) {
                this.formatEnabledInEnv = Terminal$.MODULE$.isAnsiSupported();
                this.bitmap$0 = true;
            }
        }
        return this.formatEnabledInEnv;
    }

    public boolean formatEnabledInEnv() {
        if (!this.bitmap$0) {
            return this.formatEnabledInEnv$lzycompute();
        }
        return this.formatEnabledInEnv;
    }

    public LogOption parseLogOption(String s) {
        boolean bl;
        boolean bl2 = false;
        Some some = null;
        Option<Object> option = Terminal$.MODULE$.parseLogOption(s);
        if (option instanceof Some) {
            bl2 = true;
            some = (Some)option;
            boolean bl3 = BoxesRunTime.unboxToBoolean((Object)some.value());
            if (bl3) {
                return LogOption$Always$.MODULE$;
            }
        }
        if (bl2 && !(bl = BoxesRunTime.unboxToBoolean((Object)some.value()))) {
            return LogOption$Never$.MODULE$;
        }
        return LogOption$Auto$.MODULE$;
    }

    public Appender apply() {
        return this.apply(ConsoleOut$.MODULE$.systemOut());
    }

    public Appender apply(PrintStream out) {
        return this.apply(ConsoleOut$.MODULE$.printStreamOut(out));
    }

    public Appender apply(PrintWriter out) {
        return this.apply(ConsoleOut$.MODULE$.printWriterOut(out));
    }

    public Appender apply(ConsoleOut out) {
        return this.apply(this.generateName(), out);
    }

    public Appender apply(String name) {
        return this.apply(name, ConsoleOut$.MODULE$.systemOut());
    }

    public Appender apply(String name, ConsoleOut out) {
        return this.apply(name, out, Terminal$.MODULE$.isAnsiSupported());
    }

    public Appender apply(String name, ConsoleOut out, Function1<SuppressedTraceContext, Option<String>> suppressedMessage) {
        boolean ansi = Terminal$.MODULE$.isAnsiSupported();
        return this.apply(name, out, ansi, ansi, suppressedMessage);
    }

    public Appender apply(String name, ConsoleOut out, boolean useFormat) {
        return this.apply(name, out, useFormat || Terminal$.MODULE$.isAnsiSupported(), useFormat, this.noSuppressedMessage());
    }

    public Appender apply(String name, Terminal terminal) {
        return new ConsoleAppender(name, ConsoleAppender$Properties$.MODULE$.from(terminal), this.noSuppressedMessage());
    }

    public Appender apply(String name, Terminal terminal, Function1<SuppressedTraceContext, Option<String>> suppressedMessage) {
        return new ConsoleAppender(name, ConsoleAppender$Properties$.MODULE$.from(terminal), suppressedMessage);
    }

    public Appender apply(String name, ConsoleOut out, boolean ansiCodesSupported, boolean useFormat, Function1<SuppressedTraceContext, Option<String>> suppressedMessage) {
        return new ConsoleAppender(name, ConsoleAppender$Properties$.MODULE$.from(out, ansiCodesSupported, useFormat), suppressedMessage);
    }

    public Enumeration.Value toLevel(Level level) {
        Level level2 = level;
        Level level3 = Level.OFF;
        Level level4 = level2;
        if (!(level3 != null ? !level3.equals(level4) : level4 != null)) {
            return Level$.MODULE$.Debug();
        }
        Level level5 = Level.FATAL;
        Level level6 = level2;
        if (!(level5 != null ? !level5.equals(level6) : level6 != null)) {
            return Level$.MODULE$.Error();
        }
        Level level7 = Level.ERROR;
        Level level8 = level2;
        if (!(level7 != null ? !level7.equals(level8) : level8 != null)) {
            return Level$.MODULE$.Error();
        }
        Level level9 = Level.WARN;
        Level level10 = level2;
        if (!(level9 != null ? !level9.equals(level10) : level10 != null)) {
            return Level$.MODULE$.Warn();
        }
        Level level11 = Level.INFO;
        Level level12 = level2;
        if (!(level11 != null ? !level11.equals(level12) : level12 != null)) {
            return Level$.MODULE$.Info();
        }
        Level level13 = Level.DEBUG;
        Level level14 = level2;
        if (!(level13 != null ? !level13.equals(level14) : level14 != null)) {
            return Level$.MODULE$.Debug();
        }
        return Level$.MODULE$.Debug();
    }

    public Level toXLevel(Enumeration.Value level) {
        Enumeration.Value value = level;
        Enumeration.Value value2 = Level$.MODULE$.Error();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            return Level.ERROR;
        }
        Enumeration.Value value4 = Level$.MODULE$.Warn();
        Enumeration.Value value5 = value;
        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
            return Level.WARN;
        }
        Enumeration.Value value6 = Level$.MODULE$.Info();
        Enumeration.Value value7 = value;
        if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
            return Level.INFO;
        }
        Enumeration.Value value8 = Level$.MODULE$.Debug();
        Enumeration.Value value9 = value;
        if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
            return Level.DEBUG;
        }
        throw new MatchError((Object)value);
    }

    public String generateName() {
        return new StringBuilder(4).append("out-").append(this.generateId.incrementAndGet()).toString();
    }

    private boolean ansiSupported() {
        return Terminal$.MODULE$.console().isAnsiSupported();
    }

    private ConsoleAppender$() {
        MODULE$ = this;
        this.ClearScreenAfterCursor = this.clearScreen(0);
        this.CursorLeft1000 = this.cursorLeft(1000);
        this.CursorDown1 = this.cursorDown(1);
        this.ClearPromptLine = new StringBuilder(0).append(this.CursorLeft1000()).append(this.ClearScreenAfterCursor()).toString();
        this.showProgressHolder = new AtomicBoolean(false);
        this.noSuppressedMessage = (Function1 & Serializable & scala.Serializable)x$1 -> None$.MODULE$;
        this.generateId = new AtomicInteger();
    }
}

