/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.inc;

import java.io.File;
import java.io.Serializable;
import sbt.internal.inc.Analysis;
import sbt.internal.inc.Lookup;
import sbt.internal.inc.Relations;
import sbt.internal.inc.Stamps;
import sbt.util.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.HashSet;
import scala.math.Equiv;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;
import xsbt.api.APIUtil$;
import xsbti.FileConverter;
import xsbti.VirtualFile;
import xsbti.VirtualFileRef;
import xsbti.compile.ClassFileManager;
import xsbti.compile.CompileAnalysis;
import xsbti.compile.DependencyChanges;
import xsbti.compile.analysis.ReadStamps;
import xsbti.compile.analysis.Stamp;

public final class IncrementalCommon$ {
    public static IncrementalCommon$ MODULE$;
    private DependencyChanges emptyChanges;
    private volatile boolean bitmap$0;

    static {
        new IncrementalCommon$();
    }

    public boolean comesFromScalaSource(Relations previous, Option<Relations> current, String className) {
        Set previousSourcesWithClassName = previous.classes().reverse((Object)className);
        Set newSourcesWithClassName = (Set)current.map((Function1 & Serializable & scala.Serializable)x$13 -> x$13.classes().reverse((Object)className)).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Set().empty());
        if (previousSourcesWithClassName.isEmpty() && newSourcesWithClassName.isEmpty()) {
            throw package$.MODULE$.error(new StringBuilder(58).append("Fatal Zinc error: no entry for class ").append(className).append(" in classes relation.").toString());
        }
        return previousSourcesWithClassName.forall((Function1 & Serializable & scala.Serializable)src -> BoxesRunTime.boxToBoolean((boolean)APIUtil$.MODULE$.isScalaSourceName(src.id()))) && newSourcesWithClassName.forall((Function1 & Serializable & scala.Serializable)src -> BoxesRunTime.boxToBoolean((boolean)APIUtil$.MODULE$.isScalaSourceName(src.id())));
    }

    public Option<Relations> comesFromScalaSource$default$2() {
        return None$.MODULE$;
    }

    public Set<String> invalidateNamesProducingSameClassFile(Relations merged) {
        return ((TraversableOnce)merged.srcProd().reverseMap().flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Set sources = (Set)tuple2._2();
                if (sources.size() > 1) {
                    return (scala.collection.immutable.Iterable)sources.flatMap((Function1 & Serializable & scala.Serializable)x$14 -> merged.classNames((VirtualFileRef)x$14), Set$.MODULE$.canBuildFrom());
                }
                return Nil$.MODULE$;
            }
            throw new MatchError((Object)tuple2);
        }, Iterable$.MODULE$.canBuildFrom())).toSet();
    }

    public Function1<VirtualFileRef, Object> isLibraryModified(boolean skipClasspathLookup, Lookup lookup, Stamps previousStamps, ReadStamps currentStamps, Relations previousRelations, FileConverter converter, Logger log, Equiv<Stamp> equivS) {
        return (Function1 & Serializable & scala.Serializable)binaryFile -> BoxesRunTime.boxToBoolean((boolean)IncrementalCommon$.$anonfun$isLibraryModified$1(log, previousStamps, currentStamps, equivS, converter, previousRelations, lookup, skipClasspathLookup, binaryFile));
    }

    public <T> Set<T> transitiveDeps(Iterable<T> nodes, Logger log, boolean logging, Function1<T, Iterable<T>> dependencies) {
        HashSet visited = new HashSet();
        if (logging) {
            log.debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Initial set of included nodes: ").append(nodes.mkString(", ")).toString());
        }
        nodes.foreach((Function1 & Serializable & scala.Serializable)start -> {
            IncrementalCommon$.$anonfun$transitiveDeps$4(visited, dependencies, logging, log, start);
            return BoxedUnit.UNIT;
        });
        return visited.toSet();
    }

    public <T> boolean transitiveDeps$default$3() {
        return true;
    }

    public void checkAbsolute(Iterable<VirtualFileRef> addedSources) {
        if (addedSources.isEmpty()) {
            return;
        }
    }

    private DependencyChanges emptyChanges$lzycompute() {
        IncrementalCommon$ incrementalCommon$ = this;
        synchronized (incrementalCommon$) {
            if (!this.bitmap$0) {
                this.emptyChanges = new DependencyChanges(){
                    private final File[] modifiedBinaries;
                    private final VirtualFileRef[] modifiedLibraries;
                    private final String[] modifiedClasses;

                    public File[] modifiedBinaries() {
                        return this.modifiedBinaries;
                    }

                    public VirtualFileRef[] modifiedLibraries() {
                        return this.modifiedLibraries;
                    }

                    public String[] modifiedClasses() {
                        return this.modifiedClasses;
                    }

                    public boolean isEmpty() {
                        return true;
                    }
                    {
                        this.modifiedBinaries = new File[0];
                        this.modifiedLibraries = new VirtualFileRef[0];
                        this.modifiedClasses = new String[0];
                    }
                };
                this.bitmap$0 = true;
            }
        }
        return this.emptyChanges;
    }

    public DependencyChanges emptyChanges() {
        if (!this.bitmap$0) {
            return this.emptyChanges$lzycompute();
        }
        return this.emptyChanges;
    }

    public Analysis pruneClassFilesOfInvalidations(Set<VirtualFile> invalidatedSources, Analysis previous, ClassFileManager classfileManager, FileConverter converter) {
        List products = ((TraversableOnce)invalidatedSources.flatMap((Function1 & Serializable & scala.Serializable)src -> previous.relations().products((VirtualFileRef)src), Set$.MODULE$.canBuildFrom())).toList();
        classfileManager.delete((VirtualFile[])((TraversableOnce)products.map((Function1 & Serializable & scala.Serializable)x$15 -> converter.toVirtualFile(x$15), List$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(VirtualFile.class)));
        return previous.$minus$minus((Iterable<VirtualFileRef>)invalidatedSources);
    }

    private static final boolean invalidateBinary$1(String reason, Logger log$1, VirtualFileRef binaryFile$1) {
        log$1.debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("Invalidating '").append(binaryFile$1).append("' because ").append(reason).toString());
        return true;
    }

    private static final boolean compareStamps$1(VirtualFileRef previousFile, VirtualFileRef currentFile, Stamps previousStamps$1, ReadStamps currentStamps$1, Equiv equivS$2, Logger log$1, VirtualFileRef binaryFile$1) {
        Stamp currentStamp;
        Stamp previousStamp = previousStamps$1.library(previousFile);
        if (equivS$2.equiv((Object)previousStamp, (Object)(currentStamp = currentStamps$1.library(currentFile)))) {
            return false;
        }
        return IncrementalCommon$.invalidateBinary$1(new StringBuilder(10).append(previousFile).append(" (").append(previousStamp).append(") != ").append(currentFile).append(" (").append(currentStamp).append(")").toString(), log$1, binaryFile$1);
    }

    private static final boolean compareOriginClassFile$1(String className, VirtualFileRef classpathEntry, FileConverter converter$2, VirtualFileRef file$1, Logger log$1, VirtualFileRef binaryFile$1, Stamps previousStamps$1, ReadStamps currentStamps$1, Equiv equivS$2) {
        if (classpathEntry.id().endsWith(".jar")) {
            String string = ((Object)converter$2.toPath(classpathEntry)).toString();
            String string2 = ((Object)converter$2.toPath(file$1)).toString();
            if (string == null ? string2 != null : !string.equals(string2)) {
                return IncrementalCommon$.invalidateBinary$1(new StringBuilder(20).append(className).append(" is now provided by ").append(classpathEntry).toString(), log$1, binaryFile$1);
            }
        }
        return IncrementalCommon$.compareStamps$1(file$1, classpathEntry, previousStamps$1, currentStamps$1, equivS$2, log$1, binaryFile$1);
    }

    public static final /* synthetic */ boolean $anonfun$isLibraryModified$3(Lookup lookup$2, Logger log$1, VirtualFileRef binaryFile$1, FileConverter converter$2, VirtualFileRef file$1, Stamps previousStamps$1, ReadStamps currentStamps$1, Equiv equivS$2, String binaryClassName) {
        if (lookup$2.changedClasspathHash().isEmpty()) {
            Option<CompileAnalysis> option = lookup$2.lookupAnalysis(binaryClassName);
            if (None$.MODULE$.equals(option)) {
                return false;
            }
            if (option instanceof Some) {
                Some some = (Some)option;
                CompileAnalysis a = (CompileAnalysis)some.value();
                return IncrementalCommon$.invalidateBinary$1(new StringBuilder(20).append(binaryClassName).append(" came from analysis ").append(a).toString(), log$1, binaryFile$1);
            }
            throw new MatchError(option);
        }
        Option<VirtualFileRef> option = lookup$2.lookupOnClasspath(binaryClassName);
        if (None$.MODULE$.equals(option)) {
            return IncrementalCommon$.invalidateBinary$1(new StringBuilder(39).append("could not find class ").append(binaryClassName).append(" on the classpath.").toString(), log$1, binaryFile$1);
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            VirtualFileRef classpathEntry = (VirtualFileRef)some.value();
            return IncrementalCommon$.compareOriginClassFile$1(binaryClassName, classpathEntry, converter$2, file$1, log$1, binaryFile$1, previousStamps$1, currentStamps$1, equivS$2);
        }
        throw new MatchError(option);
    }

    private static final boolean isLibraryChanged$1(VirtualFileRef file, FileConverter converter$2, Relations previousRelations$2, Lookup lookup$2, Logger log$1, VirtualFileRef binaryFile$1, Stamps previousStamps$1, ReadStamps currentStamps$1, Equiv equivS$2) {
        Set<String> classNames = previousRelations$2.libraryClassNames(file);
        return classNames.exists((Function1 & Serializable & scala.Serializable)binaryClassName -> BoxesRunTime.boxToBoolean((boolean)IncrementalCommon$.$anonfun$isLibraryModified$3(lookup$2, log$1, binaryFile$1, converter$2, file, previousStamps$1, currentStamps$1, equivS$2, binaryClassName)));
    }

    public static final /* synthetic */ boolean $anonfun$isLibraryModified$1(Logger log$1, Stamps previousStamps$1, ReadStamps currentStamps$1, Equiv equivS$2, FileConverter converter$2, Relations previousRelations$2, Lookup lookup$2, boolean skipClasspathLookup$1, VirtualFileRef binaryFile) {
        if (skipClasspathLookup$1) {
            return IncrementalCommon$.compareStamps$1(binaryFile, binaryFile, previousStamps$1, currentStamps$1, equivS$2, log$1, binaryFile);
        }
        return IncrementalCommon$.isLibraryChanged$1(binaryFile, converter$2, previousRelations$2, lookup$2, log$1, binaryFile, previousStamps$1, currentStamps$1, equivS$2);
    }

    private static final void all$1(Object from, Iterable tos, HashSet visited$1, boolean logging$1, Logger log$2, Function1 dependencies$1) {
        tos.foreach((Function1 & Serializable & scala.Serializable)to -> {
            IncrementalCommon$.visit$1(from, to, visited$1, logging$1, log$2, dependencies$1);
            return BoxedUnit.UNIT;
        });
    }

    private static final void visit$1(Object from, Object to, HashSet visited$1, boolean logging$1, Logger log$2, Function1 dependencies$1) {
        if (!visited$1.contains(to)) {
            if (logging$1) {
                log$2.debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(14).append("Including ").append(to).append(" by ").append(from).toString());
            }
            visited$1.$plus$eq(to);
            IncrementalCommon$.all$1(to, (Iterable)dependencies$1.apply(to), visited$1, logging$1, log$2, dependencies$1);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$transitiveDeps$4(HashSet visited$1, Function1 dependencies$1, boolean logging$1, Logger log$2, Object start) {
        visited$1.$plus$eq(start);
        IncrementalCommon$.all$1(start, (Iterable)dependencies$1.apply(start), visited$1, logging$1, log$2, dependencies$1);
    }

    private IncrementalCommon$() {
        MODULE$ = this;
    }
}

