/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.inc;

import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.UUID;
import sbt.internal.inc.APIs;
import sbt.internal.inc.AdaptedRunProfiler;
import sbt.internal.inc.Analysis;
import sbt.internal.inc.AnalysisCallback;
import sbt.internal.inc.ClassFileManager$;
import sbt.internal.inc.Compilations;
import sbt.internal.inc.Incremental;
import sbt.internal.inc.IncrementalCommon;
import sbt.internal.inc.IncrementalCommon$;
import sbt.internal.inc.IncrementalNameHashing;
import sbt.internal.inc.InitialChanges;
import sbt.internal.inc.JarUtils;
import sbt.internal.inc.Lookup;
import sbt.internal.inc.PickleJar$;
import sbt.internal.inc.Relations;
import sbt.internal.inc.SourceInfos;
import sbt.internal.inc.Stamps;
import sbt.internal.inc.Stamps$;
import sbt.util.InterfaceUtil$;
import sbt.util.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Equiv;
import scala.math.Equiv$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.sys.package$;
import xsbti.CompileCancelled;
import xsbti.FileConverter;
import xsbti.VirtualFile;
import xsbti.VirtualFileRef;
import xsbti.api.AnalyzedClass;
import xsbti.compile.AnalysisStore;
import xsbti.compile.ClassFileManager;
import xsbti.compile.CompileAnalysis;
import xsbti.compile.CompileProgress;
import xsbti.compile.DependencyChanges;
import xsbti.compile.IncOptions;
import xsbti.compile.InvalidationProfiler;
import xsbti.compile.MiniSetup;
import xsbti.compile.Output;
import xsbti.compile.analysis.ReadStamps;
import xsbti.compile.analysis.Stamp;

public final class Incremental$ {
    public static Incremental$ MODULE$;
    private final String incDebugProp;
    private final String apiDebugProp;

    static {
        new Incremental$();
    }

    public Tuple2<Object, Analysis> apply(scala.collection.immutable.Set<VirtualFile> sources, FileConverter converter, Lookup lookup, CompileAnalysis previous0, IncOptions options, MiniSetup currentSetup, ReadStamps stamper, Output output, JarUtils.OutputJarContent outputJarContent, Option<Output> earlyOutput, Option<AnalysisStore> earlyAnalysisStore, Option<CompileProgress> progress, Logger log, Function4<scala.collection.immutable.Set<VirtualFile>, DependencyChanges, xsbti.AnalysisCallback, ClassFileManager, BoxedUnit> compile) {
        Tuple2<Object, Analysis> tuple2;
        log.debug((Function0 & Serializable & scala.Serializable)() -> "[zinc] IncrementalCompile -----------");
        CompileAnalysis compileAnalysis = previous0;
        if (!(compileAnalysis instanceof Analysis)) {
            throw new MatchError((Object)compileAnalysis);
        }
        Analysis analysis = (Analysis)compileAnalysis;
        Analysis previous = analysis;
        ReadStamps currentStamper = Stamps$.MODULE$.initial(stamper);
        Function1 & Serializable & scala.Serializable internalBinaryToSourceClassName = (Function1 & Serializable & scala.Serializable)binaryClassName -> previous.relations().productClassName().reverse(binaryClassName).headOption();
        Function1 & Serializable & scala.Serializable internalSourceToClassNamesMap = (Function1 & Serializable & scala.Serializable)f -> previous.relations().classNames((VirtualFileRef)f);
        Option<Path> earlyJar = this.extractEarlyJar(earlyOutput);
        Option pickleJarPair = earlyJar.map((Function1 & Serializable & scala.Serializable)p -> {
            String newName = new StringBuilder(5).append(new StringOps(Predef$.MODULE$.augmentString(((Object)p.getFileName()).toString())).stripSuffix(".jar")).append("-").append(UUID.randomUUID()).append(".jar").toString();
            Path updatesJar = p.resolveSibling(newName);
            PickleJar$.MODULE$.touch(updatesJar);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(p), (Object)updatesJar);
        });
        InvalidationProfiler profiler = options.externalHooks().getInvalidationProfiler();
        AdaptedRunProfiler runProfiler = new AdaptedRunProfiler(profiler.profileRun());
        IncrementalNameHashing incremental = new IncrementalNameHashing(log, options, runProfiler);
        try {
            try {
                tuple2 = this.incrementalCompile(sources, converter, lookup, previous, currentStamper, (Function4<scala.collection.immutable.Set<VirtualFile>, DependencyChanges, xsbti.AnalysisCallback, ClassFileManager, BoxedUnit>)(Function4 & Serializable & scala.Serializable)(vs, depCh, cb, cfm) -> {
                    Incremental$.$anonfun$apply$5(compile, runProfiler, vs, depCh, cb, cfm);
                    return BoxedUnit.UNIT;
                }, new AnalysisCallback.Builder((Function1<String, Option<String>>)internalBinaryToSourceClassName, (Function1<VirtualFile, scala.collection.immutable.Set<String>>)internalSourceToClassNamesMap, (Function2<String, Option<VirtualFileRef>, Option<AnalyzedClass>>)(Function2 & Serializable & scala.Serializable)(x$1, x$2) -> lookup.lookupAnalyzedClass((String)x$1, (Option<VirtualFileRef>)x$2), currentStamper, options, currentSetup, converter, lookup, output, outputJarContent, earlyOutput, earlyAnalysisStore, (Option<Tuple2<Path, Path>>)pickleJarPair, progress, log), incremental, options, currentSetup, output, outputJarContent, earlyOutput, progress, log, (Equiv<Stamp>)Equiv$.MODULE$.universalEquiv());
            }
            catch (CompileCancelled compileCancelled) {
                log.info((Function0 & Serializable & scala.Serializable)() -> "Compilation has been cancelled");
                tuple2 = new Tuple2<Object, Analysis>((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)previous);
            }
        }
        finally {
            runProfiler.registerRun();
        }
        return tuple2;
    }

    public Option<Path> extractEarlyJar(Option<Output> earlyOutput) {
        return earlyOutput.flatMap((Function1 & Serializable & scala.Serializable)early -> InterfaceUtil$.MODULE$.jo2o(early.getSingleOutputAsPath()).map((Function1 & Serializable & scala.Serializable)jar -> jar));
    }

    public boolean isPickleJava(Seq<String> scalacOptions) {
        return scalacOptions.contains((Object)"-Ypickle-java");
    }

    public Tuple2<Object, Analysis> compileAllJava(Seq<VirtualFile> sources, FileConverter converter, Lookup lookup, CompileAnalysis previous0, IncOptions options, MiniSetup currentSetup, ReadStamps stamper, Output output, JarUtils.OutputJarContent outputJarContent, Option<Output> earlyOutput, Option<AnalysisStore> earlyAnalysisStore, Option<CompileProgress> progress, Logger log, Function3<Seq<VirtualFile>, xsbti.AnalysisCallback, ClassFileManager, BoxedUnit> compileJava) {
        Tuple2 tuple2;
        log.debug((Function0 & Serializable & scala.Serializable)() -> "[zinc] compileAllJava");
        CompileAnalysis compileAnalysis = previous0;
        if (!(compileAnalysis instanceof Analysis)) {
            throw new MatchError((Object)compileAnalysis);
        }
        Analysis analysis = (Analysis)compileAnalysis;
        Analysis previous = analysis;
        ReadStamps currentStamper = Stamps$.MODULE$.initial(stamper);
        Function1 & Serializable & scala.Serializable internalBinaryToSourceClassName = (Function1 & Serializable & scala.Serializable)binaryClassName -> previous.relations().productClassName().reverse(binaryClassName).headOption();
        Function1 & Serializable & scala.Serializable internalSourceToClassNamesMap = (Function1 & Serializable & scala.Serializable)f -> previous.relations().classNames((VirtualFileRef)f);
        AnalysisCallback.Builder builder = new AnalysisCallback.Builder((Function1<String, Option<String>>)internalBinaryToSourceClassName, (Function1<VirtualFile, scala.collection.immutable.Set<String>>)internalSourceToClassNamesMap, (Function2<String, Option<VirtualFileRef>, Option<AnalyzedClass>>)(Function2 & Serializable & scala.Serializable)(x$3, x$4) -> lookup.lookupAnalyzedClass((String)x$3, (Option<VirtualFileRef>)x$4), currentStamper, options, currentSetup, converter, lookup, output, outputJarContent, earlyOutput, earlyAnalysisStore, (Option<Tuple2<Path, Path>>)None$.MODULE$, progress, log);
        AnalysisCallback callback = builder.build();
        try {
            Analysis analysis2 = (Analysis)this.withClassfileManager(options, converter, output, outputJarContent, (Function1 & Serializable & scala.Serializable)classFileManager -> {
                compileJava.apply((Object)sources, (Object)callback, classFileManager);
                Analysis a0 = callback.getPostJavaAnalysis();
                return Incremental$.completeCycle$1(a0, previous, converter, classFileManager);
            });
            tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)sources.nonEmpty()), (Object)analysis2);
        }
        catch (CompileCancelled compileCancelled) {
            log.info((Function0 & Serializable & scala.Serializable)() -> "Compilation has been cancelled");
            tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)previous);
        }
        return tuple2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Tuple2<Object, Analysis> incrementalCompile(scala.collection.immutable.Set<VirtualFile> sources, FileConverter converter, Lookup lookup, CompileAnalysis previous0, ReadStamps current, Function4<scala.collection.immutable.Set<VirtualFile>, DependencyChanges, xsbti.AnalysisCallback, ClassFileManager, BoxedUnit> compile, AnalysisCallback.Builder callbackBuilder, IncrementalCommon incremental, IncOptions options, MiniSetup currentSetup, Output output, JarUtils.OutputJarContent outputJarContent, Option<Output> earlyOutput, Option<CompileProgress> progress, Logger log, Equiv<Stamp> equivS) {
        scala.collection.immutable.Set initialInvSources;
        boolean hasModified;
        log.debug((Function0 & Serializable & scala.Serializable)() -> "IncrementalCompile.incrementalCompile");
        CompileAnalysis compileAnalysis = previous0;
        if (!(compileAnalysis instanceof Analysis)) {
            throw new MatchError((Object)compileAnalysis);
        }
        Analysis analysis = (Analysis)compileAnalysis;
        Analysis previous = analysis;
        InitialChanges initialChanges = incremental.detectInitialChanges(sources, previous, current, lookup, converter, output, equivS);
        log.debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("> initialChanges = ").append(initialChanges).toString());
        DependencyChanges binaryChanges = new DependencyChanges(converter, initialChanges){
            private final VirtualFileRef[] modifiedLibraries;
            private final String[] modifiedClasses;
            private final FileConverter converter$2;

            public File[] modifiedBinaries() {
                return (File[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.modifiedLibraries())).map((Function1 & Serializable & scala.Serializable)x$6 -> $this.converter$2.toPath(x$6).toFile(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class)));
            }

            public VirtualFileRef[] modifiedLibraries() {
                return this.modifiedLibraries;
            }

            public String[] modifiedClasses() {
                return this.modifiedClasses;
            }

            public boolean isEmpty() {
                return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.modifiedLibraries())).isEmpty() && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.modifiedClasses())).isEmpty();
            }
            {
                this.converter$2 = converter$2;
                this.modifiedLibraries = (VirtualFileRef[])initialChanges$1.libraryDeps().toArray(ClassTag$.MODULE$.apply(VirtualFileRef.class));
                this.modifiedClasses = (String[])initialChanges$1.external().allModified().toArray(ClassTag$.MODULE$.apply(String.class));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$modifiedBinaries$1(sbt.internal.inc.Incremental$$anon$1 xsbti.VirtualFileRef )}, serializedLambda);
            }
        };
        Tuple2<scala.collection.immutable.Set<String>, scala.collection.immutable.Set<VirtualFileRef>> tuple2 = incremental.invalidateInitial(previous.relations(), initialChanges);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        scala.collection.immutable.Set initialInvClasses = (scala.collection.immutable.Set)tuple2._1();
        scala.collection.immutable.Set initialInvSources0 = (scala.collection.immutable.Set)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)initialInvClasses, (Object)initialInvSources0);
        scala.collection.immutable.Set initialInvClasses2 = (scala.collection.immutable.Set)tuple22._1();
        scala.collection.immutable.Set initialInvSources02 = (scala.collection.immutable.Set)tuple22._2();
        scala.collection.immutable.Set javaSources = (scala.collection.immutable.Set)sources.collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends VirtualFile, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1;
                A1 A12 = x1;
                if (A12 != null && (A1 = A12).id().endsWith(".java")) {
                    return (B1)A1;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(VirtualFile x1) {
                VirtualFile virtualFile;
                VirtualFile virtualFile2 = x1;
                return virtualFile2 != null && (virtualFile = virtualFile2).id().endsWith(".java");
            }
        }, scala.collection.immutable.Set$.MODULE$.canBuildFrom());
        String[] scalacOptions = currentSetup.options().scalacOptions();
        Option<Path> earlyJar = this.extractEarlyJar(earlyOutput);
        boolean isPickleWrite = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])scalacOptions)).contains((Object)"-Ypickle-write");
        if (earlyOutput.isDefined() || isPickleWrite) {
            Option option;
            int idx = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])scalacOptions)).indexOf((Object)"-Ypickle-write");
            Object object = !isPickleWrite || new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])scalacOptions)).size() <= idx + 1 ? None$.MODULE$ : new Some((Object)Paths.get(scalacOptions[idx + 1], new String[0]));
            Tuple2 tuple23 = new Tuple2(object, earlyJar);
            if (tuple23 != null && None$.MODULE$.equals(option = (Option)tuple23._1())) {
                if (isPickleWrite) {
                    log.warn((Function0 & Serializable & scala.Serializable)() -> "expected -Ypickle-write <path> but <path> is missing");
                } else {
                    log.warn((Function0 & Serializable & scala.Serializable)() -> "-Ypickle-write should be included into scalacOptions if early output is defined");
                }
            } else {
                if (tuple23 == null) throw package$.MODULE$.error(new StringBuilder(65).append("early output must match -Ypickle-write path '").append(object).append("' but was '").append(earlyJar).append("' instead").toString());
                Option x1 = (Option)tuple23._1();
                Option x2 = (Option)tuple23._2();
                Option option2 = x1;
                Option option3 = x2;
                if (option2 != null ? !option2.equals(option3) : option3 != null) throw package$.MODULE$.error(new StringBuilder(65).append("early output must match -Ypickle-write path '").append(object).append("' but was '").append(earlyJar).append("' instead").toString());
            }
        }
        boolean pickleJava = this.isPickleJava((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])scalacOptions));
        boolean bl = hasModified = initialInvClasses2.nonEmpty() || initialInvSources02.nonEmpty();
        if (javaSources.nonEmpty() && earlyOutput.isDefined() && !pickleJava) {
            log.warn((Function0 & Serializable & scala.Serializable)() -> "-Ypickle-java should be included into scalacOptions if early output is enabled with Java sources");
        }
        scala.collection.immutable.Set set = initialInvSources = pickleJava && hasModified ? (scala.collection.immutable.Set)initialInvSources02.$plus$plus((GenTraversableOnce)javaSources) : initialInvSources02;
        if (hasModified) {
            scala.collection.immutable.Set set2 = initialInvSources;
            scala.collection.immutable.Set<VirtualFile> set3 = sources;
            if (!(set2 != null ? !set2.equals(set3) : set3 != null)) {
                incremental.log().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("all ").append(initialInvSources.size()).append(" sources are invalidated").toString());
            } else {
                incremental.log().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(71).append("All initially invalidated classes: ").append(initialInvClasses2).append("\n").append("All initially invalidated sources:").append(initialInvSources).append("\n").toString());
            }
        }
        boolean hasSubprojectChange = initialChanges.external().apiChanges().nonEmpty();
        Analysis analysis2 = (Analysis)this.withClassfileManager(options, converter, output, outputJarContent, (Function1 & Serializable & scala.Serializable)classfileManager -> {
            Analysis analysis;
            block3: {
                Analysis analysis2;
                if (hasModified) {
                    return incremental.cycle((scala.collection.immutable.Set<String>)initialInvClasses2, (scala.collection.immutable.Set<VirtualFileRef>)initialInvSources, sources, converter, binaryChanges, lookup, previous, MODULE$.doCompile(compile, callbackBuilder, (ClassFileManager)classfileManager), (ClassFileManager)classfileManager, output, 1);
                }
                if (hasSubprojectChange) {
                    APIs x$1 = (APIs)initialChanges.external().allModified().foldLeft((Object)previous.apis(), (Function2 & Serializable & scala.Serializable)(apis, clazz) -> {
                        Option<AnalyzedClass> option = lookup.lookupAnalyzedClass((String)clazz, (Option<VirtualFileRef>)None$.MODULE$);
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            AnalyzedClass ac = (AnalyzedClass)some.value();
                            return apis.markExternalAPI((String)clazz, ac);
                        }
                        return apis;
                    });
                    Stamps x$2 = previous.copy$default$1();
                    Relations x$3 = previous.copy$default$3();
                    SourceInfos x$4 = previous.copy$default$4();
                    Compilations x$5 = previous.copy$default$5();
                    analysis2 = previous.copy(x$2, x$1, x$3, x$4, x$5);
                } else {
                    analysis2 = analysis = previous;
                }
                if (!earlyOutput.isDefined()) break block3;
                MODULE$.writeEarlyOut(lookup, progress, earlyOutput, analysis, new HashSet<String>(), log);
            }
            return analysis;
        });
        return new Tuple2((Object)BoxesRunTime.boxToBoolean((hasModified || hasSubprojectChange ? 1 : 0) != 0), (Object)analysis2);
    }

    public Incremental.CompileCycle doCompile(Function4<scala.collection.immutable.Set<VirtualFile>, DependencyChanges, xsbti.AnalysisCallback, ClassFileManager, BoxedUnit> compile, AnalysisCallback.Builder callbackBuilder, ClassFileManager classFileManager) {
        return new Incremental.CompileCycle(callbackBuilder, compile, classFileManager){
            private final AnalysisCallback.Builder callbackBuilder$2;
            private final Function4 compile$3;
            private final ClassFileManager classFileManager$2;

            public Incremental.CompileCycleResult run(scala.collection.immutable.Set<VirtualFile> srcs, DependencyChanges changes, Incremental.IncrementalCallback incHandler) {
                AnalysisCallback callback = this.callbackBuilder$2.build(incHandler);
                this.compile$3.apply(srcs, (Object)changes, (Object)callback, (Object)this.classFileManager$2);
                return callback.getCycleResultOnce();
            }
            {
                this.callbackBuilder$2 = callbackBuilder$2;
                this.compile$3 = compile$3;
                this.classFileManager$2 = classFileManager$2;
            }
        };
    }

    public String incDebugProp() {
        return this.incDebugProp;
    }

    public String apiDebugProp() {
        return this.apiDebugProp;
    }

    public boolean apiDebug(IncOptions options) {
        return options.apiDebug() || Boolean.getBoolean(this.apiDebugProp());
    }

    public Analysis prune(scala.collection.immutable.Set<VirtualFile> invalidatedSrcs, CompileAnalysis previous0, Output output, JarUtils.OutputJarContent outputJarContent, FileConverter converter, IncOptions incOptions) {
        Analysis previous = (Analysis)previous0;
        return IncrementalCommon$.MODULE$.pruneClassFilesOfInvalidations(invalidatedSrcs, previous, ClassFileManager$.MODULE$.deleteImmediately(output, outputJarContent, incOptions.auxiliaryClassFiles()), converter);
    }

    public <T> T withClassfileManager(IncOptions options, FileConverter converter, Output output, JarUtils.OutputJarContent outputJarContent, Function1<ClassFileManager, T> run) {
        Object object;
        ClassFileManager classfileManager = ClassFileManager$.MODULE$.getClassFileManager(options, output, outputJarContent);
        try {
            object = run.apply((Object)classfileManager);
        }
        catch (Throwable e) {
            classfileManager.complete(false);
            throw e;
        }
        Object result = object;
        classfileManager.complete(true);
        return (T)result;
    }

    public void writeEarlyOut(Lookup lookup, Option<CompileProgress> progress, Option<Output> earlyOutput, Analysis analysis, java.util.Set<String> knownProducts, Logger log) {
        earlyOutput.foreach((Function1 & Serializable & scala.Serializable)earlyO -> {
            Incremental$.$anonfun$writeEarlyOut$1(knownProducts, log, progress, lookup, analysis, earlyO);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$apply$5(Function4 compile$1, AdaptedRunProfiler runProfiler$1, scala.collection.immutable.Set vs, DependencyChanges depCh, xsbti.AnalysisCallback cb, ClassFileManager cfm) {
        long startTime = System.nanoTime();
        compile$1.apply((Object)vs, (Object)depCh, (Object)cb, (Object)cfm);
        runProfiler$1.timeCompilation(startTime, System.nanoTime() - startTime);
    }

    private static final Analysis completeCycle$1(Analysis partialAnalysis, Analysis previous$2, FileConverter converter$1, ClassFileManager classFileManager$1) {
        Analysis a1 = previous$2.$plus$plus(partialAnalysis);
        Set products = (Set)partialAnalysis.relations().allProducts().map((Function1 & Serializable & scala.Serializable)x$5 -> converter$1.toVirtualFile(x$5), Set$.MODULE$.canBuildFrom());
        classFileManager$1.generated((VirtualFile[])products.toArray(ClassTag$.MODULE$.apply(VirtualFile.class)));
        return a1;
    }

    public static final /* synthetic */ void $anonfun$writeEarlyOut$2(java.util.Set knownProducts$1, Logger log$2, Option progress$2, Lookup lookup$4, Analysis analysis$1, Path pickleJar) {
        PickleJar$.MODULE$.write(pickleJar, knownProducts$1, log$2);
        progress$2.foreach((Function1 & Serializable & scala.Serializable)x$8 -> {
            x$8.afterEarlyOutput(lookup$4.shouldDoEarlyOutput(analysis$1));
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$writeEarlyOut$1(java.util.Set knownProducts$1, Logger log$2, Option progress$2, Lookup lookup$4, Analysis analysis$1, Output earlyO) {
        InterfaceUtil$.MODULE$.jo2o(earlyO.getSingleOutputAsPath()).foreach((Function1 & Serializable & scala.Serializable)pickleJar -> {
            Incremental$.$anonfun$writeEarlyOut$2(knownProducts$1, log$2, progress$2, lookup$4, analysis$1, pickleJar);
            return BoxedUnit.UNIT;
        });
    }

    private Incremental$() {
        MODULE$ = this;
        this.incDebugProp = "xsbt.inc.debug";
        this.apiDebugProp = "xsbt.api.debug";
    }
}

