/*
 * Decompiled with CFR 0.152.
 */
package com.sourcegraph.semanticdb_javac;

import com.sourcegraph.semanticdb_javac.GlobalSymbolsCache;
import com.sourcegraph.semanticdb_javac.LocalSymbolsCache;
import com.sourcegraph.semanticdb_javac.Semanticdb;
import com.sourcegraph.semanticdb_javac.SemanticdbBuilders;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.List;
import java.util.ArrayList;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.IntersectionType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.SimpleTypeVisitor8;

class SemanticdbTypeVisitor
extends SimpleTypeVisitor8<Semanticdb.Type, Void> {
    static final Semanticdb.Type UNRESOLVED_TYPE_REF = SemanticdbBuilders.typeRef("unresolved_type#");
    static final String ARRAY_SYMBOL = "scala/Array#";
    private final GlobalSymbolsCache cache;
    private final LocalSymbolsCache locals;

    SemanticdbTypeVisitor(GlobalSymbolsCache cache, LocalSymbolsCache locals) {
        this.cache = cache;
        this.locals = locals;
    }

    public Semanticdb.Type semanticdbType(TypeMirror tpe) {
        Semanticdb.Type result = (Semanticdb.Type)super.visit(tpe);
        return result == null ? UNRESOLVED_TYPE_REF : result;
    }

    @Override
    public Semanticdb.Type visitDeclared(DeclaredType t, Void unused) {
        boolean isExistential = t.getTypeArguments().stream().anyMatch(type -> type instanceof WildcardType);
        ArrayList<Semanticdb.Type> typeParams = new ArrayList<Semanticdb.Type>();
        Semanticdb.Scope.Builder declarations = Semanticdb.Scope.newBuilder();
        for (TypeMirror typeMirror : t.getTypeArguments()) {
            typeParams.add(this.semanticdbType(typeMirror));
            if (typeMirror instanceof WildcardType) {
                Semanticdb.TypeSignature.Builder typeSig = Semanticdb.TypeSignature.newBuilder();
                WildcardType wildcardType = (WildcardType)typeMirror;
                typeSig.setTypeParameters(Semanticdb.Scope.newBuilder());
                if (wildcardType.getExtendsBound() != null) {
                    typeSig.setUpperBound((Semanticdb.Type)super.visit(wildcardType.getExtendsBound()));
                } else if (wildcardType.getSuperBound() != null) {
                    typeSig.setLowerBound((Semanticdb.Type)super.visit(wildcardType.getSuperBound()));
                }
                declarations.addHardlinks(Semanticdb.SymbolInformation.newBuilder().setSymbol("local_wildcard").setSignature(Semanticdb.Signature.newBuilder().setTypeSignature(typeSig)));
                continue;
            }
            declarations.addSymlinks(this.cache.semanticdbSymbol(((Type)typeMirror).asElement(), this.locals));
        }
        if (!isExistential) {
            return SemanticdbBuilders.typeRef(this.cache.semanticdbSymbol(t.asElement(), this.locals), typeParams);
        }
        return SemanticdbBuilders.existentialType(SemanticdbBuilders.typeRef(this.cache.semanticdbSymbol(t.asElement(), this.locals), typeParams), declarations.build());
    }

    @Override
    public Semanticdb.Type visitArray(ArrayType t, Void unused) {
        return SemanticdbBuilders.typeRef(ARRAY_SYMBOL, List.of(this.semanticdbType(t.getComponentType())));
    }

    @Override
    public Semanticdb.Type visitPrimitive(PrimitiveType t, Void unused) {
        return SemanticdbBuilders.typeRef(this.primitiveSymbol(t.getKind()));
    }

    @Override
    public Semanticdb.Type visitTypeVariable(TypeVariable t, Void unused) {
        return SemanticdbBuilders.typeRef(this.cache.semanticdbSymbol(t.asElement(), this.locals));
    }

    @Override
    public Semanticdb.Type visitIntersection(IntersectionType t, Void unused) {
        ArrayList types = new ArrayList();
        for (TypeMirror typeMirror : t.getBounds()) {
            types.add(super.visit(typeMirror));
        }
        return SemanticdbBuilders.intersectionType(types);
    }

    @Override
    public Semanticdb.Type visitWildcard(WildcardType t, Void unused) {
        return SemanticdbBuilders.typeRef("local_wildcard");
    }

    @Override
    public Semanticdb.Type visitNoType(NoType t, Void unused) {
        return SemanticdbBuilders.typeRef(this.primitiveSymbol(t.getKind()));
    }

    public String primitiveSymbol(TypeKind kind) {
        switch (kind) {
            case BOOLEAN: {
                return "scala/Boolean#";
            }
            case BYTE: {
                return "scala/Byte#";
            }
            case SHORT: {
                return "scala/Short#";
            }
            case INT: {
                return "scala/Int#";
            }
            case LONG: {
                return "scala/Long#";
            }
            case CHAR: {
                return "scala/Char#";
            }
            case FLOAT: {
                return "scala/Float#";
            }
            case DOUBLE: {
                return "scala/Double#";
            }
            case VOID: {
                return "scala/Unit#";
            }
        }
        throw new IllegalArgumentException("got " + kind.name());
    }
}

