/*
 * Decompiled with CFR 0.152.
 */
package com.sourcegraph.semanticdb_javac;

import com.sourcegraph.semanticdb_javac.GlobalSymbolsCache;
import com.sourcegraph.semanticdb_javac.LocalSymbolsCache;
import com.sourcegraph.semanticdb_javac.Semanticdb;
import com.sourcegraph.semanticdb_javac.SemanticdbBuilders;
import com.sourcegraph.semanticdb_javac.SemanticdbTypeVisitor;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class SemanticdbTrees {
    private final GlobalSymbolsCache globals;
    private final LocalSymbolsCache locals;
    private final String semanticdbUri;

    public SemanticdbTrees(GlobalSymbolsCache globals, LocalSymbolsCache locals, String semanticdbUri) {
        this.globals = globals;
        this.locals = locals;
        this.semanticdbUri = semanticdbUri;
    }

    public List<Semanticdb.AnnotationTree> annotations(JCTree node) {
        if (!(node instanceof JCTree.JCClassDecl || node instanceof JCTree.JCVariableDecl || node instanceof JCTree.JCMethodDecl)) {
            return null;
        }
        ArrayList<Semanticdb.AnnotationTree> annotations = new ArrayList<Semanticdb.AnnotationTree>();
        JCTree.JCModifiers mods = node instanceof JCTree.JCClassDecl ? ((JCTree.JCClassDecl)node).getModifiers() : (node instanceof JCTree.JCMethodDecl ? ((JCTree.JCMethodDecl)node).getModifiers() : ((JCTree.JCVariableDecl)node).getModifiers());
        for (JCTree.JCAnnotation annotation : mods.getAnnotations()) {
            annotations.add(this.annotationBuilder(annotation));
        }
        return annotations;
    }

    private Semanticdb.AnnotationTree annotationBuilder(JCTree.JCAnnotation annotation) {
        ArrayList<Semanticdb.Tree> params = new ArrayList<Semanticdb.Tree>(annotation.args.size());
        for (JCTree.JCExpression param : annotation.args) {
            if (param instanceof JCTree.JCAssign) {
                JCTree.JCAssign assign = (JCTree.JCAssign)param;
                JCTree.JCExpression assignValue = assign.rhs;
                String symbol = this.globals.semanticdbSymbol(((JCTree.JCIdent)assign.lhs).sym, this.locals);
                params.add(SemanticdbBuilders.tree(SemanticdbBuilders.assignTree(SemanticdbBuilders.tree(SemanticdbBuilders.idTree(symbol)), this.annotationParameter(assignValue))));
                continue;
            }
            params.add(this.annotationParameter(param));
        }
        Semanticdb.Type type = new SemanticdbTypeVisitor(this.globals, this.locals).semanticdbType(annotation.type);
        return SemanticdbBuilders.annotationTree(type, params);
    }

    /*
     * Enabled aggressive block sorting
     */
    private Semanticdb.Tree annotationParameter(JCTree.JCExpression expr) {
        if (expr instanceof JCTree.JCFieldAccess) {
            JCTree.JCFieldAccess rhs = (JCTree.JCFieldAccess)expr;
            return SemanticdbBuilders.tree(SemanticdbBuilders.selectTree(SemanticdbBuilders.tree(SemanticdbBuilders.idTree(this.globals.semanticdbSymbol(rhs.sym.owner, this.locals))), SemanticdbBuilders.idTree(this.globals.semanticdbSymbol(rhs.sym, this.locals))));
        }
        if (expr instanceof JCTree.JCNewArray) {
            JCTree.JCNewArray rhs = (JCTree.JCNewArray)expr;
            return SemanticdbBuilders.tree(SemanticdbBuilders.applyTree(SemanticdbBuilders.tree(SemanticdbBuilders.idTree("scala/Array#")), rhs.elems.stream().map(this::annotationParameter).collect(Collectors.toList())));
        }
        if (expr instanceof JCTree.JCLiteral) {
            JCTree.JCLiteral rhs = (JCTree.JCLiteral)expr;
            if (rhs.type instanceof Type.JCPrimitiveType) {
                Type.JCPrimitiveType type = (Type.JCPrimitiveType)rhs.type;
                switch (type.getKind()) {
                    case BOOLEAN: {
                        boolean bl;
                        if ((Integer)rhs.value == 1) {
                            bl = true;
                            return SemanticdbBuilders.tree(SemanticdbBuilders.literalTree(SemanticdbBuilders.booleanConst(bl)));
                        }
                        bl = false;
                        return SemanticdbBuilders.tree(SemanticdbBuilders.literalTree(SemanticdbBuilders.booleanConst(bl)));
                    }
                    case BYTE: {
                        return SemanticdbBuilders.tree(SemanticdbBuilders.literalTree(SemanticdbBuilders.byteConst((Byte)rhs.value)));
                    }
                    case SHORT: {
                        return SemanticdbBuilders.tree(SemanticdbBuilders.literalTree(SemanticdbBuilders.shortConst((Short)rhs.value)));
                    }
                    case INT: {
                        return SemanticdbBuilders.tree(SemanticdbBuilders.literalTree(SemanticdbBuilders.intConst((Integer)rhs.value)));
                    }
                    case LONG: {
                        return SemanticdbBuilders.tree(SemanticdbBuilders.literalTree(SemanticdbBuilders.longConst((Long)rhs.value)));
                    }
                    case CHAR: {
                        return SemanticdbBuilders.tree(SemanticdbBuilders.literalTree(SemanticdbBuilders.charConst(Character.valueOf(Character.forDigit((Integer)rhs.value, 10)))));
                    }
                    case FLOAT: {
                        return SemanticdbBuilders.tree(SemanticdbBuilders.literalTree(SemanticdbBuilders.floatConst((Float)rhs.value)));
                    }
                    case DOUBLE: {
                        return SemanticdbBuilders.tree(SemanticdbBuilders.literalTree(SemanticdbBuilders.doubleConst((Double)rhs.value)));
                    }
                }
                throw new IllegalArgumentException(this.semanticdbUri + ": annotation parameter rhs was of unexpected tree node type " + expr.getClass() + "\n" + expr);
            }
            if (rhs.type instanceof Type.ClassType) {
                if (!(rhs.value instanceof String)) throw new IllegalStateException(this.semanticdbUri + ": annotation parameter rhs was of unexpected class type " + rhs.value.getClass() + "\n" + rhs.value);
                return SemanticdbBuilders.tree(SemanticdbBuilders.literalTree(SemanticdbBuilders.stringConst((String)rhs.value)));
            }
            if (!(rhs.type instanceof Type.UnknownType)) throw new IllegalStateException(this.semanticdbUri + ": annotation parameter rhs was of unexpected type " + rhs.type.getClass() + "\n" + rhs.type + " " + rhs);
            return SemanticdbBuilders.tree(SemanticdbBuilders.literalTree(SemanticdbBuilders.stringConst("UNRESOLVED")));
        }
        if (expr instanceof JCTree.JCAnnotation) {
            return SemanticdbBuilders.tree(this.annotationBuilder((JCTree.JCAnnotation)expr));
        }
        if (expr instanceof JCTree.JCIdent) {
            return SemanticdbBuilders.tree(SemanticdbBuilders.idTree(this.globals.semanticdbSymbol(((JCTree.JCIdent)expr).sym, this.locals)));
        }
        if (!(expr instanceof JCTree.JCBinary)) throw new IllegalArgumentException(this.semanticdbUri + ": annotation parameter rhs was of unexpected tree node type " + expr.getClass() + "\n" + expr);
        JCTree.JCBinary binExpr = (JCTree.JCBinary)expr;
        return SemanticdbBuilders.tree(SemanticdbBuilders.binopTree(this.annotationParameter(binExpr.lhs), this.semanticdbBinaryOperator(expr.getKind()), this.annotationParameter(binExpr.rhs)));
    }

    private Semanticdb.BinaryOperator semanticdbBinaryOperator(Tree.Kind kind) {
        switch (kind) {
            case PLUS: {
                return Semanticdb.BinaryOperator.PLUS;
            }
            case MINUS: {
                return Semanticdb.BinaryOperator.MINUS;
            }
            case MULTIPLY: {
                return Semanticdb.BinaryOperator.MULTIPLY;
            }
            case DIVIDE: {
                return Semanticdb.BinaryOperator.DIVIDE;
            }
            case REMAINDER: {
                return Semanticdb.BinaryOperator.REMAINDER;
            }
            case LESS_THAN: {
                return Semanticdb.BinaryOperator.LESS_THAN;
            }
            case GREATER_THAN: {
                return Semanticdb.BinaryOperator.GREATER_THAN;
            }
            case LEFT_SHIFT: {
                return Semanticdb.BinaryOperator.SHIFT_LEFT;
            }
            case RIGHT_SHIFT: {
                return Semanticdb.BinaryOperator.SHIFT_RIGHT;
            }
            case UNSIGNED_RIGHT_SHIFT: {
                return Semanticdb.BinaryOperator.SHIFT_RIGHT_UNSIGNED;
            }
            case EQUAL_TO: {
                return Semanticdb.BinaryOperator.EQUAL_TO;
            }
            case NOT_EQUAL_TO: {
                return Semanticdb.BinaryOperator.NOT_EQUAL_TO;
            }
            case LESS_THAN_EQUAL: {
                return Semanticdb.BinaryOperator.LESS_THAN_EQUAL;
            }
            case GREATER_THAN_EQUAL: {
                return Semanticdb.BinaryOperator.GREATER_THAN_EQUAL;
            }
            case CONDITIONAL_AND: {
                return Semanticdb.BinaryOperator.CONDITIONAL_AND;
            }
            case CONDITIONAL_OR: {
                return Semanticdb.BinaryOperator.CONDITIONAL_OR;
            }
            case AND: {
                return Semanticdb.BinaryOperator.AND;
            }
            case OR: {
                return Semanticdb.BinaryOperator.OR;
            }
            case XOR: {
                return Semanticdb.BinaryOperator.XOR;
            }
        }
        throw new IllegalStateException(this.semanticdbUri + ": unexpected binary expression operator kind " + (Object)((Object)kind));
    }
}

