/*
 * Decompiled with CFR 0.152.
 */
package com.martiansoftware.nailgun;

import com.martiansoftware.nailgun.NGServer;
import com.martiansoftware.nailgun.NGSession;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;

class NGSessionPool {
    final Queue<NGSession> idlePool;
    final Set<NGSession> workingPool;
    int maxIdleSessions;
    Logger logger;
    final NGServer server;
    boolean done = false;
    private final Object lock = new Object();

    NGSessionPool(NGServer nGServer, int n, Logger logger) {
        this.logger = logger;
        this.server = nGServer;
        this.maxIdleSessions = Math.max(0, n);
        this.idlePool = new LinkedList<NGSession>();
        this.workingPool = new HashSet<NGSession>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NGSession take() {
        Object object = this.lock;
        synchronized (object) {
            if (this.done) {
                throw new UnsupportedOperationException("NGSession pool is shutting down");
            }
            NGSession nGSession = this.idlePool.poll();
            if (nGSession == null) {
                nGSession = new NGSession(this, this.server, this.logger);
                nGSession.start();
            }
            this.workingPool.add(nGSession);
            return nGSession;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void give(NGSession nGSession) {
        Object object = this.lock;
        synchronized (object) {
            if (this.done) {
                return;
            }
            this.workingPool.remove(nGSession);
            if (this.idlePool.size() < this.maxIdleSessions) {
                this.idlePool.add(nGSession);
                return;
            }
        }
        nGSession.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdown() throws InterruptedException {
        List list;
        Iterator iterator = this.lock;
        synchronized (iterator) {
            this.done = true;
            list = Stream.concat(this.workingPool.stream(), this.idlePool.stream()).collect(Collectors.toList());
            this.idlePool.clear();
            this.workingPool.clear();
        }
        for (NGSession nGSession : list) {
            nGSession.shutdown();
        }
        long l = System.nanoTime();
        for (NGSession nGSession : list) {
            long l2 = 30000L - TimeUnit.NANOSECONDS.convert(System.nanoTime() - l, TimeUnit.MILLISECONDS);
            if (l2 < 1L) {
                l2 = 1L;
            }
            nGSession.join(l2);
            if (!nGSession.isAlive()) continue;
            throw new IllegalStateException("NGSession has not completed in 30000 ms");
        }
    }
}

