/*
 * Decompiled with CFR 0.152.
 */
package com.martiansoftware.nailgun;

import com.martiansoftware.nailgun.Alias;
import com.martiansoftware.nailgun.CommandContext;
import com.martiansoftware.nailgun.NGCommunicator;
import com.martiansoftware.nailgun.NGContext;
import com.martiansoftware.nailgun.NGExitException;
import com.martiansoftware.nailgun.NGInputStream;
import com.martiansoftware.nailgun.NGOutputStream;
import com.martiansoftware.nailgun.NGServer;
import com.martiansoftware.nailgun.NGSessionPool;
import com.martiansoftware.nailgun.NonStaticNail;
import com.martiansoftware.nailgun.ThreadLocalInputStream;
import com.martiansoftware.nailgun.ThreadLocalPrintStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Socket;
import java.net.SocketException;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;

public class NGSession
extends Thread {
    private Logger LOG;
    private final NGServer server;
    private final NGSessionPool sessionPool;
    private final Object lock = new Object();
    private Socket nextSocket = null;
    private boolean done = false;
    private final long instanceNumber;
    private final int heartbeatTimeoutMillis;
    private static AtomicLong instanceCounter = new AtomicLong(0L);
    private static final Class[] mainSignature = new Class[]{String[].class};
    private static final Class[] nailMainSignature = new Class[]{NGContext.class};
    public static volatile ClassLoader classLoader = null;

    NGSession(NGSessionPool nGSessionPool, NGServer nGServer, Logger logger) {
        this.LOG = logger;
        this.sessionPool = nGSessionPool;
        this.server = nGServer;
        this.heartbeatTimeoutMillis = nGServer.getHeartbeatTimeout();
        this.instanceNumber = instanceCounter.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdown() {
        Object object = this.lock;
        synchronized (object) {
            this.done = true;
            this.nextSocket = null;
            this.lock.notifyAll();
        }
        this.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Socket socket) {
        Object object = this.lock;
        synchronized (object) {
            this.nextSocket = socket;
            this.lock.notify();
        }
        Thread.yield();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Socket nextSocket() {
        Socket socket;
        Object object = this.lock;
        synchronized (object) {
            socket = this.nextSocket;
            while (!this.done && socket == null) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException interruptedException) {
                    this.done = true;
                }
                socket = this.nextSocket;
            }
            this.nextSocket = null;
        }
        if (socket != null) {
            try {
                socket.setSoTimeout(this.heartbeatTimeoutMillis);
            }
            catch (SocketException socketException) {
                return null;
            }
        }
        return socket;
    }

    @Override
    public void run() {
        this.updateThreadName(null);
        this.LOG.debug("Waiting for first client to connect");
        Socket socket = this.nextSocket();
        while (socket != null) {
            block69: {
                this.LOG.debug("Client connected");
                try (NGCommunicator nGCommunicator = new NGCommunicator(socket, this.heartbeatTimeoutMillis, this.LOG);){
                    CommandContext commandContext = nGCommunicator.readCommandContext();
                    String string = socket.getInetAddress() != null ? socket.getInetAddress().getHostAddress() + ": " + commandContext.getCommand() : commandContext.getCommand();
                    this.updateThreadName(string);
                    try (NGInputStream nGInputStream = new NGInputStream(nGCommunicator);
                         PrintStream printStream = new PrintStream(new NGOutputStream(nGCommunicator, 49));
                         PrintStream printStream2 = new PrintStream(new NGOutputStream(nGCommunicator, 50));){
                        ((ThreadLocalInputStream)System.in).init(nGInputStream);
                        ((ThreadLocalPrintStream)System.out).init(printStream);
                        ((ThreadLocalPrintStream)System.err).init(printStream2);
                        try {
                            Alias alias = this.server.getAliasManager().getAlias(commandContext.getCommand());
                            Class<Object> clazz = alias != null ? alias.getAliasedClass() : (this.server.allowsNailsByClassName() ? Class.forName(commandContext.getCommand(), true, classLoader) : this.server.getDefaultNailClass());
                            Object[] objectArray = new Object[1];
                            Method method = null;
                            String[] stringArray = commandContext.getCommandArguments().toArray(new String[commandContext.getCommandArguments().size()]);
                            boolean bl = true;
                            Class<?>[] classArray = clazz.getInterfaces();
                            for (int i = 0; i < classArray.length; ++i) {
                                if (!classArray[i].equals(NonStaticNail.class)) continue;
                                bl = false;
                                break;
                            }
                            if (!bl) {
                                method = clazz.getMethod("nailMain", String[].class);
                                objectArray[0] = stringArray;
                            } else {
                                try {
                                    method = clazz.getMethod("nailMain", nailMainSignature);
                                    NGContext nGContext = new NGContext();
                                    nGContext.setArgs(stringArray);
                                    nGContext.in = nGInputStream;
                                    nGContext.out = printStream;
                                    nGContext.err = printStream2;
                                    nGContext.setCommand(commandContext.getCommand());
                                    nGContext.setNGServer(this.server);
                                    nGContext.setCommunicator(nGCommunicator);
                                    nGContext.setEnv(commandContext.getEnvironmentVariables());
                                    nGContext.setInetAddress(socket.getInetAddress());
                                    nGContext.setPort(socket.getPort());
                                    nGContext.setWorkingDirectory(commandContext.getWorkingDirectory());
                                    objectArray[0] = nGContext;
                                }
                                catch (NoSuchMethodException noSuchMethodException) {
                                    // empty catch block
                                }
                                if (method == null) {
                                    method = clazz.getMethod("main", mainSignature);
                                    objectArray[0] = stringArray;
                                }
                            }
                            if (method == null) break block69;
                            this.server.nailStarted(clazz);
                            try {
                                if (bl) {
                                    method.invoke(null, objectArray);
                                } else {
                                    method.invoke(clazz.newInstance(), objectArray);
                                }
                            }
                            catch (InvocationTargetException invocationTargetException) {
                                throw invocationTargetException.getCause();
                            }
                            finally {
                                this.server.nailFinished(clazz);
                            }
                            nGCommunicator.exit(0);
                        }
                        catch (NGExitException nGExitException) {
                            this.LOG.info("Nail cleanly exited with status {0}", (Object)nGExitException.getStatus());
                            nGCommunicator.exit(nGExitException.getStatus());
                        }
                        catch (Throwable throwable) {
                            this.LOG.info("Nail raised unhandled exception", throwable);
                            nGCommunicator.exit(899);
                        }
                    }
                }
                catch (Throwable throwable) {
                    this.LOG.warn("Internal error in session", throwable);
                    throwable.printStackTrace();
                }
            }
            ((ThreadLocalInputStream)System.in).init(null);
            ((ThreadLocalPrintStream)System.out).init(null);
            ((ThreadLocalPrintStream)System.err).init(null);
            this.updateThreadName(null);
            this.sessionPool.give(this);
            this.LOG.debug("Closing client socket");
            try {
                socket.close();
            }
            catch (Throwable throwable) {
                this.LOG.warn("Internal error closing socket", throwable);
            }
            this.LOG.debug("Waiting for next client to connect");
            socket = this.nextSocket();
        }
        this.LOG.info("NGSession shutting down");
    }

    private void updateThreadName(String string) {
        this.setName("NGSession " + this.instanceNumber + ": " + (string == null ? "(idle)" : string));
    }

    static {
        classLoader = NGSession.class.getClassLoader();
    }
}

