/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.protocol;

import com.microsoft.java.debug.core.protocol.Types;

public class Events {

    public static class InvalidatedEvent
    extends DebugEvent {
        public InvalidatedAreas[] areas;
        public long threadId;
        public int frameId;

        public InvalidatedEvent() {
            super("invalidated");
        }

        public InvalidatedEvent(InvalidatedAreas invalidatedAreas) {
            super("invalidated");
            this.areas = new InvalidatedAreas[]{invalidatedAreas};
        }

        public InvalidatedEvent(InvalidatedAreas invalidatedAreas, long l) {
            super("invalidated");
            this.areas = new InvalidatedAreas[]{invalidatedAreas};
            this.threadId = l;
        }

        public InvalidatedEvent(InvalidatedAreas invalidatedAreas, int n) {
            super("invalidated");
            this.areas = new InvalidatedAreas[]{invalidatedAreas};
            this.frameId = n;
        }
    }

    public static enum InvalidatedAreas {
        ALL,
        STACKS,
        THREADS,
        VARIABLES;

    }

    public static class UserNotificationEvent
    extends DebugEvent {
        public NotificationType notificationType;
        public String message;

        public UserNotificationEvent(NotificationType notificationType, String string) {
            super("usernotification");
            this.notificationType = notificationType;
            this.message = string;
        }

        public static enum NotificationType {
            ERROR,
            WARNING,
            INFORMATION;

        }
    }

    public static class HotCodeReplaceEvent
    extends DebugEvent {
        public ChangeType changeType;
        public String message;

        public HotCodeReplaceEvent(ChangeType changeType, String string) {
            super("hotcodereplace");
            this.changeType = changeType;
            this.message = string;
        }

        public static enum ChangeType {
            ERROR,
            WARNING,
            STARTING,
            END,
            BUILD_COMPLETE;

        }
    }

    public static class BreakpointEvent
    extends DebugEvent {
        public String reason;
        public Types.Breakpoint breakpoint;

        public BreakpointEvent(String string, Types.Breakpoint breakpoint) {
            super("breakpoint");
            this.reason = string;
            this.breakpoint = breakpoint;
        }
    }

    public static class OutputEvent
    extends DebugEvent {
        public Category category;
        public String output;
        public int variablesReference;
        public Types.Source source;
        public int line;
        public int column;
        public Object data;

        public OutputEvent(Category category, String string) {
            super("output");
            this.category = category;
            this.output = string;
        }

        public OutputEvent(Category category, String string, Types.Source source, int n) {
            super("output");
            this.category = category;
            this.output = string;
            this.source = source;
            this.line = n;
        }

        public static OutputEvent createConsoleOutput(String string) {
            return new OutputEvent(Category.console, string);
        }

        public static OutputEvent createStdoutOutput(String string) {
            return new OutputEvent(Category.stdout, string);
        }

        public static OutputEvent createStdoutOutputWithSource(String string, Types.Source source, int n) {
            return new OutputEvent(Category.stdout, string, source, n);
        }

        public static OutputEvent createStderrOutput(String string) {
            return new OutputEvent(Category.stderr, string);
        }

        public static OutputEvent createStderrOutputWithSource(String string, Types.Source source, int n) {
            return new OutputEvent(Category.stderr, string, source, n);
        }

        public static OutputEvent createTelemetryOutput(String string) {
            return new OutputEvent(Category.telemetry, string);
        }

        public static enum Category {
            console,
            stdout,
            stderr,
            telemetry;

        }
    }

    public static class ThreadEvent
    extends DebugEvent {
        public String reason;
        public long threadId;

        public ThreadEvent(String string, long l) {
            super("thread");
            this.reason = string;
            this.threadId = l;
        }
    }

    public static class TerminatedEvent
    extends DebugEvent {
        public boolean restart;

        public TerminatedEvent() {
            super("terminated");
        }

        public TerminatedEvent(boolean bl) {
            this();
            this.restart = bl;
        }
    }

    public static class ExitedEvent
    extends DebugEvent {
        public int exitCode;

        public ExitedEvent(int n) {
            super("exited");
            this.exitCode = n;
        }
    }

    public static class ContinuedEvent
    extends DebugEvent {
        public long threadId;
        public boolean allThreadsContinued;

        public ContinuedEvent(long l) {
            super("continued");
            this.threadId = l;
        }

        public ContinuedEvent(long l, boolean bl) {
            this(l);
            this.allThreadsContinued = bl;
        }

        public ContinuedEvent(boolean bl) {
            super("continued");
            this.allThreadsContinued = bl;
        }
    }

    public static class StoppedEvent
    extends DebugEvent {
        public long threadId;
        public String reason;
        public String description;
        public String text;
        public boolean allThreadsStopped;

        public StoppedEvent(String string, long l) {
            super("stopped");
            this.reason = string;
            this.threadId = l;
            this.allThreadsStopped = false;
        }

        public StoppedEvent(String string, long l, boolean bl) {
            this(string, l);
            this.allThreadsStopped = bl;
        }

        public StoppedEvent(String string, long l, boolean bl, String string2, String string3) {
            this(string, l, bl);
            this.description = string2;
            this.text = string3;
        }
    }

    public static class InitializedEvent
    extends DebugEvent {
        public InitializedEvent() {
            super("initialized");
        }
    }

    public static class DebugEvent {
        public String type;

        public DebugEvent(String string) {
            this.type = string;
        }
    }
}

