/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter.variables;

import com.microsoft.java.debug.core.adapter.IEvaluationProvider;
import com.microsoft.java.debug.core.adapter.variables.IVariableFormatter;
import com.sun.jdi.ClassType;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;

public class VariableDetailUtils {
    private static final String STRING_TYPE = "java.lang.String";
    private static final String TO_STRING_METHOD = "toString";
    private static final String TO_STRING_METHOD_SIGNATURE = "()Ljava/lang/String;";
    private static final String ENTRY_TYPE = "java.util.Map$Entry";
    private static final String GET_KEY_METHOD = "getKey";
    private static final String GET_KEY_METHOD_SIGNATURE = "()Ljava/lang/Object;";
    private static final String GET_VALUE_METHOD = "getValue";
    private static final String GET_VALUE_METHOD_SIGNATURE = "()Ljava/lang/Object;";
    private static final Set<String> COLLECTION_TYPES = new HashSet<String>(Arrays.asList("java.util.Map", "java.util.Collection", "java.util.Map$Entry"));

    public static String formatDetailsValue(Value value, ThreadReference threadReference, IVariableFormatter iVariableFormatter, Map<String, Object> map, IEvaluationProvider iEvaluationProvider) {
        if (VariableDetailUtils.isClassType(value, STRING_TYPE)) {
            return null;
        }
        return VariableDetailUtils.computeToStringValue(value, threadReference, iVariableFormatter, map, iEvaluationProvider, true);
    }

    private static String computeToStringValue(Value value, ThreadReference threadReference, IVariableFormatter iVariableFormatter, Map<String, Object> map, IEvaluationProvider iEvaluationProvider, boolean bl) {
        if (!(value instanceof ObjectReference) || iEvaluationProvider == null) {
            return null;
        }
        String string = VariableDetailUtils.findInheritedType(value, COLLECTION_TYPES);
        if (string != null) {
            if (Objects.equals(string, ENTRY_TYPE)) {
                try {
                    Value value2 = iEvaluationProvider.invokeMethod((ObjectReference)value, GET_KEY_METHOD, "()Ljava/lang/Object;", null, threadReference, false).get();
                    Value value3 = iEvaluationProvider.invokeMethod((ObjectReference)value, GET_VALUE_METHOD, "()Ljava/lang/Object;", null, threadReference, false).get();
                    String string2 = VariableDetailUtils.computeToStringValue(value2, threadReference, iVariableFormatter, map, iEvaluationProvider, false) + ":" + VariableDetailUtils.computeToStringValue(value3, threadReference, iVariableFormatter, map, iEvaluationProvider, false);
                    if (!bl) {
                        string2 = "\"" + string2 + "\"";
                    }
                    return string2;
                }
                catch (InterruptedException | ExecutionException exception) {}
            } else if (!bl) {
                return iVariableFormatter.valueToString(value, map);
            }
        } else if (VariableDetailUtils.containsToStringMethod((ObjectReference)value)) {
            try {
                Value value4 = iEvaluationProvider.invokeMethod((ObjectReference)value, TO_STRING_METHOD, TO_STRING_METHOD_SIGNATURE, null, threadReference, false).get();
                return iVariableFormatter.valueToString(value4, map);
            }
            catch (InterruptedException | ExecutionException exception) {
                // empty catch block
            }
        }
        return null;
    }

    private static boolean containsToStringMethod(ObjectReference objectReference) {
        ReferenceType referenceType = objectReference.referenceType();
        if (referenceType instanceof ClassType) {
            Method method = ((ClassType)referenceType).concreteMethodByName(TO_STRING_METHOD, TO_STRING_METHOD_SIGNATURE);
            if (method != null && !Objects.equals("Ljava/lang/Object;", method.declaringType().signature())) {
                return true;
            }
            for (InterfaceType interfaceType : ((ClassType)referenceType).allInterfaces()) {
                List<Method> list = interfaceType.methodsByName(TO_STRING_METHOD, TO_STRING_METHOD_SIGNATURE);
                for (Method method2 : list) {
                    if (method2.isAbstract()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static String findInheritedType(Value value, Set<String> set) {
        if (!(value instanceof ObjectReference)) {
            return null;
        }
        Type type = ((ObjectReference)value).type();
        if (!(type instanceof ClassType)) {
            return null;
        }
        for (ClassType classType = (ClassType)type; classType != null; classType = classType.superclass()) {
            if (!set.contains(classType.name())) continue;
            return classType.name();
        }
        List<InterfaceType> list = ((ClassType)type).allInterfaces();
        for (InterfaceType interfaceType : list) {
            if (!set.contains(interfaceType.name())) continue;
            return interfaceType.name();
        }
        return null;
    }

    private static boolean isClassType(Value value, String string) {
        if (!(value instanceof ObjectReference)) {
            return false;
        }
        return Objects.equals(((ObjectReference)value).type().name(), string);
    }
}

