/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter.variables;

import com.sun.jdi.ThreadReference;

public class StackFrameReference {
    private final int depth;
    private final int hash;
    private final ThreadReference thread;

    public StackFrameReference(ThreadReference threadReference, int n) {
        if (threadReference == null) {
            throw new NullPointerException("'thread' should not be null for StackFrameReference");
        }
        if (n < 0) {
            throw new IllegalArgumentException("'depth' should not be zero or an positive integer.");
        }
        this.thread = threadReference;
        this.depth = n;
        this.hash = Long.hashCode(threadReference.hashCode()) + n;
    }

    public int getDepth() {
        return this.depth;
    }

    public ThreadReference getThread() {
        return this.thread;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        StackFrameReference stackFrameReference = (StackFrameReference)object;
        return this.thread.equals(stackFrameReference.thread) && this.depth == stackFrameReference.depth;
    }
}

