/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter.variables;

import com.microsoft.java.debug.core.adapter.IEvaluationProvider;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;

public class JavaLogicalStructure {
    private final String type;
    private final String fullyQualifiedName;
    private final LogicalStructureExpression valueExpression;
    private final LogicalStructureExpression sizeExpression;
    private final LogicalVariable[] variables;
    private final boolean isInterface;

    public JavaLogicalStructure(String string, LogicalStructureExpression logicalStructureExpression, LogicalStructureExpression logicalStructureExpression2, LogicalVariable[] logicalVariableArray) {
        this(string, string, logicalStructureExpression, logicalStructureExpression2, logicalVariableArray);
    }

    public JavaLogicalStructure(String string, String string2, LogicalStructureExpression logicalStructureExpression, LogicalStructureExpression logicalStructureExpression2, LogicalVariable[] logicalVariableArray) {
        this(string, string, true, logicalStructureExpression, logicalStructureExpression2, logicalVariableArray);
    }

    public JavaLogicalStructure(String string, String string2, boolean bl, LogicalStructureExpression logicalStructureExpression, LogicalStructureExpression logicalStructureExpression2, LogicalVariable[] logicalVariableArray) {
        this.valueExpression = logicalStructureExpression;
        this.type = string;
        this.fullyQualifiedName = string2;
        this.isInterface = bl;
        this.sizeExpression = logicalStructureExpression2;
        this.variables = logicalVariableArray;
    }

    public String getType() {
        return this.type;
    }

    public String getFullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    public LogicalStructureExpression getValueExpression() {
        return this.valueExpression;
    }

    public LogicalStructureExpression getSizeExpression() {
        return this.sizeExpression;
    }

    public LogicalVariable[] getVariables() {
        return this.variables;
    }

    public boolean providesLogicalStructure(ObjectReference objectReference) {
        Type type = objectReference.type();
        if (!(type instanceof ClassType)) {
            return false;
        }
        ClassType classType = (ClassType)type;
        if (Objects.equals(this.type, classType.name())) {
            return true;
        }
        if (this.isInterface) {
            List<InterfaceType> list = ((ClassType)type).allInterfaces();
            for (InterfaceType interfaceType : list) {
                if (!Objects.equals(this.type, interfaceType.name())) continue;
                return true;
            }
        } else {
            while (classType != null) {
                if (Objects.equals(this.type, classType.name())) {
                    return true;
                }
                classType = classType.superclass();
            }
        }
        return false;
    }

    public Value getSize(ObjectReference objectReference, ThreadReference threadReference, IEvaluationProvider iEvaluationProvider) throws CancellationException, InterruptedException, IllegalArgumentException, ExecutionException, UnsupportedOperationException {
        if (this.sizeExpression == null) {
            throw new UnsupportedOperationException("The object hasn't defined the logical size operation.");
        }
        return JavaLogicalStructure.getValue(objectReference, this.sizeExpression, threadReference, iEvaluationProvider);
    }

    public Value getValue(ObjectReference objectReference, ThreadReference threadReference, IEvaluationProvider iEvaluationProvider) throws CancellationException, IllegalArgumentException, InterruptedException, ExecutionException {
        return JavaLogicalStructure.getValue(objectReference, this.valueExpression, threadReference, iEvaluationProvider);
    }

    private static Value getValue(ObjectReference objectReference, LogicalStructureExpression logicalStructureExpression, ThreadReference threadReference, IEvaluationProvider iEvaluationProvider) throws CancellationException, IllegalArgumentException, InterruptedException, ExecutionException {
        if (logicalStructureExpression.type == LogicalStructureExpressionType.METHOD) {
            if (logicalStructureExpression.value == null || logicalStructureExpression.value.length < 2) {
                throw new IllegalArgumentException("The method expression should contain at least methodName and methodSignature!");
            }
            return iEvaluationProvider.invokeMethod(objectReference, logicalStructureExpression.value[0], logicalStructureExpression.value[1], null, threadReference, false).get();
        }
        if (logicalStructureExpression.type == LogicalStructureExpressionType.FIELD) {
            if (logicalStructureExpression.value == null || logicalStructureExpression.value.length < 1) {
                throw new IllegalArgumentException("The field expression should contain the field name!");
            }
            return JavaLogicalStructure.getValueByField(objectReference, logicalStructureExpression.value[0], threadReference);
        }
        if (logicalStructureExpression.value == null || logicalStructureExpression.value.length < 1) {
            throw new IllegalArgumentException("The evaluation expression should contain a valid expression statement!");
        }
        return iEvaluationProvider.evaluate(logicalStructureExpression.value[0], objectReference, threadReference).get();
    }

    private static Value getValueByField(ObjectReference objectReference, String string, ThreadReference threadReference) {
        Field field = objectReference.referenceType().fieldByName(string);
        if (field == null) {
            return null;
        }
        return objectReference.getValue(field);
    }

    public static enum LogicalStructureExpressionType {
        FIELD,
        METHOD,
        EVALUATION_SNIPPET;

    }

    public static class LogicalStructureExpression {
        public LogicalStructureExpressionType type;
        public String[] value;
        public String evaluateName;
        public boolean returnUnboundedType = false;

        public LogicalStructureExpression(LogicalStructureExpressionType logicalStructureExpressionType, String[] stringArray) {
            this(logicalStructureExpressionType, stringArray, null);
        }

        public LogicalStructureExpression(LogicalStructureExpressionType logicalStructureExpressionType, String[] stringArray, String string) {
            this.type = logicalStructureExpressionType;
            this.value = stringArray;
            this.evaluateName = string;
        }

        public LogicalStructureExpression(LogicalStructureExpressionType logicalStructureExpressionType, String[] stringArray, String string, boolean bl) {
            this.type = logicalStructureExpressionType;
            this.value = stringArray;
            this.evaluateName = string;
            this.returnUnboundedType = bl;
        }
    }

    public static class LogicalVariable {
        private final String name;
        private final LogicalStructureExpression valueExpression;

        public LogicalVariable(String string, LogicalStructureExpression logicalStructureExpression) {
            this.name = string;
            this.valueExpression = logicalStructureExpression;
        }

        public String getName() {
            return this.name;
        }

        public Value getValue(ObjectReference objectReference, ThreadReference threadReference, IEvaluationProvider iEvaluationProvider) throws CancellationException, IllegalArgumentException, InterruptedException, ExecutionException {
            return JavaLogicalStructure.getValue(objectReference, this.valueExpression, threadReference, iEvaluationProvider);
        }

        public String getEvaluateName() {
            if (this.valueExpression == null || this.valueExpression.evaluateName == null) {
                return this.name;
            }
            return this.valueExpression.evaluateName;
        }

        public boolean returnUnboundedType() {
            return this.valueExpression != null && this.valueExpression.returnUnboundedType;
        }
    }
}

