/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter.handler;

import com.microsoft.java.debug.core.DebugSettings;
import com.microsoft.java.debug.core.adapter.AdapterUtils;
import com.microsoft.java.debug.core.adapter.ErrorCode;
import com.microsoft.java.debug.core.adapter.IDebugAdapterContext;
import com.microsoft.java.debug.core.adapter.IDebugRequestHandler;
import com.microsoft.java.debug.core.adapter.IEvaluationProvider;
import com.microsoft.java.debug.core.adapter.variables.IVariableFormatter;
import com.microsoft.java.debug.core.adapter.variables.JavaLogicalStructure;
import com.microsoft.java.debug.core.adapter.variables.JavaLogicalStructureManager;
import com.microsoft.java.debug.core.adapter.variables.StackFrameReference;
import com.microsoft.java.debug.core.adapter.variables.Variable;
import com.microsoft.java.debug.core.adapter.variables.VariableDetailUtils;
import com.microsoft.java.debug.core.adapter.variables.VariableProxy;
import com.microsoft.java.debug.core.adapter.variables.VariableUtils;
import com.microsoft.java.debug.core.protocol.Messages;
import com.microsoft.java.debug.core.protocol.Requests;
import com.microsoft.java.debug.core.protocol.Responses;
import com.microsoft.java.debug.core.protocol.Types;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.InternalException;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StackFrame;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class VariablesRequestHandler
implements IDebugRequestHandler {
    protected final Logger logger;

    public VariablesRequestHandler(Logger logger) {
        this.logger = logger;
    }

    @Override
    public List<Requests.Command> getTargetCommands() {
        return Arrays.asList(Requests.Command.VARIABLES);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public CompletableFuture<Messages.Response> handle(Requests.Command var1_1, Requests.Arguments var2_2, Messages.Response var3_3, IDebugAdapterContext var4_4) {
        var5_5 = var4_4.getVariableFormatter();
        var6_6 = (Requests.VariablesArguments)var2_2;
        var7_7 = DebugSettings.getCurrent().showStaticVariables;
        var8_8 = var5_5.getDefaultOptions();
        VariableUtils.applyFormatterOptions(var8_8, var6_6.format != null && var6_6.format.hex != false);
        var9_9 = var4_4.getProvider(IEvaluationProvider.class);
        var10_10 = new ArrayList<Types.Variable>();
        var11_11 = var4_4.getRecyclableIdPool().getObjectById(var6_6.variablesReference);
        if (var11_11 == null) {
            var3_3.body = new Responses.VariablesResponseBody(var10_10);
            return CompletableFuture.completedFuture(var3_3);
        }
        if (!(var11_11 instanceof VariableProxy)) {
            throw AdapterUtils.createCompletionException(String.format("VariablesRequest: Invalid variablesReference %d.", new Object[]{var6_6.variablesReference}), ErrorCode.GET_VARIABLE_FAILURE);
        }
        var12_12 = (VariableProxy)var11_11;
        var13_13 = new ArrayList<E>();
        var14_14 = var4_4.getStackFrameManager();
        var15_15 = var12_12.getEvaluateName();
        var16_16 = var12_12.isUnboundedType();
        if (var12_12.getProxiedVariable() instanceof StackFrameReference) {
            var17_17 = (StackFrameReference)var12_12.getProxiedVariable();
            var18_19 = var14_14.getStackFrame((StackFrameReference)var17_17);
            if (var18_19 == null) {
                throw AdapterUtils.createCompletionException(String.format("Invalid stackframe id %d to get variables.", new Object[]{var6_6.variablesReference}), ErrorCode.GET_VARIABLE_FAILURE);
            }
            try {
                var19_20 = var17_17.getThread().uniqueID();
                var21_26 = var4_4.getStepRequestManager().getMethodResult(var19_20);
                if (var21_26 != null) {
                    var22_28 = AdapterUtils.isWin != false || AdapterUtils.isMac != false ? "\u23af\u25ba" : "->";
                    var13_13.add(new Variable((String)var22_28 + var21_26.method.name() + "()", var21_26.value, null));
                }
                var13_13.addAll(VariableUtils.listLocalVariables((StackFrame)var18_19));
                var22_28 = VariableUtils.getThisVariable(var18_19);
                if (var22_28 != null) {
                    var13_13.add(var22_28);
                }
                if (!var7_7 || !var18_19.location().method().isStatic()) ** GOTO lbl88
                var13_13.addAll(VariableUtils.listStaticVariables(var18_19));
            }
            catch (AbsentInformationException | InternalException | InvalidStackFrameException var19_21) {
                throw AdapterUtils.createCompletionException(String.format("Failed to get variables. Reason: %s", new Object[]{var19_21.toString()}), ErrorCode.GET_VARIABLE_FAILURE, var19_21);
            }
        } else {
            try {
                var17_17 = (ObjectReference)var12_12.getProxiedVariable();
                if (DebugSettings.getCurrent().showLogicalStructure && var9_9 != null) {
                    var18_19 = null;
                    try {
                        var18_19 = JavaLogicalStructureManager.getLogicalStructure((ObjectReference)var17_17);
                    }
                    catch (Exception var19_22) {
                        this.logger.log(Level.WARNING, "Failed to get the logical structure for the variable, fall back to the Object view.", var19_22);
                    }
                    if (var16_16 && var18_19 != null && var15_15 != null) {
                        var15_15 = "((" + var18_19.getFullyQualifiedName() + ")" + var15_15 + ")";
                        var16_16 = false;
                    }
                    while (var18_19 != null) {
                        var19_23 = var18_19.getValueExpression();
                        var20_30 = var18_19.getVariables();
                        try {
                            if (var19_23 != null) {
                                var15_15 = var15_15 == null ? null : var15_15 + "." + var19_23.evaluateName;
                                var16_16 = var19_23.returnUnboundedType;
                                var21_26 = var18_19.getValue((ObjectReference)var17_17, var12_12.getThread(), var9_9);
                                if (var21_26 instanceof ObjectReference) {
                                    var17_17 = (ObjectReference)var21_26;
                                    var18_19 = JavaLogicalStructureManager.getLogicalStructure((ObjectReference)var17_17);
                                    continue;
                                }
                                var13_13 = Arrays.asList(new Variable[]{new Variable("logical structure", (Value)var21_26)});
                            } else if (var20_30 != null && ((JavaLogicalStructure.LogicalVariable[])var20_30).length > 0) {
                                for (Object var24_32 : var20_30) {
                                    var25_33 = var24_32.getName();
                                    var26_35 = var24_32.getValue((ObjectReference)var17_17, var12_12.getThread(), var9_9);
                                    var27_37 = new Variable((String)var25_33, (Value)var26_35, var24_32.getEvaluateName());
                                    var27_37.setUnboundedType(var24_32.returnUnboundedType());
                                    var13_13.add(var27_37);
                                }
                            }
                        }
                        catch (Exception var21_27) {
                            this.logger.log(Level.WARNING, "Failed to get the logical structure for the variable, fall back to the Object view.", var21_27);
                        }
                        var18_19 = null;
                    }
                }
                if (var13_13.isEmpty() && VariableUtils.hasChildren((Value)var17_17, var7_7)) {
                    var13_13 = var6_6.count > 0 ? VariableUtils.listFieldVariables(var17_17, var6_6.start, var6_6.count) : VariableUtils.listFieldVariables((ObjectReference)var17_17, var7_7);
                }
            }
            catch (AbsentInformationException var17_18) {
                throw AdapterUtils.createCompletionException(String.format("Failed to get variables. Reason: %s", new Object[]{var17_18.toString()}), ErrorCode.GET_VARIABLE_FAILURE, var17_18);
            }
        }
lbl88:
        // 3 sources

        var17_17 = this.getDuplicateNames((Collection<String>)var13_13.stream().map((Function<Variable, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$handle$0(com.microsoft.java.debug.core.adapter.variables.Variable ), (Lcom/microsoft/java/debug/core/adapter/variables/Variable;)Ljava/lang/String;)()).collect(Collectors.toList()));
        var18_19 = new HashMap<K, V>();
        if (!var17_17.isEmpty()) {
            var19_24 = var13_13.stream().filter((Predicate<Variable>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$handle$1(java.util.Set com.microsoft.java.debug.core.adapter.variables.Variable ), (Lcom/microsoft/java/debug/core/adapter/variables/Variable;)Z)(var17_17)).collect(Collectors.groupingBy((Function<Variable, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$handle$2(com.microsoft.java.debug.core.adapter.variables.Variable ), (Lcom/microsoft/java/debug/core/adapter/variables/Variable;)Ljava/lang/String;)(), Collectors.toList()));
            var19_24.forEach((BiConsumer<String, List>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)V, lambda$handle$3(com.microsoft.java.debug.core.adapter.variables.IVariableFormatter java.util.Map java.util.Map java.lang.String java.util.List ), (Ljava/lang/String;Ljava/util/List;)V)((IVariableFormatter)var5_5, var8_8, var18_19));
        }
        for (Object var20_30 : var13_13) {
            var21_26 = var20_30.value;
            var22_28 = var20_30.name;
            if (var18_19.containsKey(var20_30)) {
                var22_28 = (String)var18_19.get(var20_30);
            }
            var23_31 = -1;
            var24_32 = null;
            if (var21_26 instanceof ArrayReference) {
                var23_31 = ((ArrayReference)var21_26).length();
            } else if (var21_26 instanceof ObjectReference && DebugSettings.getCurrent().showLogicalStructure && var9_9 != null) {
                try {
                    var25_33 = JavaLogicalStructureManager.getLogicalStructure((ObjectReference)var21_26);
                    if (var25_33 != null && var25_33.getSizeExpression() != null && (var24_32 = var25_33.getSize((ObjectReference)var21_26, var12_12.getThread(), var9_9)) != null && var24_32 instanceof IntegerValue) {
                        var23_31 = ((IntegerValue)var24_32).value();
                    }
                }
                catch (Exception var25_34) {
                    this.logger.log(Level.INFO, "Failed to get the logical size of the variable", var25_34);
                }
            }
            var25_33 = null;
            if (var20_30.evaluateName == null || var15_15 == null && var12_12.getProxiedVariable() instanceof ObjectReference) {
                var25_33 = null;
            } else if (var16_16 && !var12_12.isIndexedVariable()) {
                var26_35 = ((ObjectReference)var12_12.getProxiedVariable()).referenceType().name();
                var26_35 = var26_35.replaceAll("\\$", ".");
                var25_33 = VariableUtils.getEvaluateName(var20_30.evaluateName, "((" + (String)var26_35 + ")" + var15_15 + ")", false);
            } else {
                var25_33 = var15_15 != null && var15_15.contains("%s") != false ? String.format(var15_15, new Object[]{var20_30.evaluateName}) : VariableUtils.getEvaluateName(var20_30.evaluateName, var15_15, var12_12.isIndexedVariable());
            }
            var26_36 = 0;
            if (var23_31 > 0 || var23_31 < 0 && var21_26 instanceof ObjectReference) {
                var27_37 = new VariableProxy(var12_12.getThread(), var12_12.getScope(), var21_26, var12_12, (String)var25_33);
                var26_36 = var4_4.getRecyclableIdPool().addObject(var12_12.getThreadId(), var27_37);
                var27_37.setIndexedVariable(var23_31 >= 0);
                var27_37.setUnboundedType(var20_30.isUnboundedType());
            }
            var27_38 = false;
            var28_39 = null;
            try {
                var28_39 = var5_5.valueToString((Value)var21_26, var8_8);
            }
            catch (OutOfMemoryError var29_41) {
                var27_38 = true;
                this.logger.log(Level.SEVERE, "Failed to convert the value of a large object to a string", var29_41);
                var28_39 = "<Unable to display the value of a large object>";
            }
            catch (Exception var29_42) {
                var27_38 = true;
                this.logger.log(Level.SEVERE, "Failed to resolve the variable value", var29_42);
                var28_39 = "<Failed to resolve the variable value due to \"" + var29_42.getMessage() + "\">";
            }
            var29_40 = "";
            try {
                var29_40 = var5_5.typeToString(var21_26 == null ? null : var21_26.type(), var8_8);
            }
            catch (Exception var30_44) {
                this.logger.log(Level.SEVERE, "Failed to resolve the variable type", var30_44);
                var29_40 = "";
            }
            var30_43 = new Types.Variable((String)var22_28, var28_39, var29_40, var26_36, (String)var25_33);
            var30_43.indexedVariables = Math.max(var23_31, 0);
            var31_45 = null;
            if (!var27_38) {
                if (var24_32 != null) {
                    var31_45 = "size=" + var5_5.valueToString((Value)var24_32, var8_8);
                } else if (DebugSettings.getCurrent().showToString) {
                    try {
                        var31_45 = VariableDetailUtils.formatDetailsValue((Value)var21_26, var12_12.getThread(), var5_5, var8_8, var9_9);
                    }
                    catch (OutOfMemoryError var32_47) {
                        this.logger.log(Level.SEVERE, "Failed to compute the toString() value of a large object", var32_47);
                        var31_45 = "<Unable to display the details of a large object>";
                    }
                    catch (Exception var32_48) {
                        this.logger.log(Level.SEVERE, "Failed to compute the toString() value", var32_48);
                        var31_45 = "<Failed to resolve the variable details due to \"" + var32_48.getMessage() + "\">";
                    }
                }
            }
            if (var31_45 != null) {
                var30_43.value = var30_43.value + " " + var31_45;
            }
            var10_10.add(var30_43);
        }
        if (var10_10.isEmpty() && var12_12.getProxiedVariable() instanceof ObjectReference) {
            var10_10.add(new Types.Variable("Class has no fields", "", null, 0, null));
        }
        var3_3.body = new Responses.VariablesResponseBody(var10_10);
        return CompletableFuture.completedFuture(var3_3);
    }

    private Set<String> getDuplicateNames(Collection<String> collection) {
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        for (String string : collection) {
            if (!hashSet2.contains(string)) {
                hashSet2.add(string);
                continue;
            }
            hashSet.add(string);
        }
        return hashSet;
    }

    private static /* synthetic */ void lambda$handle$3(IVariableFormatter iVariableFormatter, Map map, Map map2, String string, List list) {
        Type type;
        HashSet<String> hashSet = new HashSet<String>();
        boolean bl = false;
        for (Variable variable : list) {
            type = variable.getDeclaringType();
            if (type == null) continue;
            String string2 = iVariableFormatter.typeToString(type, map);
            String string3 = String.format("%s (%s)", variable.name, string2);
            if (!hashSet.add(string3)) {
                bl = true;
                break;
            }
            map2.put(variable, string3);
        }
        if (bl) {
            for (Variable variable : list) {
                type = variable.getDeclaringType();
                if (type == null) continue;
                map2.put(variable, String.format("%s (%s)", variable.name, type.name()));
            }
        }
    }

    private static /* synthetic */ String lambda$handle$2(Variable variable) {
        return variable.name;
    }

    private static /* synthetic */ boolean lambda$handle$1(Set set, Variable variable) {
        return set.contains(variable.name);
    }

    private static /* synthetic */ String lambda$handle$0(Variable variable) {
        return variable.name;
    }
}

