/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter.handler;

import com.microsoft.java.debug.core.DebugEvent;
import com.microsoft.java.debug.core.DebugUtility;
import com.microsoft.java.debug.core.IDebugSession;
import com.microsoft.java.debug.core.JdiExceptionReference;
import com.microsoft.java.debug.core.JdiMethodResult;
import com.microsoft.java.debug.core.adapter.AdapterUtils;
import com.microsoft.java.debug.core.adapter.ErrorCode;
import com.microsoft.java.debug.core.adapter.IDebugAdapterContext;
import com.microsoft.java.debug.core.adapter.IDebugRequestHandler;
import com.microsoft.java.debug.core.adapter.IStepFilterProvider;
import com.microsoft.java.debug.core.adapter.StepRequestManager;
import com.microsoft.java.debug.core.adapter.handler.ThreadsRequestHandler;
import com.microsoft.java.debug.core.protocol.Events;
import com.microsoft.java.debug.core.protocol.Messages;
import com.microsoft.java.debug.core.protocol.Requests;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import com.sun.jdi.VoidValue;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.MethodExitEvent;
import com.sun.jdi.event.StepEvent;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.MethodExitRequest;
import com.sun.jdi.request.StepRequest;
import io.reactivex.disposables.Disposable;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class StepRequestHandler
implements IDebugRequestHandler {
    @Override
    public List<Requests.Command> getTargetCommands() {
        return Arrays.asList(Requests.Command.STEPIN, Requests.Command.STEPOUT, Requests.Command.NEXT);
    }

    @Override
    public CompletableFuture<Messages.Response> handle(Requests.Command command, Requests.Arguments arguments, Messages.Response response, IDebugAdapterContext iDebugAdapterContext) {
        if (iDebugAdapterContext.getDebugSession() == null) {
            return AdapterUtils.createAsyncErrorResponse(response, ErrorCode.EMPTY_DEBUG_SESSION, "Debug Session doesn't exist.");
        }
        long l = ((Requests.StepArguments)arguments).threadId;
        ThreadReference threadReference = DebugUtility.getThread(iDebugAdapterContext.getDebugSession(), l);
        if (threadReference != null) {
            JdiExceptionReference jdiExceptionReference = iDebugAdapterContext.getExceptionManager().removeException(l);
            iDebugAdapterContext.getStepRequestManager().removeMethodResult(l);
            try {
                StepRequestManager stepRequestManager = iDebugAdapterContext.getStepRequestManager();
                StepRequestManager.ThreadState threadState = stepRequestManager.setThreadState(command, threadReference);
                Disposable disposable = iDebugAdapterContext.getDebugSession().getEventHub().events().filter(debugEvent -> debugEvent.event instanceof StepEvent && debugEvent.event.request().equals(threadState.getPendingStepRequest()) || debugEvent.event instanceof MethodExitEvent && debugEvent.event.request().equals(threadState.getPendingMethodExitRequest())).subscribe(debugEvent -> this.handleDebugEvent((DebugEvent)debugEvent, iDebugAdapterContext.getDebugSession(), iDebugAdapterContext, threadState));
                threadState.setEventSubscription(disposable);
                StepRequest stepRequest = command == Requests.Command.STEPIN ? DebugUtility.createStepIntoRequest(threadReference, iDebugAdapterContext.getStepFilters().allowClasses, iDebugAdapterContext.getStepFilters().skipClasses) : (command == Requests.Command.STEPOUT ? DebugUtility.createStepOutRequest(threadReference, iDebugAdapterContext.getStepFilters().allowClasses, iDebugAdapterContext.getStepFilters().skipClasses) : DebugUtility.createStepOverRequest(threadReference, null));
                threadState.setPendingStepRequest(stepRequest);
                stepRequest.enable();
                MethodExitRequest methodExitRequest = threadReference.virtualMachine().eventRequestManager().createMethodExitRequest();
                methodExitRequest.addThreadFilter(threadReference);
                methodExitRequest.addClassFilter(threadState.getStepLocation().declaringType());
                if (threadReference.virtualMachine().canUseInstanceFilters()) {
                    try {
                        ObjectReference objectReference = this.getTopFrame(threadReference).thisObject();
                        if (objectReference != null) {
                            methodExitRequest.addInstanceFilter(objectReference);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                methodExitRequest.setSuspendPolicy(1);
                threadState.setPendingMethodExitRequest(methodExitRequest);
                methodExitRequest.enable();
                DebugUtility.resumeThread(threadReference);
                ThreadsRequestHandler.checkThreadRunningAndRecycleIds(threadReference, iDebugAdapterContext);
            }
            catch (IncompatibleThreadStateException incompatibleThreadStateException) {
                iDebugAdapterContext.getExceptionManager().setException(l, jdiExceptionReference);
                String string = String.format("Failed to step because the thread '%s' is not suspended in the target VM.", threadReference.name());
                throw AdapterUtils.createCompletionException(string, ErrorCode.STEP_FAILURE, incompatibleThreadStateException);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                iDebugAdapterContext.getExceptionManager().setException(l, jdiExceptionReference);
                String string = String.format("Failed to step because the thread '%s' doesn't contain any stack frame", threadReference.name());
                throw AdapterUtils.createCompletionException(string, ErrorCode.STEP_FAILURE, indexOutOfBoundsException);
            }
        }
        return CompletableFuture.completedFuture(response);
    }

    private void handleDebugEvent(DebugEvent debugEvent, IDebugSession iDebugSession, IDebugAdapterContext iDebugAdapterContext, StepRequestManager.ThreadState threadState) {
        Event event = debugEvent.event;
        EventRequestManager eventRequestManager = iDebugSession.getVM().eventRequestManager();
        if (event instanceof StepEvent) {
            ThreadReference threadReference = ((StepEvent)event).thread();
            threadState.deleteStepRequest(eventRequestManager);
            IStepFilterProvider iStepFilterProvider = iDebugAdapterContext.getProvider(IStepFilterProvider.class);
            try {
                Location location = threadState.getStepLocation();
                Location location2 = this.getTopFrame(threadReference).location();
                Location location3 = null;
                if (threadReference.frameCount() > 1) {
                    location3 = threadReference.frame(1).location();
                }
                if (location != null && location2 != null) {
                    Requests.StepFilters stepFilters = iDebugAdapterContext.getStepFilters();
                    if (this.shouldSkipOut(iStepFilterProvider, threadState.getStackDepth(), threadReference.frameCount(), location3, location2)) {
                        this.doExtraStepOut(debugEvent, threadReference, stepFilters, threadState);
                        return;
                    }
                    if (this.shouldDoExtraStep(threadState, location, threadReference.frameCount(), location2)) {
                        this.doExtraStepInto(debugEvent, threadReference, stepFilters, threadState);
                        return;
                    }
                    if (this.shouldSkipOver(iStepFilterProvider, location, location2, stepFilters)) {
                        this.doExtraStepInto(debugEvent, threadReference, stepFilters, threadState);
                        return;
                    }
                }
            }
            catch (IncompatibleThreadStateException | IndexOutOfBoundsException exception) {
                // empty catch block
            }
            threadState.deletePendingStep(eventRequestManager);
            iDebugAdapterContext.getProtocolServer().sendEvent(new Events.StoppedEvent("step", threadState.getThreadId()));
            debugEvent.shouldResume = false;
        } else if (event instanceof MethodExitEvent) {
            MethodExitEvent methodExitEvent = (MethodExitEvent)event;
            long l = methodExitEvent.thread().uniqueID();
            if (l == threadState.getThreadId() && methodExitEvent.method().equals(threadState.getStepLocation().method())) {
                Value value = methodExitEvent.returnValue();
                if (value instanceof VoidValue) {
                    iDebugAdapterContext.getStepRequestManager().removeMethodResult(l);
                } else {
                    JdiMethodResult jdiMethodResult = new JdiMethodResult(methodExitEvent.method(), value);
                    iDebugAdapterContext.getStepRequestManager().setMethodResult(l, jdiMethodResult);
                }
            }
            debugEvent.shouldResume = true;
        }
    }

    private boolean shouldSkipOver(IStepFilterProvider iStepFilterProvider, Location location, Location location2, Requests.StepFilters stepFilters) throws IncompatibleThreadStateException {
        return !iStepFilterProvider.shouldSkipOver(location.method(), stepFilters) && iStepFilterProvider.shouldSkipOver(location2.method(), stepFilters);
    }

    private boolean shouldSkipOut(IStepFilterProvider iStepFilterProvider, int n, int n2, Location location, Location location2) throws IncompatibleThreadStateException {
        if (location == null) {
            return false;
        }
        if (n2 <= n) {
            return false;
        }
        return iStepFilterProvider.shouldSkipOut(location, location2.method());
    }

    private boolean shouldDoExtraStep(StepRequestManager.ThreadState threadState, Location location, int n, Location location2) throws IncompatibleThreadStateException {
        Method method;
        if (threadState.getStepType() != Requests.Command.STEPIN) {
            return false;
        }
        if (threadState.getStackDepth() != n) {
            return false;
        }
        if (location == null) {
            return false;
        }
        Method method2 = location.method();
        if (!method2.equals(method = location2.method())) {
            return false;
        }
        return location.lineNumber() == location2.lineNumber();
    }

    private void doExtraStepInto(DebugEvent debugEvent, ThreadReference threadReference, Requests.StepFilters stepFilters, StepRequestManager.ThreadState threadState) {
        StepRequest stepRequest = DebugUtility.createStepIntoRequest(threadReference, stepFilters.allowClasses, stepFilters.skipClasses);
        threadState.setPendingStepRequest(stepRequest);
        stepRequest.enable();
        debugEvent.shouldResume = true;
    }

    private void doExtraStepOut(DebugEvent debugEvent, ThreadReference threadReference, Requests.StepFilters stepFilters, StepRequestManager.ThreadState threadState) {
        StepRequest stepRequest = DebugUtility.createStepOutRequest(threadReference, stepFilters.allowClasses, stepFilters.skipClasses);
        threadState.setPendingStepRequest(stepRequest);
        stepRequest.enable();
        debugEvent.shouldResume = true;
    }

    private StackFrame getTopFrame(ThreadReference threadReference) throws IncompatibleThreadStateException {
        return threadReference.frame(0);
    }
}

