/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter.handler;

import com.microsoft.java.debug.core.adapter.AdapterUtils;
import com.microsoft.java.debug.core.adapter.ErrorCode;
import com.microsoft.java.debug.core.adapter.IDebugAdapterContext;
import com.microsoft.java.debug.core.adapter.IDebugRequestHandler;
import com.microsoft.java.debug.core.adapter.ISourceLookUpProvider;
import com.microsoft.java.debug.core.protocol.Messages;
import com.microsoft.java.debug.core.protocol.Requests;
import com.microsoft.java.debug.core.protocol.Responses;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class SourceRequestHandler
implements IDebugRequestHandler {
    @Override
    public List<Requests.Command> getTargetCommands() {
        return Arrays.asList(Requests.Command.SOURCE);
    }

    @Override
    public CompletableFuture<Messages.Response> handle(Requests.Command command, Requests.Arguments arguments, Messages.Response response, IDebugAdapterContext iDebugAdapterContext) {
        int n = ((Requests.SourceArguments)arguments).sourceReference;
        if (n <= 0) {
            return AdapterUtils.createAsyncErrorResponse(response, ErrorCode.ARGUMENT_MISSING, "SourceRequest: property 'sourceReference' is missing, null, or empty");
        }
        String string = iDebugAdapterContext.getSourceUri(n);
        ISourceLookUpProvider iSourceLookUpProvider = iDebugAdapterContext.getProvider(ISourceLookUpProvider.class);
        response.body = new Responses.SourceResponseBody(iSourceLookUpProvider.getSourceContents(string));
        return CompletableFuture.completedFuture(response);
    }
}

