/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter.handler;

import com.microsoft.java.debug.core.DebugSettings;
import com.microsoft.java.debug.core.adapter.AdapterUtils;
import com.microsoft.java.debug.core.adapter.ErrorCode;
import com.microsoft.java.debug.core.adapter.IDebugAdapterContext;
import com.microsoft.java.debug.core.adapter.IDebugRequestHandler;
import com.microsoft.java.debug.core.adapter.variables.IVariableFormatter;
import com.microsoft.java.debug.core.adapter.variables.StackFrameReference;
import com.microsoft.java.debug.core.adapter.variables.VariableProxy;
import com.microsoft.java.debug.core.adapter.variables.VariableUtils;
import com.microsoft.java.debug.core.protocol.Messages;
import com.microsoft.java.debug.core.protocol.Requests;
import com.microsoft.java.debug.core.protocol.Responses;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StackFrame;
import com.sun.jdi.Type;
import com.sun.jdi.TypeComponent;
import com.sun.jdi.Value;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class SetVariableRequestHandler
implements IDebugRequestHandler {
    private static final String PATTERN = "([a-zA-Z_0-9$]+)\\s*\\(([^)]+)\\)";
    private IDebugAdapterContext context = null;

    @Override
    public List<Requests.Command> getTargetCommands() {
        return Arrays.asList(Requests.Command.SETVARIABLE);
    }

    @Override
    public CompletableFuture<Messages.Response> handle(Requests.Command command, Requests.Arguments arguments, Messages.Response response, IDebugAdapterContext iDebugAdapterContext) {
        Value value;
        String string;
        Object object;
        Map<String, Object> map;
        boolean bl;
        block11: {
            Requests.SetVariableArguments setVariableArguments = (Requests.SetVariableArguments)arguments;
            if (setVariableArguments.value == null) {
                return CompletableFuture.completedFuture(response);
            }
            if (setVariableArguments.variablesReference == -1) {
                throw AdapterUtils.createCompletionException("SetVariablesRequest: property 'variablesReference' is missing, null, or empty", ErrorCode.ARGUMENT_MISSING);
            }
            if (StringUtils.isBlank((CharSequence)setVariableArguments.name)) {
                throw AdapterUtils.createCompletionException("SetVariablesRequest: property 'name' is missing, null, or empty", ErrorCode.ARGUMENT_MISSING);
            }
            this.context = iDebugAdapterContext;
            bl = DebugSettings.getCurrent().showStaticVariables;
            IVariableFormatter iVariableFormatter = iDebugAdapterContext.getVariableFormatter();
            map = iVariableFormatter.getDefaultOptions();
            VariableUtils.applyFormatterOptions(map, setVariableArguments.format != null && setVariableArguments.format.hex);
            object = iDebugAdapterContext.getRecyclableIdPool().getObjectById(setVariableArguments.variablesReference);
            if (object == null) {
                throw AdapterUtils.createCompletionException("Failed to set variable. Reason: Cannot set value because the thread is resumed.", ErrorCode.SET_VARIABLE_FAILURE);
            }
            string = setVariableArguments.name;
            value = null;
            String string2 = null;
            if (setVariableArguments.name.contains("(")) {
                string = setVariableArguments.name.replaceFirst(PATTERN, "$1");
                string2 = setVariableArguments.name.replaceFirst(PATTERN, "$2");
            }
            try {
                Object object2 = ((VariableProxy)object).getProxiedVariable();
                if (object2 instanceof StackFrameReference) {
                    StackFrameReference stackFrameReference = (StackFrameReference)object2;
                    StackFrame stackFrame = iDebugAdapterContext.getStackFrameManager().getStackFrame(stackFrameReference);
                    value = this.handleSetValueForStackFrame(string, string2, setVariableArguments.value, bl, stackFrame, map);
                    break block11;
                }
                if (object2 instanceof ObjectReference) {
                    value = this.handleSetValueForObject(string, string2, setVariableArguments.value, (ObjectReference)object2, map);
                    break block11;
                }
                throw AdapterUtils.createCompletionException(String.format("SetVariableRequest: Variable %s cannot be found.", setVariableArguments.variablesReference), ErrorCode.SET_VARIABLE_FAILURE);
            }
            catch (AbsentInformationException | ClassNotLoadedException | InvalidTypeException | IllegalArgumentException | UnsupportedOperationException exception) {
                throw AdapterUtils.createCompletionException(String.format("Failed to set variable. Reason: %s", exception.toString()), ErrorCode.SET_VARIABLE_FAILURE, exception);
            }
        }
        int n = 0;
        if (value instanceof ObjectReference && VariableUtils.hasChildren(value, bl)) {
            long l = ((VariableProxy)object).getThreadId();
            String string3 = ((VariableProxy)object).getScope();
            VariableProxy variableProxy = new VariableProxy(((VariableProxy)object).getThread(), string3, value, (VariableProxy)object, string);
            n = iDebugAdapterContext.getRecyclableIdPool().addObject(l, variableProxy);
        }
        int n2 = 0;
        if (value instanceof ArrayReference) {
            n2 = ((ArrayReference)value).length();
        }
        response.body = new Responses.SetVariablesResponseBody(iDebugAdapterContext.getVariableFormatter().typeToString(value == null ? null : value.type(), map), iDebugAdapterContext.getVariableFormatter().valueToString(value, map), n, n2);
        return CompletableFuture.completedFuture(response);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Value handleSetValueForObject(String string, String string2, String string3, ObjectReference objectReference, Map<String, Object> map) throws InvalidTypeException, ClassNotLoadedException {
        if (objectReference instanceof ArrayReference) {
            ArrayReference arrayReference = (ArrayReference)objectReference;
            Type type = ((ArrayType)arrayReference.referenceType()).componentType();
            return this.setArrayValue(arrayReference, type, Integer.parseInt(string), string3, map);
        }
        if (!StringUtils.isBlank((CharSequence)string2)) return this.setFieldValueWithConflict(objectReference, objectReference.referenceType().allFields(), string, string2, string3, map);
        Field field = objectReference.referenceType().fieldByName(string);
        if (field == null) throw new IllegalArgumentException(String.format("SetVariableRequest: Variable %s cannot be found.", string));
        if (!field.isStatic()) return this.setObjectFieldValue(objectReference, field, string, string3, map);
        return this.setStaticFieldValue(objectReference.referenceType(), field, string, string3, map);
    }

    private Value handleSetValueForStackFrame(String string, String string2, String string3, boolean bl, StackFrame stackFrame, Map<String, Object> map) throws AbsentInformationException, InvalidTypeException, ClassNotLoadedException {
        Value value;
        if (string.equals("this")) {
            throw new UnsupportedOperationException("SetVariableRequest: 'This' variable cannot be changed.");
        }
        LocalVariable localVariable = stackFrame.visibleVariableByName(string);
        if (StringUtils.isBlank((CharSequence)string2) && localVariable != null) {
            value = this.setFrameValue(stackFrame, localVariable, string3, map);
        } else if (bl && stackFrame.location().method().isStatic()) {
            ReferenceType referenceType = stackFrame.location().declaringType();
            if (StringUtils.isBlank((CharSequence)string2)) {
                Field field = referenceType.fieldByName(string);
                value = this.setStaticFieldValue(referenceType, field, string, string3, map);
            } else {
                value = this.setFieldValueWithConflict(null, referenceType.allFields(), string, string2, string3, map);
            }
        } else {
            throw new UnsupportedOperationException(String.format("SetVariableRequest: Variable %s cannot be found.", string));
        }
        return value;
    }

    private Value setValueProxy(Type type, String string, SetValueFunction setValueFunction, Map<String, Object> map) throws ClassNotLoadedException, InvalidTypeException {
        Value value = this.context.getVariableFormatter().stringToValue(string, type, map);
        setValueFunction.apply(value);
        return value;
    }

    private Value setStaticFieldValue(Type type, Field field, String string, String string2, Map<String, Object> map) throws ClassNotLoadedException, InvalidTypeException {
        if (field.isFinal()) {
            throw new UnsupportedOperationException(String.format("SetVariableRequest: Final field %s cannot be changed.", string));
        }
        if (!(type instanceof ClassType)) {
            throw new UnsupportedOperationException(String.format("SetVariableRequest: Field %s in interface cannot be changed.", string));
        }
        return this.setValueProxy(field.type(), string2, value -> ((ClassType)type).setValue(field, value), map);
    }

    private Value setFrameValue(StackFrame stackFrame, LocalVariable localVariable, String string, Map<String, Object> map) throws ClassNotLoadedException, InvalidTypeException {
        return this.setValueProxy(localVariable.type(), string, value -> stackFrame.setValue(localVariable, value), map);
    }

    private Value setObjectFieldValue(ObjectReference objectReference, Field field, String string, String string2, Map<String, Object> map) throws ClassNotLoadedException, InvalidTypeException {
        if (field.isFinal()) {
            throw new UnsupportedOperationException(String.format("SetVariableRequest: Final field %s cannot be changed.", string));
        }
        return this.setValueProxy(field.type(), string2, value -> objectReference.setValue(field, value), map);
    }

    private Value setArrayValue(ArrayReference arrayReference, Type type, int n, String string, Map<String, Object> map) throws ClassNotLoadedException, InvalidTypeException {
        return this.setValueProxy(type, string, value -> arrayReference.setValue(n, value), map);
    }

    private Value setFieldValueWithConflict(ObjectReference objectReference, List<Field> list, String string, String string2, String string3, Map<String, Object> map) throws ClassNotLoadedException, InvalidTypeException {
        List list2 = list.stream().filter(TypeComponent::isStatic).filter(field -> field.name().equals(string) && field.declaringType().name().equals(string2)).collect(Collectors.toList());
        if (list2.isEmpty()) {
            list2 = list.stream().filter(TypeComponent::isStatic).filter(field -> field.name().equals(string) && this.context.getVariableFormatter().typeToString(field.declaringType(), map).equals(string2)).collect(Collectors.toList());
        }
        if (list2.size() != 1) {
            throw new UnsupportedOperationException(String.format("SetVariableRequest: Name conflicted for %s.", string));
        }
        Field field2 = (Field)list2.get(0);
        return field2.isStatic() ? this.setStaticFieldValue(field2.declaringType(), field2, string, string3, map) : this.setObjectFieldValue(objectReference, field2, string, string3, map);
    }

    @FunctionalInterface
    static interface SetValueFunction {
        public void apply(Value var1) throws InvalidTypeException, ClassNotLoadedException;
    }
}

