/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter.handler;

import com.microsoft.java.debug.core.DebugSettings;
import com.microsoft.java.debug.core.IDebugSession;
import com.microsoft.java.debug.core.adapter.AdapterUtils;
import com.microsoft.java.debug.core.adapter.ErrorCode;
import com.microsoft.java.debug.core.adapter.IDebugAdapterContext;
import com.microsoft.java.debug.core.adapter.IDebugRequestHandler;
import com.microsoft.java.debug.core.protocol.Messages;
import com.microsoft.java.debug.core.protocol.Requests;
import com.sun.jdi.event.VMDeathEvent;
import com.sun.jdi.event.VMDisconnectEvent;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.ArrayUtils;

public class SetExceptionBreakpointsRequestHandler
implements IDebugRequestHandler,
DebugSettings.IDebugSettingChangeListener {
    private IDebugSession debugSession = null;
    private boolean isInitialized = false;
    private boolean notifyCaught = false;
    private boolean notifyUncaught = false;

    @Override
    public List<Requests.Command> getTargetCommands() {
        return Arrays.asList(Requests.Command.SETEXCEPTIONBREAKPOINTS);
    }

    @Override
    public synchronized CompletableFuture<Messages.Response> handle(Requests.Command command, Requests.Arguments arguments, Messages.Response response, IDebugAdapterContext iDebugAdapterContext) {
        if (iDebugAdapterContext.getDebugSession() == null) {
            return AdapterUtils.createAsyncErrorResponse(response, ErrorCode.EMPTY_DEBUG_SESSION, "Empty debug session.");
        }
        if (!this.isInitialized) {
            this.isInitialized = true;
            this.debugSession = iDebugAdapterContext.getDebugSession();
            DebugSettings.addDebugSettingChangeListener(this);
            this.debugSession.getEventHub().events().subscribe(debugEvent -> {
                if (debugEvent.event instanceof VMDeathEvent || debugEvent.event instanceof VMDisconnectEvent) {
                    DebugSettings.removeDebugSettingChangeListener(this);
                }
            });
        }
        Object[] objectArray = ((Requests.SetExceptionBreakpointsArguments)arguments).filters;
        try {
            this.notifyCaught = ArrayUtils.contains((Object[])objectArray, (Object)"caught");
            this.notifyUncaught = ArrayUtils.contains((Object[])objectArray, (Object)"uncaught");
            this.setExceptionBreakpoints(iDebugAdapterContext.getDebugSession(), this.notifyCaught, this.notifyUncaught);
            return CompletableFuture.completedFuture(response);
        }
        catch (Exception exception) {
            throw AdapterUtils.createCompletionException(String.format("Failed to setExceptionBreakpoints. Reason: '%s'", exception.toString()), ErrorCode.SET_EXCEPTIONBREAKPOINT_FAILURE, exception);
        }
    }

    private void setExceptionBreakpoints(IDebugSession iDebugSession, boolean bl, boolean bl2) {
        Requests.ClassFilters classFilters = DebugSettings.getCurrent().exceptionFilters;
        String[] stringArray = classFilters == null ? null : classFilters.allowClasses;
        String[] stringArray2 = classFilters == null ? null : classFilters.skipClasses;
        iDebugSession.setExceptionBreakpoints(bl, bl2, stringArray, stringArray2);
    }

    @Override
    public synchronized void update(DebugSettings debugSettings, DebugSettings debugSettings2) {
        try {
            if (debugSettings2 != null && debugSettings2.exceptionFiltersUpdated) {
                this.setExceptionBreakpoints(this.debugSession, this.notifyCaught, this.notifyUncaught);
            }
        }
        catch (Exception exception) {
            DebugSettings.removeDebugSettingChangeListener(this);
        }
    }
}

