/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter.handler;

import com.microsoft.java.debug.core.IDebugSession;
import com.microsoft.java.debug.core.IEvaluatableBreakpoint;
import com.microsoft.java.debug.core.IWatchpoint;
import com.microsoft.java.debug.core.Watchpoint;
import com.microsoft.java.debug.core.adapter.AdapterUtils;
import com.microsoft.java.debug.core.adapter.ErrorCode;
import com.microsoft.java.debug.core.adapter.IDebugAdapterContext;
import com.microsoft.java.debug.core.adapter.IDebugRequestHandler;
import com.microsoft.java.debug.core.adapter.IEvaluationProvider;
import com.microsoft.java.debug.core.adapter.handler.SetBreakpointsRequestHandler;
import com.microsoft.java.debug.core.protocol.Events;
import com.microsoft.java.debug.core.protocol.Messages;
import com.microsoft.java.debug.core.protocol.Requests;
import com.microsoft.java.debug.core.protocol.Responses;
import com.microsoft.java.debug.core.protocol.Types;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.WatchpointEvent;
import com.sun.jdi.request.EventRequestManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class SetDataBreakpointsRequestHandler
implements IDebugRequestHandler {
    private final Logger logger;
    private boolean registered = false;

    public SetDataBreakpointsRequestHandler(Logger logger) {
        this.logger = logger;
    }

    @Override
    public List<Requests.Command> getTargetCommands() {
        return Arrays.asList(Requests.Command.SETDATABREAKPOINTS);
    }

    @Override
    public CompletableFuture<Messages.Response> handle(Requests.Command command, Requests.Arguments arguments, Messages.Response response, IDebugAdapterContext iDebugAdapterContext) {
        Object object;
        if (iDebugAdapterContext.getDebugSession() == null) {
            return AdapterUtils.createAsyncErrorResponse(response, ErrorCode.EMPTY_DEBUG_SESSION, "Empty debug session.");
        }
        if (!this.registered) {
            this.registered = true;
            this.registerWatchpointHandler(iDebugAdapterContext);
        }
        Requests.SetDataBreakpointsArguments setDataBreakpointsArguments = (Requests.SetDataBreakpointsArguments)arguments;
        IWatchpoint[] iWatchpointArray = setDataBreakpointsArguments.breakpoints == null ? new Watchpoint[]{} : new Watchpoint[setDataBreakpointsArguments.breakpoints.length];
        for (int i = 0; i < iWatchpointArray.length; ++i) {
            String[] stringArray;
            object = setDataBreakpointsArguments.breakpoints[i];
            if (((Types.DataBreakpoint)object).dataId == null || (stringArray = ((Types.DataBreakpoint)object).dataId.split("#")).length != 2 || !StringUtils.isNotBlank((CharSequence)stringArray[0]) || !StringUtils.isNotBlank((CharSequence)stringArray[1])) continue;
            int n = 0;
            try {
                n = Integer.parseInt(((Types.DataBreakpoint)object).hitCondition);
            }
            catch (NumberFormatException numberFormatException) {
                n = 0;
            }
            String string = ((Types.DataBreakpoint)object).accessType != null ? ((Types.DataBreakpoint)object).accessType.label() : null;
            iWatchpointArray[i] = iDebugAdapterContext.getDebugSession().createWatchPoint(stringArray[0], stringArray[1], string, ((Types.DataBreakpoint)object).condition, n);
        }
        IWatchpoint[] iWatchpointArray2 = iDebugAdapterContext.getBreakpointManager().setWatchpoints(iWatchpointArray);
        object = new ArrayList();
        for (int i = 0; i < iWatchpointArray2.length; ++i) {
            if (iWatchpointArray2[i] == null) {
                object.add(new Types.Breakpoint(false));
                continue;
            }
            if (iWatchpointArray2[i] == iWatchpointArray[i]) {
                iWatchpointArray2[i].install().thenAccept(iWatchpoint -> {
                    Events.BreakpointEvent breakpointEvent = new Events.BreakpointEvent("new", this.convertDebuggerWatchpointToClient((IWatchpoint)iWatchpoint));
                    iDebugAdapterContext.getProtocolServer().sendEvent(breakpointEvent);
                });
            } else {
                if (iWatchpointArray2[i].getHitCount() != iWatchpointArray[i].getHitCount()) {
                    iWatchpointArray2[i].setHitCount(iWatchpointArray[i].getHitCount());
                }
                if (!Objects.equals(iWatchpointArray2[i].getCondition(), iWatchpointArray[i].getCondition())) {
                    iWatchpointArray2[i].setCondition(iWatchpointArray[i].getCondition());
                }
            }
            object.add(this.convertDebuggerWatchpointToClient(iWatchpointArray2[i]));
        }
        response.body = new Responses.SetDataBreakpointsResponseBody((List<Types.Breakpoint>)object);
        return CompletableFuture.completedFuture(response);
    }

    private Types.Breakpoint convertDebuggerWatchpointToClient(IWatchpoint iWatchpoint) {
        return new Types.Breakpoint((Integer)iWatchpoint.getProperty("id"), iWatchpoint.getProperty("verified") != null && (Boolean)iWatchpoint.getProperty("verified") != false);
    }

    private void registerWatchpointHandler(IDebugAdapterContext iDebugAdapterContext) {
        IDebugSession iDebugSession = iDebugAdapterContext.getDebugSession();
        if (iDebugSession != null) {
            iDebugSession.getEventHub().events().filter(debugEvent -> debugEvent.event instanceof WatchpointEvent).subscribe(debugEvent -> {
                Event event = debugEvent.event;
                ThreadReference threadReference = ((WatchpointEvent)event).thread();
                IEvaluationProvider iEvaluationProvider = iDebugAdapterContext.getProvider(IEvaluationProvider.class);
                if (iEvaluationProvider.isInEvaluation(threadReference)) {
                    return;
                }
                IWatchpoint iWatchpoint2 = Stream.of(iDebugAdapterContext.getBreakpointManager().getWatchpoints()).filter(iWatchpoint -> iWatchpoint instanceof IEvaluatableBreakpoint && ((IEvaluatableBreakpoint)((Object)iWatchpoint)).containsEvaluatableExpression() && iWatchpoint.requests().contains(event.request())).findFirst().orElse(null);
                if (iWatchpoint2 != null) {
                    CompletableFuture.runAsync(() -> iEvaluationProvider.evaluateForBreakpoint((IEvaluatableBreakpoint)((Object)iWatchpoint2), threadReference).whenComplete((value, throwable) -> {
                        boolean bl = SetBreakpointsRequestHandler.handleEvaluationResult(iDebugAdapterContext, threadReference, (IEvaluatableBreakpoint)((Object)iWatchpoint2), value, throwable, this.logger);
                        iEvaluationProvider.clearState(threadReference);
                        if (bl) {
                            debugEvent.eventSet.resume();
                        } else {
                            this.notifyStoppedThread(iDebugAdapterContext, threadReference.uniqueID());
                        }
                    }));
                } else {
                    this.notifyStoppedThread(iDebugAdapterContext, threadReference.uniqueID());
                }
                debugEvent.shouldResume = false;
            });
        }
    }

    private void notifyStoppedThread(IDebugAdapterContext iDebugAdapterContext, long l) {
        EventRequestManager eventRequestManager = iDebugAdapterContext.getDebugSession().getVM().eventRequestManager();
        iDebugAdapterContext.getStepRequestManager().deletePendingStep(l, eventRequestManager);
        iDebugAdapterContext.getProtocolServer().sendEvent(new Events.StoppedEvent("data breakpoint", l));
    }
}

