/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter.handler;

import com.microsoft.java.debug.core.DebugException;
import com.microsoft.java.debug.core.IBreakpoint;
import com.microsoft.java.debug.core.IDebugSession;
import com.microsoft.java.debug.core.IEvaluatableBreakpoint;
import com.microsoft.java.debug.core.adapter.AdapterUtils;
import com.microsoft.java.debug.core.adapter.ErrorCode;
import com.microsoft.java.debug.core.adapter.HotCodeReplaceEvent;
import com.microsoft.java.debug.core.adapter.IDebugAdapterContext;
import com.microsoft.java.debug.core.adapter.IDebugRequestHandler;
import com.microsoft.java.debug.core.adapter.IEvaluationProvider;
import com.microsoft.java.debug.core.adapter.IHotCodeReplaceProvider;
import com.microsoft.java.debug.core.adapter.ISourceLookUpProvider;
import com.microsoft.java.debug.core.adapter.IStepFilterProvider;
import com.microsoft.java.debug.core.protocol.Events;
import com.microsoft.java.debug.core.protocol.Messages;
import com.microsoft.java.debug.core.protocol.Requests;
import com.microsoft.java.debug.core.protocol.Responses;
import com.microsoft.java.debug.core.protocol.Types;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.Field;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.Value;
import com.sun.jdi.event.BreakpointEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.StepEvent;
import com.sun.jdi.request.EventRequestManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public class SetBreakpointsRequestHandler
implements IDebugRequestHandler {
    private final Logger logger;
    private boolean registered = false;

    public SetBreakpointsRequestHandler(Logger logger) {
        this.logger = logger;
    }

    @Override
    public List<Requests.Command> getTargetCommands() {
        return Arrays.asList(Requests.Command.SETBREAKPOINTS);
    }

    @Override
    public void initialize(IDebugAdapterContext iDebugAdapterContext) {
        IDebugRequestHandler.super.initialize(iDebugAdapterContext);
        IHotCodeReplaceProvider iHotCodeReplaceProvider = iDebugAdapterContext.getProvider(IHotCodeReplaceProvider.class);
        iHotCodeReplaceProvider.getEventHub().filter(hotCodeReplaceEvent -> hotCodeReplaceEvent.getEventType() == HotCodeReplaceEvent.EventType.END).subscribe(hotCodeReplaceEvent -> {
            try {
                List list = (List)hotCodeReplaceEvent.getData();
                this.reinstallBreakpoints(iDebugAdapterContext, list);
            }
            catch (Exception exception) {
                this.logger.severe(exception.toString());
            }
        });
    }

    @Override
    public CompletableFuture<Messages.Response> handle(Requests.Command command, Requests.Arguments arguments, Messages.Response response, IDebugAdapterContext iDebugAdapterContext) {
        String string;
        if (iDebugAdapterContext.getDebugSession() == null) {
            return AdapterUtils.createAsyncErrorResponse(response, ErrorCode.EMPTY_DEBUG_SESSION, "Empty debug session.");
        }
        if (!this.registered) {
            this.registered = true;
            this.registerBreakpointHandler(iDebugAdapterContext);
        }
        Requests.SetBreakpointArguments setBreakpointArguments = (Requests.SetBreakpointArguments)arguments;
        String string2 = setBreakpointArguments.source.path;
        if (AdapterUtils.isWindows() && (string = FilenameUtils.getPrefix((String)string2)) != null && string.length() >= 2 && Character.isLowerCase(string.charAt(0)) && string.charAt(1) == ':') {
            string = string.substring(0, 2);
            string2 = string2.replaceFirst(string, string.toUpperCase());
        }
        string = string2;
        if (setBreakpointArguments.source.sourceReference != 0 && iDebugAdapterContext.getSourceUri(setBreakpointArguments.source.sourceReference) != null) {
            string = iDebugAdapterContext.getSourceUri(setBreakpointArguments.source.sourceReference);
        } else if (StringUtils.isNotBlank((CharSequence)string2)) {
            string = AdapterUtils.convertPath(string2, AdapterUtils.isUri(string2), iDebugAdapterContext.isDebuggerPathsAreUri());
        }
        if (StringUtils.isBlank((CharSequence)string)) {
            throw AdapterUtils.createCompletionException(String.format("Failed to setBreakpoint. Reason: '%s' is an invalid path.", setBreakpointArguments.source.path), ErrorCode.SET_BREAKPOINT_FAILURE);
        }
        try {
            ArrayList<Types.Breakpoint> arrayList = new ArrayList<Types.Breakpoint>();
            IBreakpoint[] iBreakpointArray = this.convertClientBreakpointsToDebugger(string, setBreakpointArguments.breakpoints, iDebugAdapterContext);
            IBreakpoint[] iBreakpointArray2 = iDebugAdapterContext.getBreakpointManager().setBreakpoints(AdapterUtils.decodeURIComponent(string), iBreakpointArray, setBreakpointArguments.sourceModified);
            for (int i = 0; i < setBreakpointArguments.breakpoints.length; ++i) {
                if (iBreakpointArray[i] == iBreakpointArray2[i] && iBreakpointArray2[i].className() != null) {
                    iBreakpointArray2[i].install().thenAccept(iBreakpoint -> {
                        Events.BreakpointEvent breakpointEvent = new Events.BreakpointEvent("new", this.convertDebuggerBreakpointToClient((IBreakpoint)iBreakpoint, iDebugAdapterContext));
                        iDebugAdapterContext.getProtocolServer().sendEvent(breakpointEvent);
                    });
                } else if (iBreakpointArray2[i].className() != null) {
                    if (iBreakpointArray[i].getHitCount() != iBreakpointArray2[i].getHitCount()) {
                        iBreakpointArray2[i].setHitCount(iBreakpointArray[i].getHitCount());
                    }
                    if (!StringUtils.equals((CharSequence)iBreakpointArray[i].getLogMessage(), (CharSequence)iBreakpointArray2[i].getLogMessage())) {
                        iBreakpointArray2[i].setLogMessage(iBreakpointArray[i].getLogMessage());
                    }
                    if (!StringUtils.equals((CharSequence)iBreakpointArray[i].getCondition(), (CharSequence)iBreakpointArray2[i].getCondition())) {
                        iBreakpointArray2[i].setCondition(iBreakpointArray[i].getCondition());
                    }
                }
                arrayList.add(this.convertDebuggerBreakpointToClient(iBreakpointArray2[i], iDebugAdapterContext));
            }
            response.body = new Responses.SetBreakpointsResponseBody(arrayList);
            return CompletableFuture.completedFuture(response);
        }
        catch (DebugException debugException) {
            throw AdapterUtils.createCompletionException(String.format("Failed to setBreakpoint. Reason: '%s'", debugException.toString()), ErrorCode.SET_BREAKPOINT_FAILURE);
        }
    }

    private IBreakpoint getAssociatedEvaluatableBreakpoint(IDebugAdapterContext iDebugAdapterContext, BreakpointEvent breakpointEvent) {
        return Arrays.asList(iDebugAdapterContext.getBreakpointManager().getBreakpoints()).stream().filter(iBreakpoint -> iBreakpoint instanceof IEvaluatableBreakpoint && ((IEvaluatableBreakpoint)((Object)iBreakpoint)).containsEvaluatableExpression() && iBreakpoint.requests().contains(breakpointEvent.request())).findFirst().orElse(null);
    }

    private void registerBreakpointHandler(IDebugAdapterContext iDebugAdapterContext) {
        IDebugSession iDebugSession = iDebugAdapterContext.getDebugSession();
        IStepFilterProvider iStepFilterProvider = iDebugAdapterContext.getProvider(IStepFilterProvider.class);
        if (iDebugSession != null) {
            iDebugSession.getEventHub().events().filter(debugEvent -> debugEvent.event instanceof BreakpointEvent).subscribe(debugEvent -> {
                Event event2 = debugEvent.event;
                if (debugEvent.eventSet.size() <= 1 || !debugEvent.eventSet.stream().anyMatch(event -> event instanceof StepEvent)) {
                    ThreadReference threadReference = ((BreakpointEvent)event2).thread();
                    IEvaluationProvider iEvaluationProvider = iDebugAdapterContext.getProvider(IEvaluationProvider.class);
                    if (iEvaluationProvider.isInEvaluation(threadReference)) {
                        debugEvent.shouldResume = true;
                        return;
                    }
                    Method method = threadReference.frame(0).location().method();
                    if (iStepFilterProvider.shouldSkipOver(method, iDebugAdapterContext.getStepFilters())) {
                        debugEvent.shouldResume = true;
                        return;
                    }
                    IBreakpoint iBreakpoint = this.getAssociatedEvaluatableBreakpoint(iDebugAdapterContext, (BreakpointEvent)event2);
                    if (iBreakpoint != null) {
                        CompletableFuture.runAsync(() -> iEvaluationProvider.evaluateForBreakpoint((IEvaluatableBreakpoint)((Object)iBreakpoint), threadReference).whenComplete((value, throwable) -> {
                            boolean bl = SetBreakpointsRequestHandler.handleEvaluationResult(iDebugAdapterContext, threadReference, (IEvaluatableBreakpoint)((Object)iBreakpoint), value, throwable, this.logger);
                            iEvaluationProvider.clearState(threadReference);
                            if (bl) {
                                debugEvent.eventSet.resume();
                            } else {
                                this.notifyStoppedThread(iDebugAdapterContext, threadReference.uniqueID());
                            }
                        }));
                    } else {
                        this.notifyStoppedThread(iDebugAdapterContext, threadReference.uniqueID());
                    }
                    debugEvent.shouldResume = false;
                }
            });
        }
    }

    private void notifyStoppedThread(IDebugAdapterContext iDebugAdapterContext, long l) {
        EventRequestManager eventRequestManager = iDebugAdapterContext.getDebugSession().getVM().eventRequestManager();
        iDebugAdapterContext.getStepRequestManager().deletePendingStep(l, eventRequestManager);
        iDebugAdapterContext.getProtocolServer().sendEvent(new Events.StoppedEvent("breakpoint", l));
    }

    public static boolean handleEvaluationResult(IDebugAdapterContext iDebugAdapterContext, ThreadReference threadReference, IEvaluatableBreakpoint iEvaluatableBreakpoint, Value value, Throwable throwable, Logger logger) {
        if (StringUtils.isNotBlank((CharSequence)iEvaluatableBreakpoint.getLogMessage())) {
            if (throwable != null) {
                logger.log(Level.SEVERE, String.format("[Logpoint]: %s", throwable.getMessage() != null ? throwable.getMessage() : throwable.toString()), throwable);
                iDebugAdapterContext.getProtocolServer().sendEvent(new Events.UserNotificationEvent(Events.UserNotificationEvent.NotificationType.ERROR, String.format("[Logpoint] Log message '%s' error: %s", iEvaluatableBreakpoint.getLogMessage(), throwable.getMessage())));
            }
            return true;
        }
        boolean bl = false;
        boolean bl2 = false;
        if (value != null && throwable == null) {
            if (value instanceof BooleanValue) {
                bl = !((BooleanValue)value).booleanValue();
            } else if (value instanceof ObjectReference && ((ObjectReference)value).type().name().equals("java.lang.Boolean")) {
                Field field = ((ReferenceType)((ObjectReference)value).type()).fieldByName("value");
                bl = !((BooleanValue)((ObjectReference)value).getValue(field)).booleanValue();
            } else {
                bl2 = true;
            }
        }
        if (bl) {
            return true;
        }
        if (!iDebugAdapterContext.isVmTerminated()) {
            if (throwable != null) {
                if (!(throwable instanceof VMDisconnectedException) && !(throwable.getCause() instanceof VMDisconnectedException)) {
                    logger.log(Level.SEVERE, String.format("[ConditionalBreakpoint]: %s", throwable.getMessage() != null ? throwable.getMessage() : throwable.toString()), throwable);
                    iDebugAdapterContext.getProtocolServer().sendEvent(new Events.UserNotificationEvent(Events.UserNotificationEvent.NotificationType.ERROR, String.format("Breakpoint condition '%s' error: %s", iEvaluatableBreakpoint.getCondition(), throwable.getMessage())));
                }
            } else if (value == null || bl2) {
                iDebugAdapterContext.getProtocolServer().sendEvent(new Events.UserNotificationEvent(Events.UserNotificationEvent.NotificationType.WARNING, String.format("Result of breakpoint condition '%s' is not a boolean, please correct your expression.", iEvaluatableBreakpoint.getCondition())));
            }
        }
        return false;
    }

    private Types.Breakpoint convertDebuggerBreakpointToClient(IBreakpoint iBreakpoint, IDebugAdapterContext iDebugAdapterContext) {
        int n = (Integer)iBreakpoint.getProperty("id");
        boolean bl = iBreakpoint.getProperty("verified") != null && (Boolean)iBreakpoint.getProperty("verified") != false;
        int n2 = AdapterUtils.convertLineNumber(iBreakpoint.getLineNumber(), iDebugAdapterContext.isDebuggerLinesStartAt1(), iDebugAdapterContext.isClientLinesStartAt1());
        return new Types.Breakpoint(n, bl, n2, "");
    }

    private IBreakpoint[] convertClientBreakpointsToDebugger(String string, Types.SourceBreakpoint[] sourceBreakpointArray, IDebugAdapterContext iDebugAdapterContext) throws DebugException {
        int[] nArray = Arrays.asList(sourceBreakpointArray).stream().map(sourceBreakpoint -> AdapterUtils.convertLineNumber(sourceBreakpoint.line, iDebugAdapterContext.isClientLinesStartAt1(), iDebugAdapterContext.isDebuggerLinesStartAt1())).mapToInt(n -> n).toArray();
        ISourceLookUpProvider iSourceLookUpProvider = iDebugAdapterContext.getProvider(ISourceLookUpProvider.class);
        String[] stringArray = iSourceLookUpProvider.getFullyQualifiedName(string, nArray, null);
        IBreakpoint[] iBreakpointArray = new IBreakpoint[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = 0;
            try {
                n2 = Integer.parseInt(sourceBreakpointArray[i].hitCondition);
            }
            catch (NumberFormatException numberFormatException) {
                n2 = 0;
            }
            iBreakpointArray[i] = iDebugAdapterContext.getDebugSession().createBreakpoint(stringArray[i], nArray[i], n2, sourceBreakpointArray[i].condition, sourceBreakpointArray[i].logMessage);
            if (!iSourceLookUpProvider.supportsRealtimeBreakpointVerification() || !StringUtils.isNotBlank((CharSequence)stringArray[i])) continue;
            iBreakpointArray[i].putProperty("verified", true);
        }
        return iBreakpointArray;
    }

    private void reinstallBreakpoints(IDebugAdapterContext iDebugAdapterContext, List<String> list) {
        IBreakpoint[] iBreakpointArray;
        if (list == null || list.isEmpty()) {
            return;
        }
        for (IBreakpoint iBreakpoint2 : iBreakpointArray = iDebugAdapterContext.getBreakpointManager().getBreakpoints()) {
            if (!list.contains(iBreakpoint2.className())) continue;
            try {
                iBreakpoint2.close();
                iBreakpoint2.install().thenAccept(iBreakpoint -> {
                    Events.BreakpointEvent breakpointEvent = new Events.BreakpointEvent("new", this.convertDebuggerBreakpointToClient((IBreakpoint)iBreakpoint, iDebugAdapterContext));
                    iDebugAdapterContext.getProtocolServer().sendEvent(breakpointEvent);
                });
            }
            catch (Exception exception) {
                this.logger.log(Level.SEVERE, String.format("Remove breakpoint exception: %s", exception.toString()), exception);
            }
        }
    }
}

