/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter.handler;

import com.microsoft.java.debug.core.adapter.AdapterUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.apache.commons.lang3.ArrayUtils;

public class LaunchUtils {
    private static Set<Path> tempFilesInUse = new HashSet<Path>();
    private static Path tmpdir = null;

    public static synchronized Path generateClasspathJar(String[] stringArray) throws IOException {
        String string2;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : stringArray) {
            arrayList.add(AdapterUtils.toUrl(string2));
        }
        Manifest manifest = new Manifest();
        Attributes attributes = manifest.getMainAttributes();
        attributes.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        String string3 = String.join((CharSequence)" ", arrayList);
        attributes.put(Attributes.Name.CLASS_PATH, string3);
        string2 = "cp_" + LaunchUtils.getMd5(string3);
        LaunchUtils.cleanupTempFiles(string2, ".jar");
        Path path = LaunchUtils.createTempFile(string2, ".jar");
        JarOutputStream jarOutputStream = new JarOutputStream((OutputStream)new FileOutputStream(path.toFile()), manifest);
        jarOutputStream.close();
        LaunchUtils.lockTempLaunchFile(path);
        return path;
    }

    public static synchronized Path generateArgfile(String[] stringArray, String[] stringArray2) throws IOException {
        String string = "";
        if (ArrayUtils.isNotEmpty((Object[])stringArray)) {
            string = "-cp \"" + String.join((CharSequence)File.pathSeparator, stringArray) + "\"";
        }
        if (ArrayUtils.isNotEmpty((Object[])stringArray2)) {
            string = string + " --module-path \"" + String.join((CharSequence)File.pathSeparator, stringArray2) + "\"";
        }
        string = string.replace("\\", "\\\\");
        String string2 = "cp_" + LaunchUtils.getMd5(string);
        LaunchUtils.cleanupTempFiles(string2, ".argfile");
        Path path = LaunchUtils.createTempFile(string2, ".argfile");
        Files.write(path, string.getBytes(), new OpenOption[0]);
        LaunchUtils.lockTempLaunchFile(path);
        return path;
    }

    public static void lockTempLaunchFile(Path path) {
        if (path != null) {
            tempFilesInUse.add(path);
        }
    }

    public static void releaseTempLaunchFile(Path path) {
        if (path != null) {
            tempFilesInUse.remove(path);
        }
    }

    private static synchronized Path getTmpDir() throws IOException {
        if (tmpdir == null) {
            Path path = Files.createTempFile("", UUID.randomUUID().toString(), new FileAttribute[0]);
            tmpdir = path.getParent();
            try {
                Files.deleteIfExists(path);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return tmpdir;
    }

    private static void cleanupTempFiles(String string, String string2) throws IOException {
        int n = 0;
        while (true) {
            Path path;
            if (!tempFilesInUse.contains(path = LaunchUtils.getTmpDir().resolve(string + (n == 0 ? "" : Integer.valueOf(n)) + string2))) {
                if (!Files.exists(path, new LinkOption[0])) break;
                try {
                    Files.deleteIfExists(path);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++n;
        }
    }

    private static Path createTempFile(String string, String string2) throws IOException {
        int n = 0;
        Path path;
        while (Files.exists(path = LaunchUtils.getTmpDir().resolve(string + (n == 0 ? "" : Integer.valueOf(n)) + string2), new LinkOption[0])) {
            ++n;
        }
        return Files.createFile(path, new FileAttribute[0]);
    }

    private static String getMd5(String string) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byte[] byArray = messageDigest.digest(string.getBytes());
            BigInteger bigInteger = new BigInteger(1, byArray);
            return bigInteger.toString(36);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return Integer.toString(string.hashCode(), 36);
        }
    }
}

