/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter.handler;

import com.microsoft.java.debug.core.DebugException;
import com.microsoft.java.debug.core.DebugSettings;
import com.microsoft.java.debug.core.DebugUtility;
import com.microsoft.java.debug.core.IDebugSession;
import com.microsoft.java.debug.core.adapter.AdapterUtils;
import com.microsoft.java.debug.core.adapter.ErrorCode;
import com.microsoft.java.debug.core.adapter.IDebugAdapterContext;
import com.microsoft.java.debug.core.adapter.IDebugRequestHandler;
import com.microsoft.java.debug.core.adapter.LaunchMode;
import com.microsoft.java.debug.core.adapter.ProcessConsole;
import com.microsoft.java.debug.core.adapter.handler.ILaunchDelegate;
import com.microsoft.java.debug.core.adapter.handler.LaunchUtils;
import com.microsoft.java.debug.core.adapter.handler.LaunchWithDebuggingDelegate;
import com.microsoft.java.debug.core.adapter.handler.LaunchWithoutDebuggingDelegate;
import com.microsoft.java.debug.core.adapter.handler.StackTraceRequestHandler;
import com.microsoft.java.debug.core.protocol.Events;
import com.microsoft.java.debug.core.protocol.Messages;
import com.microsoft.java.debug.core.protocol.Requests;
import com.microsoft.java.debug.core.protocol.Types;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.connect.VMStartException;
import com.sun.jdi.event.VMDisconnectEvent;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class LaunchRequestHandler
implements IDebugRequestHandler {
    protected final Logger logger;
    protected static final long RUNINTERMINAL_TIMEOUT = 10000L;
    protected ILaunchDelegate activeLaunchHandler;
    private CompletableFuture<Boolean> waitForDebuggeeConsole = new CompletableFuture();
    private static final Pattern STACKTRACE_PATTERN = Pattern.compile("\\s+at\\s+([\\w$\\.]+\\/)?(([\\w$]+\\.)+[<\\w$>]+)\\(([\\w-$]+\\.java:\\d+)\\)");

    public LaunchRequestHandler(Logger logger) {
        this.logger = logger;
    }

    @Override
    public List<Requests.Command> getTargetCommands() {
        return Arrays.asList(Requests.Command.LAUNCH);
    }

    @Override
    public CompletableFuture<Messages.Response> handle(Requests.Command command, Requests.Arguments arguments, Messages.Response response, IDebugAdapterContext iDebugAdapterContext) {
        Requests.LaunchArguments launchArguments = (Requests.LaunchArguments)arguments;
        this.activeLaunchHandler = launchArguments.noDebug ? new LaunchWithoutDebuggingDelegate(this::handleTerminatedEvent, this.logger) : new LaunchWithDebuggingDelegate(this.logger);
        return this.handleLaunchCommand(arguments, response, iDebugAdapterContext);
    }

    protected CompletableFuture<Messages.Response> handleLaunchCommand(Requests.Arguments arguments, Messages.Response response2, IDebugAdapterContext iDebugAdapterContext) {
        Requests.LaunchArguments launchArguments = (Requests.LaunchArguments)arguments;
        if (StringUtils.isBlank((CharSequence)launchArguments.mainClass) || ArrayUtils.isEmpty((Object[])launchArguments.modulePaths) && ArrayUtils.isEmpty((Object[])launchArguments.classPaths)) {
            throw AdapterUtils.createCompletionException("Failed to launch debuggee VM. Missing mainClass or modulePaths/classPaths options in launch configuration.", ErrorCode.ARGUMENT_MISSING);
        }
        if (StringUtils.isNotBlank((CharSequence)launchArguments.encoding)) {
            if (!Charset.isSupported(launchArguments.encoding)) {
                throw AdapterUtils.createCompletionException("Failed to launch debuggee VM. 'encoding' options in the launch configuration is not recognized.", ErrorCode.INVALID_ENCODING);
            }
            iDebugAdapterContext.setDebuggeeEncoding(Charset.forName(launchArguments.encoding));
            launchArguments.vmArgs = StringUtils.isBlank((CharSequence)launchArguments.vmArgs) ? String.format("-Dfile.encoding=%s", iDebugAdapterContext.getDebuggeeEncoding().name()) : String.format("%s -Dfile.encoding=%s", launchArguments.vmArgs, iDebugAdapterContext.getDebuggeeEncoding().name());
        }
        iDebugAdapterContext.setLaunchMode(launchArguments.noDebug ? LaunchMode.NO_DEBUG : LaunchMode.DEBUG);
        this.activeLaunchHandler.preLaunch(launchArguments, iDebugAdapterContext);
        if (launchArguments.shortenCommandLine == Requests.ShortenApproach.JARMANIFEST) {
            if (ArrayUtils.isNotEmpty((Object[])launchArguments.classPaths)) {
                try {
                    Path path = LaunchUtils.generateClasspathJar(launchArguments.classPaths);
                    launchArguments.vmArgs = launchArguments.vmArgs + " -cp \"" + path.toAbsolutePath().toString() + "\"";
                    launchArguments.classPaths = new String[0];
                    iDebugAdapterContext.setClasspathJar(path);
                }
                catch (IllegalArgumentException | MalformedURLException exception) {
                    this.logger.log(Level.SEVERE, String.format("Failed to launch the program with jarmanifest style: %s", exception.toString(), exception));
                    throw AdapterUtils.createCompletionException("Failed to launch the program with jarmanifest style: " + exception.toString(), ErrorCode.LAUNCH_FAILURE, exception);
                }
                catch (IOException iOException) {
                    this.logger.log(Level.SEVERE, String.format("Failed to create a temp classpath.jar: %s", iOException.toString()), iOException);
                }
            }
        } else if (launchArguments.shortenCommandLine == Requests.ShortenApproach.ARGFILE) {
            try {
                Path path = LaunchUtils.generateArgfile(launchArguments.classPaths, launchArguments.modulePaths);
                launchArguments.vmArgs = launchArguments.vmArgs + " \"@" + path.toAbsolutePath().toString() + "\"";
                launchArguments.classPaths = new String[0];
                launchArguments.modulePaths = new String[0];
                iDebugAdapterContext.setArgsfile(path);
            }
            catch (IOException iOException) {
                this.logger.log(Level.SEVERE, String.format("Failed to create a temp argfile: %s", iOException.toString()), iOException);
            }
        }
        return this.launch(launchArguments, response2, iDebugAdapterContext).thenCompose(response -> {
            IDebugSession iDebugSession;
            LaunchUtils.releaseTempLaunchFile(iDebugAdapterContext.getClasspathJar());
            LaunchUtils.releaseTempLaunchFile(iDebugAdapterContext.getArgsfile());
            if (response.success) {
                this.activeLaunchHandler.postLaunch(launchArguments, iDebugAdapterContext);
            }
            if ((iDebugSession = iDebugAdapterContext.getDebugSession()) != null) {
                iDebugSession.getEventHub().events().filter(debugEvent -> debugEvent.event instanceof VMDisconnectEvent).subscribe(debugEvent -> {
                    iDebugAdapterContext.setVmTerminated();
                    try {
                        iDebugSession.getEventHub().close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.handleTerminatedEvent(iDebugAdapterContext);
                });
            }
            return CompletableFuture.completedFuture(response);
        });
    }

    protected void handleTerminatedEvent(IDebugAdapterContext iDebugAdapterContext) {
        CompletableFuture.runAsync(() -> {
            try {
                this.waitForDebuggeeConsole.get(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException exception) {
                // empty catch block
            }
            iDebugAdapterContext.getProtocolServer().sendEvent(new Events.TerminatedEvent());
        });
    }

    public static String[] constructLaunchCommands(Requests.LaunchArguments launchArguments, boolean bl, String string) {
        String[] stringArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (launchArguments.launcherScript != null) {
            arrayList.add(launchArguments.launcherScript);
        }
        if (StringUtils.isNotBlank((CharSequence)launchArguments.javaExec)) {
            arrayList.add(launchArguments.javaExec);
        } else {
            stringArray = StringUtils.isNotEmpty((CharSequence)DebugSettings.getCurrent().javaHome) ? DebugSettings.getCurrent().javaHome : System.getProperty("java.home");
            arrayList.add(Paths.get((String)stringArray, "bin", "java").toString());
        }
        if (StringUtils.isNotEmpty((CharSequence)string)) {
            arrayList.add(String.format("-agentlib:jdwp=transport=dt_socket,server=%s,suspend=y,address=%s", bl ? "y" : "n", string));
        }
        if (StringUtils.isNotBlank((CharSequence)launchArguments.vmArgs)) {
            arrayList.addAll(DebugUtility.parseArguments(launchArguments.vmArgs));
        }
        if (ArrayUtils.isNotEmpty((Object[])launchArguments.modulePaths)) {
            arrayList.add("--module-path");
            arrayList.add(String.join((CharSequence)File.pathSeparator, launchArguments.modulePaths));
        }
        if (ArrayUtils.isNotEmpty((Object[])launchArguments.classPaths)) {
            arrayList.add("-cp");
            arrayList.add(String.join((CharSequence)File.pathSeparator, launchArguments.classPaths));
        }
        if ((stringArray = launchArguments.mainClass.split("/")).length == 2) {
            arrayList.add("-m");
        }
        arrayList.add(launchArguments.mainClass);
        if (StringUtils.isNotBlank((CharSequence)launchArguments.args)) {
            arrayList.addAll(DebugUtility.parseArguments(launchArguments.args));
        }
        return arrayList.toArray(new String[0]);
    }

    protected CompletableFuture<Messages.Response> launch(Requests.LaunchArguments launchArguments, Messages.Response response, IDebugAdapterContext iDebugAdapterContext) {
        this.logger.info("Trying to launch Java Program with options:\n" + String.format("main-class: %s\n", launchArguments.mainClass) + String.format("args: %s\n", launchArguments.args) + String.format("module-path: %s\n", StringUtils.join((Object[])launchArguments.modulePaths, (String)File.pathSeparator)) + String.format("class-path: %s\n", StringUtils.join((Object[])launchArguments.classPaths, (String)File.pathSeparator)) + String.format("vmArgs: %s", launchArguments.vmArgs));
        if (iDebugAdapterContext.supportsRunInTerminalRequest() && (launchArguments.console == Requests.CONSOLE.integratedTerminal || launchArguments.console == Requests.CONSOLE.externalTerminal)) {
            this.waitForDebuggeeConsole.complete(true);
            return this.activeLaunchHandler.launchInTerminal(launchArguments, response, iDebugAdapterContext);
        }
        CompletableFuture<Messages.Response> completableFuture = new CompletableFuture<Messages.Response>();
        try {
            Process process = this.activeLaunchHandler.launch(launchArguments, iDebugAdapterContext);
            iDebugAdapterContext.setDebuggeeProcess(process);
            ProcessConsole processConsole = new ProcessConsole(process, "Debuggee", iDebugAdapterContext.getDebuggeeEncoding());
            processConsole.lineMessages().map(consoleMessage -> LaunchRequestHandler.convertToOutputEvent(consoleMessage.output, consoleMessage.category, iDebugAdapterContext)).doFinally(() -> this.waitForDebuggeeConsole.complete(true)).subscribe(outputEvent -> iDebugAdapterContext.getProtocolServer().sendEvent((Events.DebugEvent)outputEvent));
            processConsole.start();
            completableFuture.complete(response);
        }
        catch (IllegalConnectorArgumentsException | VMStartException | IOException exception) {
            completableFuture.completeExceptionally(new DebugException(String.format("Failed to launch debuggee VM. Reason: %s", exception.toString()), ErrorCode.LAUNCH_FAILURE.getId()));
        }
        return completableFuture;
    }

    private static Events.OutputEvent convertToOutputEvent(String string, Events.OutputEvent.Category category, IDebugAdapterContext iDebugAdapterContext) {
        Matcher matcher = STACKTRACE_PATTERN.matcher(string);
        if (matcher.find()) {
            String string2 = matcher.group(2);
            String string3 = matcher.group(matcher.groupCount());
            String string4 = string2.substring(0, string2.lastIndexOf("."));
            String string5 = string4.lastIndexOf(".") > -1 ? string4.substring(0, string4.lastIndexOf(".")) : "";
            String[] stringArray = string3.split(":");
            String string6 = stringArray[0];
            int n = Integer.parseInt(stringArray[1]);
            String string7 = StringUtils.isBlank((CharSequence)string5) ? string6 : string5.replace('.', File.separatorChar) + File.separatorChar + string6;
            Types.Source source = null;
            try {
                source = StackTraceRequestHandler.convertDebuggerSourceToClient(string4, string6, string7, iDebugAdapterContext);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
            return new Events.OutputEvent(category, string, source, n);
        }
        return new Events.OutputEvent(category, string);
    }

    public static String parseMainClassWithoutModuleName(String string) {
        int n = string.indexOf(47);
        return string.substring(n + 1);
    }
}

