/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter.handler;

import com.microsoft.java.debug.core.DebugSettings;
import com.microsoft.java.debug.core.adapter.IDebugAdapterContext;
import com.microsoft.java.debug.core.adapter.IDebugRequestHandler;
import com.microsoft.java.debug.core.adapter.IEvaluationProvider;
import com.microsoft.java.debug.core.adapter.IStackFrameManager;
import com.microsoft.java.debug.core.adapter.variables.IVariableFormatter;
import com.microsoft.java.debug.core.adapter.variables.JavaLogicalStructure;
import com.microsoft.java.debug.core.adapter.variables.JavaLogicalStructureManager;
import com.microsoft.java.debug.core.adapter.variables.StackFrameReference;
import com.microsoft.java.debug.core.adapter.variables.Variable;
import com.microsoft.java.debug.core.adapter.variables.VariableDetailUtils;
import com.microsoft.java.debug.core.protocol.Messages;
import com.microsoft.java.debug.core.protocol.Requests;
import com.microsoft.java.debug.core.protocol.Responses;
import com.microsoft.java.debug.core.protocol.Types;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.Field;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StackFrame;
import com.sun.jdi.Value;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.math.NumberUtils;

public class InlineValuesRequestHandler
implements IDebugRequestHandler {
    protected final Logger logger;

    public InlineValuesRequestHandler(Logger logger) {
        this.logger = logger;
    }

    @Override
    public List<Requests.Command> getTargetCommands() {
        return Arrays.asList(Requests.Command.INLINEVALUES);
    }

    @Override
    public CompletableFuture<Messages.Response> handle(Requests.Command command, Requests.Arguments arguments, Messages.Response response, IDebugAdapterContext iDebugAdapterContext) {
        Object object;
        Requests.InlineValuesArguments inlineValuesArguments = (Requests.InlineValuesArguments)arguments;
        int n = inlineValuesArguments == null || inlineValuesArguments.variables == null ? 0 : inlineValuesArguments.variables.length;
        Requests.InlineVariable[] inlineVariableArray = inlineValuesArguments.variables;
        StackFrameReference stackFrameReference = (StackFrameReference)iDebugAdapterContext.getRecyclableIdPool().getObjectById(inlineValuesArguments.frameId);
        if (stackFrameReference == null) {
            this.logger.log(Level.SEVERE, String.format("InlineValues failed: invalid stackframe id %d.", inlineValuesArguments.frameId));
            response.body = new Responses.InlineValuesResponse(null);
            return CompletableFuture.completedFuture(response);
        }
        IStackFrameManager iStackFrameManager = iDebugAdapterContext.getStackFrameManager();
        StackFrame stackFrame = iStackFrameManager.getStackFrame(stackFrameReference);
        if (stackFrame == null) {
            this.logger.log(Level.SEVERE, String.format("InlineValues failed: stale stackframe id %d.", inlineValuesArguments.frameId));
            response.body = new Responses.InlineValuesResponse(null);
            return CompletableFuture.completedFuture(response);
        }
        Variable[] variableArray = new Variable[n];
        try {
            if (InlineValuesRequestHandler.isLambdaFrame(stackFrame)) {
                object = stackFrameReference.getThread().frame(stackFrameReference.getDepth() + 1);
                this.resolveValuesFromThisVariable(object.thisObject(), inlineVariableArray, variableArray, true);
            }
            this.resolveValuesFromThisVariable(stackFrame.thisObject(), inlineVariableArray, variableArray, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = new Types.Variable[n];
        IVariableFormatter iVariableFormatter = iDebugAdapterContext.getVariableFormatter();
        Map<String, Object> map = iVariableFormatter.getDefaultOptions();
        HashMap<Requests.InlineVariable, Object> hashMap = new HashMap<Requests.InlineVariable, Object>();
        IEvaluationProvider iEvaluationProvider = iDebugAdapterContext.getProvider(IEvaluationProvider.class);
        for (int i = 0; i < n; ++i) {
            Object object2;
            if (variableArray[i] == null) continue;
            if (hashMap.containsKey(inlineVariableArray[i])) {
                object[i] = (Types.Variable)hashMap.get(inlineVariableArray[i]);
                continue;
            }
            Value value = variableArray[i].value;
            String string = variableArray[i].name;
            int n2 = -1;
            Value value2 = null;
            if (value instanceof ArrayReference) {
                n2 = ((ArrayReference)value).length();
            } else if (value instanceof ObjectReference && DebugSettings.getCurrent().showLogicalStructure && iEvaluationProvider != null) {
                try {
                    object2 = JavaLogicalStructureManager.getLogicalStructure((ObjectReference)value);
                    if (object2 != null && ((JavaLogicalStructure)object2).getSizeExpression() != null && (value2 = ((JavaLogicalStructure)object2).getSize((ObjectReference)value, stackFrame.thread(), iEvaluationProvider)) != null && value2 instanceof IntegerValue) {
                        n2 = ((IntegerValue)value2).value();
                    }
                }
                catch (IllegalArgumentException | InterruptedException | UnsupportedOperationException | CancellationException | ExecutionException exception) {
                    this.logger.log(Level.INFO, String.format("Failed to get the logical size for the type %s.", value.type().name()), exception);
                }
            }
            object2 = new Types.Variable(string, iVariableFormatter.valueToString(value, map));
            ((Types.Variable)object2).indexedVariables = Math.max(n2, 0);
            String string2 = null;
            if (value2 != null) {
                string2 = "size=" + iVariableFormatter.valueToString(value2, map);
            } else if (DebugSettings.getCurrent().showToString) {
                string2 = VariableDetailUtils.formatDetailsValue(value, stackFrame.thread(), iVariableFormatter, map, iEvaluationProvider);
            }
            if (string2 != null) {
                ((Types.Variable)object2).value = ((Types.Variable)object2).value + " " + string2;
            }
            object[i] = object2;
            hashMap.put(inlineVariableArray[i], object2);
        }
        response.body = new Responses.InlineValuesResponse((Types.Variable[])object);
        return CompletableFuture.completedFuture(response);
    }

    private static boolean isCapturedLocalVariable(String string, String string2) {
        String string3 = "val$" + string2;
        return Objects.equals(string, string3) || string.startsWith(string3 + "$") && NumberUtils.isDigits((String)string.substring(string3.length() + 1));
    }

    private static boolean isCapturedThisVariable(String string) {
        if (string.startsWith("this$")) {
            String string2 = string.substring(5).replaceAll("\\$+$", "");
            return NumberUtils.isDigits((String)string2);
        }
        return false;
    }

    private static boolean isLambdaFrame(StackFrame stackFrame) {
        Method method = stackFrame.location().method();
        return method.isSynthetic() && method.name().startsWith("lambda$");
    }

    private void resolveValuesFromThisVariable(ObjectReference objectReference, Requests.InlineVariable[] inlineVariableArray, Variable[] variableArray, boolean bl) {
        if (objectReference == null) {
            return;
        }
        int n = 0;
        for (Variable variable : variableArray) {
            if (variable != null) continue;
            ++n;
        }
        try {
            ReferenceType referenceType = objectReference.referenceType();
            String string = referenceType.name();
            ObjectReference objectReference2 = null;
            for (Field field : referenceType.allFields()) {
                String string2 = field.name();
                boolean bl2 = field.isSynthetic();
                Value value = null;
                for (int i = 0; i < inlineVariableArray.length; ++i) {
                    if (variableArray[i] != null) continue;
                    Requests.InlineVariable inlineVariable = inlineVariableArray[i];
                    boolean bl3 = inlineVariable.declaringClass != null;
                    boolean bl4 = false;
                    if (bl) {
                        bl4 = !bl3 && Objects.equals(string2, inlineVariable.expression);
                    } else {
                        Value value2;
                        boolean bl5 = bl3 && Objects.equals(string2, inlineVariable.expression) && Objects.equals(string, inlineVariable.declaringClass);
                        boolean bl6 = !bl3 && bl2 && InlineValuesRequestHandler.isCapturedLocalVariable(string2, inlineVariable.expression);
                        boolean bl7 = bl4 = bl5 || bl6;
                        if (!bl4 && bl2 && objectReference2 == null && InlineValuesRequestHandler.isCapturedThisVariable(string2) && (value2 = objectReference.getValue(field)) instanceof ObjectReference) {
                            objectReference2 = (ObjectReference)value2;
                            break;
                        }
                    }
                    if (!bl4) continue;
                    value = value == null ? objectReference.getValue(field) : value;
                    variableArray[i] = new Variable(inlineVariable.expression, value);
                    --n;
                }
                if (n > 0) continue;
                break;
            }
            if (n > 0 && objectReference2 != null) {
                this.resolveValuesFromThisVariable(objectReference2, inlineVariableArray, variableArray, bl);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

